/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.monster.EntityPigZombie;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableAngerableData;
import org.spongepowered.api.data.manipulator.mutable.entity.AngerableData;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeAngerableData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.value.SpongeValueFactory;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;

public class AngerableDataProcessor
extends AbstractEntitySingleDataProcessor<EntityPigZombie, Integer, MutableBoundedValue<Integer>, AngerableData, ImmutableAngerableData> {
    public AngerableDataProcessor() {
        super(EntityPigZombie.class, Keys.ANGER);
    }

    @Override
    protected MutableBoundedValue<Integer> constructValue(Integer actualValue) {
        return SpongeValueFactory.boundedBuilder(Keys.ANGER).actualValue(actualValue).defaultValue(0).minimum(Integer.MIN_VALUE).maximum(Integer.MAX_VALUE).build();
    }

    @Override
    protected boolean set(EntityPigZombie entity, Integer value) {
        entity.field_70837_d = value;
        return true;
    }

    @Override
    protected Optional<Integer> getVal(EntityPigZombie entity) {
        return Optional.of(entity.field_70837_d);
    }

    @Override
    protected ImmutableValue<Integer> constructImmutableValue(Integer value) {
        return new ImmutableSpongeValue<Integer>(Keys.ANGER, 0, value);
    }

    @Override
    protected AngerableData createManipulator() {
        return new SpongeAngerableData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

