/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.data.entity;

import java.util.Optional;
import net.minecraft.entity.passive.EntityOcelot;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableOcelotData;
import org.spongepowered.api.data.manipulator.mutable.entity.OcelotData;
import org.spongepowered.api.data.type.OcelotType;
import org.spongepowered.api.data.type.OcelotTypes;
import org.spongepowered.api.data.value.ValueContainer;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeOcelotData;
import org.spongepowered.common.data.processor.common.AbstractEntitySingleDataProcessor;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeValue;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.entity.SpongeOcelotType;
import org.spongepowered.common.registry.type.entity.OcelotTypeRegistryModule;

public class OcelotDataProcessor
extends AbstractEntitySingleDataProcessor<EntityOcelot, OcelotType, Value<OcelotType>, OcelotData, ImmutableOcelotData> {
    public OcelotDataProcessor() {
        super(EntityOcelot.class, Keys.OCELOT_TYPE);
    }

    @Override
    protected Value<OcelotType> constructValue(OcelotType actualValue) {
        return new SpongeValue<OcelotType>(Keys.OCELOT_TYPE, DataConstants.Catalog.DEFAULT_OCELOT, actualValue);
    }

    @Override
    protected boolean set(EntityOcelot entity, OcelotType value) {
        if (value instanceof SpongeOcelotType) {
            entity.func_70912_b(((SpongeOcelotType)value).type);
            return true;
        }
        return false;
    }

    @Override
    protected Optional<OcelotType> getVal(EntityOcelot entity) {
        return Optional.ofNullable(OcelotTypeRegistryModule.OCELOT_IDMAP.get(entity.func_70913_u()));
    }

    @Override
    protected ImmutableValue<OcelotType> constructImmutableValue(OcelotType value) {
        return ImmutableSpongeValue.cachedOf(Keys.OCELOT_TYPE, OcelotTypes.WILD_OCELOT, value);
    }

    @Override
    protected OcelotData createManipulator() {
        return new SpongeOcelotData();
    }

    @Override
    public DataTransactionResult removeFrom(ValueContainer<?> container) {
        return DataTransactionResult.failNoData();
    }
}

