/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.processor.multi.entity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityFallingBlock;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataTransactionResult;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.immutable.entity.ImmutableFallingBlockData;
import org.spongepowered.api.data.manipulator.mutable.entity.FallingBlockData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeFallingBlockData;
import org.spongepowered.common.data.processor.common.AbstractEntityDataProcessor;
import org.spongepowered.common.data.util.DataUtil;

public class FallingBlockDataProcessor
extends AbstractEntityDataProcessor<EntityFallingBlock, FallingBlockData, ImmutableFallingBlockData> {
    public FallingBlockDataProcessor() {
        super(EntityFallingBlock.class);
    }

    @Override
    protected boolean doesDataExist(EntityFallingBlock entity) {
        return true;
    }

    @Override
    protected boolean set(EntityFallingBlock entity, Map<Key<?>, Object> keyValues) {
        entity.field_145816_i = ((Double)keyValues.get(Keys.FALL_DAMAGE_PER_BLOCK)).floatValue();
        entity.field_145815_h = ((Double)keyValues.get(Keys.MAX_FALL_DAMAGE)).intValue();
        entity.field_175132_d = (IBlockState)keyValues.get(Keys.FALLING_BLOCK_STATE);
        entity.field_145808_f = (Boolean)keyValues.get(Keys.CAN_PLACE_AS_BLOCK) == false;
        entity.field_145813_c = (Boolean)keyValues.get(Keys.CAN_DROP_AS_ITEM);
        entity.field_145812_b = (Integer)keyValues.get(Keys.FALL_TIME);
        entity.field_145809_g = (Boolean)keyValues.get(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES);
        return true;
    }

    @Override
    protected Map<Key<?>, ?> getValues(EntityFallingBlock entity) {
        return ImmutableMap.builder().put(Keys.FALL_DAMAGE_PER_BLOCK, (Object)entity.field_145816_i).put(Keys.MAX_FALL_DAMAGE, (Object)entity.field_145815_h).put(Keys.FALLING_BLOCK_STATE, (Object)entity.field_175132_d).put(Keys.CAN_PLACE_AS_BLOCK, (Object)(!entity.field_145808_f ? 1 : 0)).put(Keys.CAN_DROP_AS_ITEM, (Object)entity.field_145813_c).put(Keys.FALL_TIME, (Object)entity.field_145812_b).put(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, (Object)entity.field_145809_g).build();
    }

    @Override
    protected FallingBlockData createManipulator() {
        return new SpongeFallingBlockData();
    }

    @Override
    public Optional<FallingBlockData> fill(DataContainer container, FallingBlockData fallingBlockData) {
        fallingBlockData.set(Keys.FALL_DAMAGE_PER_BLOCK, DataUtil.getData(container, Keys.FALL_DAMAGE_PER_BLOCK));
        fallingBlockData.set(Keys.MAX_FALL_DAMAGE, DataUtil.getData(container, Keys.MAX_FALL_DAMAGE));
        fallingBlockData.set(Keys.FALLING_BLOCK_STATE, DataUtil.getData(container, Keys.FALLING_BLOCK_STATE));
        fallingBlockData.set(Keys.CAN_PLACE_AS_BLOCK, DataUtil.getData(container, Keys.CAN_PLACE_AS_BLOCK));
        fallingBlockData.set(Keys.CAN_DROP_AS_ITEM, DataUtil.getData(container, Keys.CAN_DROP_AS_ITEM));
        fallingBlockData.set(Keys.FALL_TIME, DataUtil.getData(container, Keys.FALL_TIME));
        fallingBlockData.set(Keys.FALLING_BLOCK_CAN_HURT_ENTITIES, DataUtil.getData(container, Keys.FALLING_BLOCK_CAN_HURT_ENTITIES));
        return Optional.of(fallingBlockData);
    }

    @Override
    public DataTransactionResult remove(DataHolder dataHolder) {
        return DataTransactionResult.failNoData();
    }
}

