/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.util;

import com.google.common.collect.ComparisonChain;
import java.util.Comparator;
import org.spongepowered.api.data.persistence.DataContentUpdater;
import org.spongepowered.api.data.property.PropertyStore;
import org.spongepowered.common.data.DataProcessor;
import org.spongepowered.common.data.ValueProcessor;
import org.spongepowered.common.data.nbt.data.NbtDataProcessor;

public class ComparatorUtil {
    public static final Comparator<ValueProcessor<?, ?>> VALUE_PROCESSOR_COMPARATOR = (o1, o2) -> ComparatorUtil.intComparator().compare(o2.getPriority(), o1.getPriority());
    public static final Comparator<DataProcessor<?, ?>> DATA_PROCESSOR_COMPARATOR = (o1, o2) -> ComparatorUtil.intComparator().compare(o2.getPriority(), o1.getPriority());
    public static final Comparator<PropertyStore<?>> PROPERTY_STORE_COMPARATOR = (o1, o2) -> ComparatorUtil.intComparator().compare(o2.getPriority(), o1.getPriority());
    public static final Comparator<DataContentUpdater> DATA_CONTENT_UPDATER_COMPARATOR = (o1, o2) -> ComparisonChain.start().compare(o2.getInputVersion(), o1.getInputVersion()).compare(o2.getOutputVersion(), o1.getOutputVersion()).result();
    public static final Comparator<? super NbtDataProcessor<?, ?>> NBT_PROCESSOR_COMPARATOR = (o1, o2) -> ComparisonChain.start().compare(o2.getPriority(), o1.getPriority()).result();

    public static Comparator<Integer> intComparator() {
        return Integer::compareTo;
    }

    public static Comparator<Long> longComparator() {
        return Long::compareTo;
    }

    public static Comparator<Short> shortComparator() {
        return Short::compareTo;
    }

    public static Comparator<Byte> byteComparator() {
        return Byte::compareTo;
    }

    public static Comparator<Double> doubleComparator() {
        return Double::compareTo;
    }

    public static Comparator<Float> floatComparator() {
        return Float::compareTo;
    }
}

