/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.data.value.immutable;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Function;
import java.util.function.Predicate;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.data.value.immutable.ImmutableListValue;
import org.spongepowered.api.data.value.mutable.ListValue;
import org.spongepowered.common.data.value.immutable.ImmutableSpongeCollectionValue;
import org.spongepowered.common.data.value.mutable.SpongeListValue;

public class ImmutableSpongeListValue<E>
extends ImmutableSpongeCollectionValue<E, List<E>, ImmutableListValue<E>, ListValue<E>>
implements ImmutableListValue<E> {
    public ImmutableSpongeListValue(Key<? extends BaseValue<List<E>>> key, ImmutableList<E> actualValue) {
        super(key, ImmutableList.of(), actualValue);
    }

    @Override
    public ImmutableListValue<E> with(List<E> value) {
        return new ImmutableSpongeListValue<E>(this.getKey(), ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(value))));
    }

    @Override
    public ImmutableListValue<E> transform(Function<List<E>, List<E>> function) {
        return new ImmutableSpongeListValue<E>(this.getKey(), ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(((Function)Preconditions.checkNotNull(function)).apply(this.actualValue)))));
    }

    @Override
    public ListValue<E> asMutable() {
        ArrayList list = Lists.newArrayList();
        list.addAll((Collection)this.actualValue);
        return new SpongeListValue(this.getKey(), list);
    }

    @Override
    public ImmutableListValue<E> withElement(E elements) {
        return new ImmutableSpongeListValue<E>(this.getKey(), ImmutableList.builder().addAll((Iterable)this.actualValue).add(elements).build());
    }

    @Override
    public ImmutableListValue<E> withAll(Iterable<E> elements) {
        return new ImmutableSpongeListValue<E>(this.getKey(), ImmutableList.builder().addAll((Iterable)this.actualValue).addAll(elements).build());
    }

    @Override
    public ImmutableListValue<E> without(E element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existingElement -> !existingElement.equals(element)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableListValue<E> withoutAll(Iterable<E> elements) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existingElement -> !Iterables.contains((Iterable)elements, (Object)existingElement)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableListValue<E> withoutAll(Predicate<E> predicate) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ((List)this.actualValue).stream().filter(existing -> ((Predicate)Preconditions.checkNotNull((Object)predicate)).test(existing)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public List<E> getAll() {
        ArrayList list = Lists.newArrayList();
        list.addAll((Collection)this.actualValue);
        return list;
    }

    @Override
    public E get(int index) {
        return ((List)this.actualValue).get(index);
    }

    @Override
    public ImmutableListValue<E> with(int index, E value) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.add(Preconditions.checkNotNull(value));
                iterator.next();
                continue;
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableListValue<E> with(int index, Iterable<E> values) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.addAll(values);
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableListValue<E> without(int index) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) continue;
            builder.add(iterator.next());
        }
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public ImmutableListValue<E> set(int index, E element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        ListIterator iterator = ((List)this.actualValue).listIterator();
        while (iterator.hasNext()) {
            if (iterator.nextIndex() - 1 == index) {
                builder.add(Preconditions.checkNotNull(element));
                iterator.next();
                continue;
            }
            builder.add(iterator.next());
        }
        return new ImmutableSpongeListValue<E>(this.getKey(), builder.build());
    }

    @Override
    public int indexOf(E element) {
        return ((List)this.actualValue).indexOf(element);
    }
}

