/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.damage;

import com.google.common.base.Preconditions;
import java.lang.ref.WeakReference;
import net.minecraft.entity.Entity;
import org.spongepowered.api.event.cause.entity.damage.source.EntityDamageSource;
import org.spongepowered.api.event.cause.entity.damage.source.common.AbstractDamageSourceBuilder;

public class SpongeEntityDamageSourceBuilder
extends AbstractDamageSourceBuilder<EntityDamageSource, EntityDamageSource.Builder>
implements EntityDamageSource.Builder {
    protected WeakReference<org.spongepowered.api.entity.Entity> reference = null;

    @Override
    public SpongeEntityDamageSourceBuilder entity(org.spongepowered.api.entity.Entity entity) {
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(entity);
        return this;
    }

    @Override
    public EntityDamageSource build() throws IllegalStateException {
        Preconditions.checkState((this.damageType != null ? 1 : 0) != 0, (Object)"Damage type cannot be null!");
        Preconditions.checkState((this.reference.get() != null ? 1 : 0) != 0);
        net.minecraft.util.EntityDamageSource damageSource = new net.minecraft.util.EntityDamageSource(this.damageType.getId(), (Entity)this.reference.get());
        if (this.creative) {
            damageSource.func_76359_i();
        }
        if (this.scales) {
            damageSource.func_76351_m();
        }
        if (this.magical) {
            damageSource.func_82726_p();
        }
        if (this.bypasses) {
            damageSource.func_76348_h();
        }
        if (this.absolute) {
            damageSource.func_151518_m();
        }
        if (this.explosion) {
            damageSource.func_94540_d();
        }
        if (this.exhaustion != null) {
            damageSource.field_76384_q = this.exhaustion.floatValue();
        }
        return (EntityDamageSource)damageSource;
    }

    @Override
    public EntityDamageSource.Builder from(EntityDamageSource value) {
        super.from(value);
        this.reference = new WeakReference<org.spongepowered.api.entity.Entity>(value.getSource());
        return this;
    }

    @Override
    public SpongeEntityDamageSourceBuilder reset() {
        super.reset();
        this.reference = null;
        return this;
    }
}

