/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3i;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockEventData;
import net.minecraft.block.BlockRedstoneLight;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import org.apache.logging.log4j.Level;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.Transaction;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.block.ChangeBlockEvent;
import org.spongepowered.api.event.block.TickBlockEvent;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.spawn.SpawnTypes;
import org.spongepowered.api.event.item.inventory.DropItemEvent;
import org.spongepowered.api.world.BlockChangeFlag;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.LocatableBlock;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.block.BlockUtil;
import org.spongepowered.common.block.SpongeBlockSnapshot;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.PhaseData;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.context.ItemDropData;
import org.spongepowered.common.event.tracking.phase.block.BlockPhase;
import org.spongepowered.common.event.tracking.phase.tick.BlockTickContext;
import org.spongepowered.common.event.tracking.phase.tick.DimensionContext;
import org.spongepowered.common.event.tracking.phase.tick.EntityTickContext;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.event.tracking.phase.tick.TileEntityTickContext;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.block.IMixinBlockEventData;
import org.spongepowered.common.interfaces.block.tile.IMixinTileEntity;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.item.inventory.util.ItemStackUtil;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;
import org.spongepowered.common.world.BlockChange;
import org.spongepowered.common.world.SpongeBlockChangeFlag;
import org.spongepowered.common.world.SpongeLocatableBlockBuilder;
import org.spongepowered.common.world.WorldUtil;

public final class TrackingUtil {
    public static final int BREAK_BLOCK_INDEX = 0;
    public static final int PLACE_BLOCK_INDEX = 1;
    public static final int DECAY_BLOCK_INDEX = 2;
    public static final int CHANGE_BLOCK_INDEX = 3;
    private static final int MULTI_CHANGE_INDEX = 4;
    private static final Function<ImmutableList.Builder<Transaction<BlockSnapshot>>[], Consumer<Transaction<BlockSnapshot>>> TRANSACTION_PROCESSOR = builders -> transaction -> {
        BlockChange blockChange = ((SpongeBlockSnapshot)transaction.getOriginal()).blockChange;
        builders[blockChange.ordinal()].add(transaction);
        builders[4].add(transaction);
    };
    private static final int EVENT_COUNT = 5;
    static final Function<BlockSnapshot, Transaction<BlockSnapshot>> TRANSACTION_CREATION = blockSnapshot -> {
        Location<World> originalLocation = blockSnapshot.getLocation().get();
        WorldServer worldServer = (WorldServer)originalLocation.getExtent();
        BlockPos blockPos = VecHelper.toBlockPos(originalLocation);
        IBlockState newState = worldServer.func_180495_p(blockPos);
        IBlockState newActualState = newState.func_185899_b((IBlockAccess)worldServer, blockPos);
        SpongeBlockSnapshot newSnapshot = ((IMixinWorldServer)worldServer).createSpongeBlockSnapshot(newState, newActualState, blockPos, BlockChangeFlags.NONE);
        return new Transaction<SpongeBlockSnapshot>((SpongeBlockSnapshot)blockSnapshot, newSnapshot);
    };

    public static void tickEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        if (!mixinEntity.shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext().source(entity);
        try (EntityTickContext context = tickContext;
             Timing entityTiming = mixinEntity.getTimingsHandler();){
            mixinEntity.getNotifierUser().ifPresent(context::notifier);
            mixinEntity.getCreatorUser().ifPresent(context::owner);
            context.buildAndSwitch();
            entityTiming.startTiming();
            entity.func_70071_h_();
            if (ShouldFire.MOVE_ENTITY_EVENT_POSITION || ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callMoveEntityEvent(entity, context);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickRidingEntity(net.minecraft.entity.Entity entity) {
        Preconditions.checkArgument((boolean)(entity instanceof Entity), (String)"Entity %s is not an instance of SpongeAPI's Entity!", (Object)entity);
        Preconditions.checkNotNull((Object)entity, (Object)"Cannot capture on a null ticking entity!");
        IMixinEntity mixinEntity = EntityUtil.toMixin(entity);
        if (!mixinEntity.shouldTick()) {
            return;
        }
        EntityTickContext tickContext = TickPhase.Tick.ENTITY.createPhaseContext().source(entity);
        try (EntityTickContext context = tickContext;
             Timing entityTiming = mixinEntity.getTimingsHandler();){
            entityTiming.startTiming();
            mixinEntity.getNotifierUser().ifPresent(context::notifier);
            mixinEntity.getCreatorUser().ifPresent(context::owner);
            context.buildAndSwitch();
            entity.func_70098_U();
            if (ShouldFire.MOVE_ENTITY_EVENT_POSITION || ShouldFire.ROTATE_ENTITY_EVENT) {
                SpongeCommonEventFactory.callMoveEntityEvent(entity, context);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, tickContext);
        }
    }

    public static void tickTileEntity(IMixinWorldServer mixinWorldServer, ITickable tile) {
        Preconditions.checkArgument((boolean)(tile instanceof org.spongepowered.api.block.tileentity.TileEntity), (String)"ITickable %s is not a TileEntity!", (Object)tile);
        Preconditions.checkNotNull((Object)tile, (Object)"Cannot capture on a null ticking tile entity!");
        TileEntity tileEntity = (TileEntity)tile;
        IMixinTileEntity mixinTileEntity = (IMixinTileEntity)tile;
        BlockPos pos = tileEntity.func_174877_v();
        IMixinChunk chunk = ((IMixinTileEntity)tile).getActiveChunk();
        if (!mixinTileEntity.shouldTick()) {
            return;
        }
        TileEntityTickContext context = TickPhase.Tick.TILE_ENTITY.createPhaseContext().source(mixinTileEntity);
        try (TileEntityTickContext phaseContext = context;){
            User blockOwner;
            User blockNotifier = mixinTileEntity.getSpongeNotifier();
            if (blockNotifier != null) {
                phaseContext.notifier(blockNotifier);
            }
            if ((blockOwner = mixinTileEntity.getSpongeOwner()) != null) {
                phaseContext.owner(blockOwner);
            }
            phaseContext.buildAndSwitch();
            mixinTileEntity.setIsTicking(true);
            try (Timing timing = mixinTileEntity.getTimingsHandler().startTiming();){
                tile.func_73660_a();
            }
            if (tileEntity.func_145837_r()) {
                mixinTileEntity.setActiveChunk(null);
            }
        }
        catch (Exception e) {
            PhaseTracker.getInstance().printExceptionFromPhase(e, context);
        }
        mixinTileEntity.setIsTicking(false);
    }

    public static void updateTickBlock(IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer world = WorldUtil.asNative(mixinWorld);
        World apiWorld = WorldUtil.fromNative((net.minecraft.world.World)world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot snapshot = mixinWorld.createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Scheduled event = SpongeEventFactory.createTickBlockEventScheduled(Sponge.getCauseStackManager().getCurrentCause(), snapshot);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.BLOCK.createPhaseContext().source(locatable);
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        PhaseData current = phaseTracker.getCurrentPhaseData();
        IPhaseState<?> currentState = current.state;
        currentState.appendNotifierPreBlockTick(mixinWorld, pos, current.context, phaseContext);
        try (BlockTickContext context = phaseContext;
             Timing timing = BlockUtil.toMixin(state).getTimingsHandler();){
            timing.startTiming();
            context.buildAndSwitch();
            block.func_180650_b((net.minecraft.world.World)world, pos, state, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            phaseTracker.printExceptionFromPhase(e, phaseContext);
        }
    }

    public static void randomTickBlock(PhaseTracker phaseTracker, IMixinWorldServer mixinWorld, Block block, BlockPos pos, IBlockState state, Random random) {
        WorldServer world = WorldUtil.asNative(mixinWorld);
        World apiWorld = WorldUtil.fromNative((net.minecraft.world.World)world);
        if (ShouldFire.TICK_BLOCK_EVENT) {
            SpongeBlockSnapshot currentTickBlock = mixinWorld.createSpongeBlockSnapshot(state, state, pos, BlockChangeFlags.NONE);
            TickBlockEvent.Random event = SpongeEventFactory.createTickBlockEventRandom(Sponge.getCauseStackManager().getCurrentCause(), currentTickBlock);
            SpongeImpl.postEvent(event);
            if (event.isCancelled()) {
                return;
            }
        }
        LocatableBlock locatable = new SpongeLocatableBlockBuilder().world(apiWorld).position(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()).state((BlockState)state).build();
        BlockTickContext phaseContext = TickPhase.Tick.RANDOM_BLOCK.createPhaseContext().source(locatable);
        PhaseData current = phaseTracker.getCurrentPhaseData();
        IPhaseState<?> currentState = current.state;
        currentState.appendNotifierPreBlockTick(mixinWorld, pos, current.context, phaseContext);
        try (BlockTickContext context = phaseContext;){
            context.buildAndSwitch();
            block.func_180645_a((net.minecraft.world.World)world, pos, state, random);
        }
        catch (Exception | NoClassDefFoundError e) {
            phaseTracker.printExceptionFromPhase(e, phaseContext);
        }
    }

    public static void tickWorldProvider(IMixinWorldServer worldServer) {
        WorldProvider worldProvider = ((WorldServer)worldServer).field_73011_w;
        try (DimensionContext context = (DimensionContext)TickPhase.Tick.DIMENSION.createPhaseContext().source(worldProvider);){
            context.buildAndSwitch();
            worldProvider.func_186059_r();
        }
    }

    public static boolean fireMinecraftBlockEvent(WorldServer worldIn, BlockEventData event) {
        IBlockState currentState = worldIn.func_180495_p(event.func_180328_a());
        IMixinBlockEventData blockEvent = (IMixinBlockEventData)event;
        try (Object context = TickPhase.Tick.BLOCK_EVENT.createPhaseContext().source(blockEvent);){
            ((PhaseContext)context).buildAndSwitch();
            User user = ((IMixinBlockEventData)event).getSourceUser();
            if (user != null) {
                ((PhaseContext)context).owner = user;
                ((PhaseContext)context).notifier = user;
            }
            boolean bl = currentState.func_189547_a((net.minecraft.world.World)worldIn, event.func_180328_a(), event.func_151339_d(), event.func_151338_e());
            return bl;
        }
    }

    static boolean captureBulkBlockChange(IMixinWorldServer mixinWorld, Chunk chunk, IBlockState currentState, IBlockState newState, BlockPos pos, BlockChangeFlag flags, PhaseContext<?> phaseContext, IPhaseState<?> phaseState) {
        WorldServer world = WorldUtil.asNative(mixinWorld);
        if (phaseState.shouldCaptureBlockChangeOrSkip(phaseContext, pos)) {
            SpongeBlockSnapshot originalBlockSnapshot = mixinWorld.createSpongeBlockSnapshot(currentState, currentState, pos, flags);
            List<BlockSnapshot> capturedSnapshots = phaseContext.getCapturedBlocks();
            Block newBlock = newState.func_177230_c();
            TrackingUtil.associateBlockChangeWithSnapshot(phaseState, newBlock, currentState, originalBlockSnapshot, capturedSnapshots);
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot, BlockChangeFlags.ALL);
            if (originalBlockState == null) {
                capturedSnapshots.remove(originalBlockSnapshot);
                return false;
            }
            phaseState.postTrackBlock(originalBlockSnapshot, phaseContext);
        } else {
            IMixinChunk mixinChunk = (IMixinChunk)chunk;
            SpongeBlockSnapshot originalBlockSnapshot = (SpongeBlockSnapshot)BlockSnapshot.NONE;
            IBlockState originalBlockState = mixinChunk.setBlockState(pos, newState, currentState, originalBlockSnapshot, BlockChangeFlags.ALL);
            if (originalBlockState == null) {
                return false;
            }
        }
        if (newState.func_185891_c() != currentState.func_185891_c() || newState.func_185906_d() != currentState.func_185906_d()) {
            world.field_72984_F.func_76320_a("checkLight");
            world.func_175664_x(pos);
            world.field_72984_F.func_76319_b();
        }
        return true;
    }

    static void associateBlockChangeWithSnapshot(IPhaseState<?> phaseState, Block newBlock, IBlockState currentState, SpongeBlockSnapshot snapshot, List<BlockSnapshot> capturedSnapshots) {
        Block originalBlock = currentState.func_177230_c();
        if (phaseState == BlockPhase.State.BLOCK_DECAY) {
            if (newBlock == Blocks.field_150350_a) {
                snapshot.blockChange = BlockChange.DECAY;
                capturedSnapshots.add(snapshot);
            }
        } else if (newBlock == Blocks.field_150350_a) {
            snapshot.blockChange = BlockChange.BREAK;
            capturedSnapshots.add(snapshot);
        } else if (newBlock != originalBlock && !TrackingUtil.forceModify(originalBlock, newBlock)) {
            snapshot.blockChange = BlockChange.PLACE;
            capturedSnapshots.add(snapshot);
        } else {
            snapshot.blockChange = BlockChange.MODIFY;
            capturedSnapshots.add(snapshot);
        }
    }

    private static boolean forceModify(Block originalBlock, Block newBlock) {
        if (originalBlock instanceof BlockRedstoneRepeater && newBlock instanceof BlockRedstoneRepeater) {
            return true;
        }
        if (originalBlock instanceof BlockRedstoneTorch && newBlock instanceof BlockRedstoneTorch) {
            return true;
        }
        return originalBlock instanceof BlockRedstoneLight && newBlock instanceof BlockRedstoneLight;
    }

    private TrackingUtil() {
    }

    @Nullable
    public static User getNotifierOrOwnerFromBlock(Location<World> location) {
        BlockPos blockPos = VecHelper.toBlockPos(location);
        return TrackingUtil.getNotifierOrOwnerFromBlock((WorldServer)location.getExtent(), blockPos);
    }

    @Nullable
    private static User getNotifierOrOwnerFromBlock(WorldServer world, BlockPos blockPos) {
        IMixinChunk mixinChunk = (IMixinChunk)world.func_175726_f(blockPos);
        User notifier = mixinChunk.getBlockNotifier(blockPos).orElse(null);
        if (notifier != null) {
            return notifier;
        }
        return mixinChunk.getBlockOwner(blockPos).orElse(null);
    }

    public static Supplier<IllegalStateException> throwWithContext(String s, PhaseContext<?> phaseContext) {
        return () -> {
            PrettyPrinter printer = new PrettyPrinter(60);
            printer.add("Exception trying to process over a phase!").centre().hr();
            printer.addWrapped(40, "%s : %s", "State", phaseContext.state);
            printer.addWrapped(40, "%s :", "PhaseContext");
            PhaseTracker.CONTEXT_PRINTER.accept(printer, phaseContext);
            printer.add("Stacktrace:");
            IllegalStateException exception = new IllegalStateException(s + " Please analyze the current phase context. ");
            printer.add(exception);
            printer.trace(System.err, SpongeImpl.getLogger(), Level.ERROR);
            return exception;
        };
    }

    public static boolean processBlockCaptures(List<BlockSnapshot> snapshots, IPhaseState<?> state, PhaseContext<?> context) {
        return TrackingUtil.processBlockCaptures(snapshots, state, context, 0);
    }

    public static boolean processBlockCaptures(List<BlockSnapshot> snapshots, IPhaseState<?> state, PhaseContext<?> context, int currentDepth) {
        if (snapshots.isEmpty()) {
            return false;
        }
        ArrayList<ChangeBlockEvent> blockEvents = new ArrayList<ChangeBlockEvent>();
        ImmutableList[] transactionArrays = new ImmutableList[5];
        ImmutableList.Builder[] transactionBuilders = new ImmutableList.Builder[5];
        for (int i = 0; i < 5; ++i) {
            transactionBuilders[i] = new ImmutableList.Builder();
        }
        TrackingUtil.createTransactionLists(snapshots, transactionArrays, transactionBuilders);
        context.getCapturedBlocksOrEmptyList().clear();
        ChangeBlockEvent[] mainEvents = new ChangeBlockEvent[BlockChange.values().length];
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            try {
                state.associateAdditionalCauses(context, frame);
            }
            catch (Exception exception) {
                // empty catch block
            }
            TrackingUtil.iterateChangeBlockEvents(transactionArrays, blockEvents, mainEvents);
            ChangeBlockEvent.Post postEvent = TrackingUtil.throwMultiEventsAndCreatePost(state, context, transactionArrays, blockEvents, mainEvents);
            if (postEvent == null) {
                boolean bl = false;
                return bl;
            }
            ArrayList<Transaction<BlockSnapshot>> invalid = new ArrayList<Transaction<BlockSnapshot>>();
            boolean noCancelledTransactions = TrackingUtil.checkCancelledEvents(blockEvents, postEvent);
            TrackingUtil.clearInvalidTransactionDrops(context, postEvent, invalid);
            if (!invalid.isEmpty()) {
                noCancelledTransactions = false;
                TrackingUtil.rollBackTransactions(state, context, invalid);
                invalid.clear();
            }
            boolean bl = TrackingUtil.performBlockAdditions(postEvent.getTransactions(), state, context, noCancelledTransactions, currentDepth);
            return bl;
        }
    }

    private static void createTransactionLists(List<BlockSnapshot> snapshots, ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, ImmutableList.Builder<Transaction<BlockSnapshot>>[] transactionBuilders) {
        for (BlockSnapshot snapshot : snapshots) {
            TRANSACTION_PROCESSOR.apply(transactionBuilders).accept(TRANSACTION_CREATION.apply(snapshot));
        }
        for (int i = 0; i < 5; ++i) {
            transactionArrays[i] = transactionBuilders[i].build();
        }
    }

    private static boolean checkCancelledEvents(List<ChangeBlockEvent> blockEvents, ChangeBlockEvent.Post postEvent) {
        boolean noCancelledTransactions = true;
        for (ChangeBlockEvent changeBlockEvent : blockEvents) {
            if (!changeBlockEvent.isCancelled()) continue;
            noCancelledTransactions = false;
            for (Transaction transaction : Lists.reverse(changeBlockEvent.getTransactions())) {
                transaction.setValid(false);
            }
        }
        if (postEvent.isCancelled()) {
            noCancelledTransactions = false;
            for (Transaction transaction : postEvent.getTransactions()) {
                transaction.setValid(false);
            }
        }
        return noCancelledTransactions;
    }

    private static void clearInvalidTransactionDrops(PhaseContext<?> context, ChangeBlockEvent.Post postEvent, List<Transaction<BlockSnapshot>> invalid) {
        for (Transaction<BlockSnapshot> transaction : postEvent.getTransactions()) {
            if (transaction.isValid()) continue;
            invalid.add(transaction);
            Location location = transaction.getOriginal().getLocation().orElse(null);
            if (location == null) continue;
            BlockPos pos = VecHelper.toBlockPos(location);
            context.getBlockItemDropSupplier().removeAllIfNotEmpty(pos);
            context.getPerBlockEntitySpawnSuppplier().removeAllIfNotEmpty(pos);
            context.getPerBlockEntitySpawnSuppplier().removeAllIfNotEmpty(pos);
        }
    }

    private static void rollBackTransactions(IPhaseState<?> state, PhaseContext<?> context, List<Transaction<BlockSnapshot>> invalid) {
        for (Transaction transaction : Lists.reverse(invalid)) {
            Location location;
            ((BlockSnapshot)transaction.getOriginal()).restore(true, BlockChangeFlags.NONE);
            if (!state.tracksBlockSpecificDrops(context) || (location = (Location)((BlockSnapshot)transaction.getOriginal()).getLocation().orElse(null)) == null) continue;
            BlockPos pos = VecHelper.toBlockPos(location);
            context.getBlockDropSupplier().removeAllIfNotEmpty(pos);
        }
    }

    private static void iterateChangeBlockEvents(ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        for (BlockChange blockChange : BlockChange.values()) {
            ChangeBlockEvent event;
            if (blockChange == BlockChange.DECAY || transactionArrays[blockChange.ordinal()].isEmpty()) continue;
            mainEvents[blockChange.ordinal()] = event = blockChange.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[blockChange.ordinal()]);
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
        if (!transactionArrays[BlockChange.DECAY.ordinal()].isEmpty()) {
            ChangeBlockEvent event;
            mainEvents[BlockChange.DECAY.ordinal()] = event = BlockChange.DECAY.createEvent(Sponge.getCauseStackManager().getCurrentCause(), transactionArrays[BlockChange.DECAY.ordinal()]);
            SpongeImpl.postEvent(event);
            blockEvents.add(event);
        }
    }

    private static boolean performBlockAdditions(List<Transaction<BlockSnapshot>> transactions, IPhaseState<?> phaseState, PhaseContext<?> phaseContext, boolean noCancelledTransactions, int currentDepth) {
        for (Transaction<BlockSnapshot> transaction : transactions) {
            noCancelledTransactions = TrackingUtil.performTransactionProcess(transaction, phaseState, phaseContext, noCancelledTransactions, currentDepth);
        }
        return noCancelledTransactions;
    }

    static boolean performTransactionProcess(Transaction<BlockSnapshot> transaction, IPhaseState<?> phaseState, PhaseContext<?> phaseContext, boolean noCancelledTransactions, int currentDepth) {
        if (!transaction.isValid()) {
            return noCancelledTransactions;
        }
        if (transaction.getCustom().isPresent()) {
            transaction.getFinal().restore(true, BlockChangeFlags.NONE);
        }
        SpongeBlockSnapshot oldBlockSnapshot = (SpongeBlockSnapshot)transaction.getOriginal();
        SpongeBlockSnapshot newBlockSnapshot = (SpongeBlockSnapshot)transaction.getFinal();
        Location<World> worldLocation = oldBlockSnapshot.getLocation().orElseThrow(() -> {
            IllegalStateException exception = new IllegalStateException("BlockSnapshot with Invalid Location");
            PhaseTracker.getInstance().printMessageWithCaughtException("BlockSnapshot does not have a valid location object, usually because the world is unloaded!", "", exception);
            return exception;
        });
        IMixinWorldServer mixinWorld = (IMixinWorldServer)((Object)worldLocation.getExtent());
        BlockPos pos = VecHelper.toBlockPos(worldLocation);
        TrackingUtil.performBlockEntitySpawns(phaseState, phaseContext, oldBlockSnapshot, pos);
        WorldServer world = WorldUtil.asNative(mixinWorld);
        SpongeHooks.logBlockAction((net.minecraft.world.World)world, oldBlockSnapshot.blockChange, transaction);
        SpongeBlockChangeFlag changeFlag = oldBlockSnapshot.getChangeFlag();
        IBlockState originalState = (IBlockState)oldBlockSnapshot.getState();
        IBlockState newState = (IBlockState)newBlockSnapshot.getState();
        Block newBlock = newState.func_177230_c();
        if (originalState.func_177230_c() != newBlock && changeFlag.performBlockPhysics() && !SpongeImplHooks.hasBlockTileEntity(newBlock, newState)) {
            newBlock.func_176213_c((net.minecraft.world.World)world, pos, newState);
            phaseState.performOnBlockAddedSpawns(phaseContext, currentDepth + 1);
        }
        phaseState.postBlockTransactionApplication(oldBlockSnapshot.blockChange, transaction, phaseContext);
        if (changeFlag.isNotifyClients()) {
            world.func_184138_a(pos, originalState, newState, changeFlag.getRawFlag());
        }
        if (changeFlag.updateNeighbors()) {
            PhaseTracker.getInstance().getCurrentContext().neighborNotificationSource = newBlockSnapshot;
            mixinWorld.spongeNotifyNeighborsPostBlockChange(pos, originalState, newState, changeFlag);
            PhaseTracker.getInstance().getCurrentContext().neighborNotificationSource = null;
        } else if (changeFlag.notifyObservers()) {
            world.func_190522_c(pos, newBlock);
        }
        phaseState.performPostBlockNotificationsAndNeighborUpdates(phaseContext, currentDepth + 1);
        return noCancelledTransactions;
    }

    private static void performBlockEntitySpawns(IPhaseState<?> state, PhaseContext<?> phaseContext, SpongeBlockSnapshot oldBlockSnapshot, BlockPos pos) {
        if (state.doesCaptureEntitySpawns() || state.doesCaptureEntityDrops(phaseContext)) {
            phaseContext.getBlockDropSupplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemDataForBlockDrops(items, oldBlockSnapshot, phaseContext));
            phaseContext.getBlockItemDropSupplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnItemEntitiesForBlockDrops(items, oldBlockSnapshot, phaseContext));
            phaseContext.getPerBlockEntitySpawnSuppplier().acceptAndRemoveIfPresent(pos, items -> TrackingUtil.spawnEntitiesForBlock(items, phaseContext));
        }
    }

    private static void spawnItemEntitiesForBlockDrops(Collection<EntityItem> entityItems, BlockSnapshot newBlockSnapshot, PhaseContext<?> phaseContext) {
        List<Entity> itemDrops = entityItems.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(newBlockSnapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            SpongeCommonEventFactory.callDropItemDestruct(itemDrops, phaseContext);
        }
    }

    public static void spawnItemDataForBlockDrops(Collection<ItemDropData> itemStacks, BlockSnapshot oldBlockSnapshot, PhaseContext<?> phaseContext) {
        Vector3i position = oldBlockSnapshot.getPosition();
        List itemSnapshots = itemStacks.stream().map(ItemDropData::getStack).map(ItemStackUtil::snapshotOf).collect(Collectors.toList());
        ImmutableList originalSnapshots = ImmutableList.copyOf(itemSnapshots);
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(oldBlockSnapshot);
            DropItemEvent.Pre dropItemEventPre = SpongeEventFactory.createDropItemEventPre(frame.getCurrentCause(), (List)originalSnapshots, itemSnapshots);
            SpongeImpl.postEvent(dropItemEventPre);
            if (dropItemEventPre.isCancelled()) {
                return;
            }
        }
        Location<World> worldLocation = oldBlockSnapshot.getLocation().get();
        World world = worldLocation.getExtent();
        WorldServer worldServer = (WorldServer)world;
        List<Entity> itemDrops = itemStacks.stream().map(itemStack -> {
            ItemStack minecraftStack = itemStack.getStack();
            float f = 0.5f;
            double offsetX = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetY = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double offsetZ = (double)(worldServer.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double x = (double)position.getX() + offsetX;
            double y = (double)position.getY() + offsetY;
            double z = (double)position.getZ() + offsetZ;
            EntityItem entityitem = new EntityItem((net.minecraft.world.World)worldServer, x, y, z, minecraftStack);
            entityitem.func_174869_p();
            return entityitem;
        }).map(EntityUtil::fromNative).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.pushCause(oldBlockSnapshot);
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.DROPPED_ITEM);
            phaseContext.applyNotifierIfAvailable(notifier -> frame.addContext(EventContextKeys.NOTIFIER, notifier));
            SpongeCommonEventFactory.callDropItemDestruct(itemDrops, phaseContext);
        }
    }

    private static void spawnEntitiesForBlock(Collection<net.minecraft.entity.Entity> entities, PhaseContext<?> phaseContext) {
        List<Entity> entitiesSpawned = entities.stream().map(EntityUtil::fromNative).collect(Collectors.toList());
        try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
            frame.addContext(EventContextKeys.SPAWN_TYPE, SpawnTypes.BLOCK_SPAWNING);
            SpongeCommonEventFactory.callSpawnEntity(entitiesSpawned, phaseContext);
        }
    }

    @Nullable
    private static ChangeBlockEvent.Post throwMultiEventsAndCreatePost(IPhaseState<?> state, PhaseContext<?> context, ImmutableList<Transaction<BlockSnapshot>>[] transactionArrays, List<ChangeBlockEvent> blockEvents, ChangeBlockEvent[] mainEvents) {
        if (!blockEvents.isEmpty()) {
            ImmutableList<Transaction<BlockSnapshot>> transactions = transactionArrays[4];
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                for (BlockChange blockChange : BlockChange.values()) {
                    ChangeBlockEvent mainEvent = mainEvents[blockChange.ordinal()];
                    if (mainEvent == null) continue;
                    frame.pushCause(mainEvent);
                }
                ChangeBlockEvent.Post post = state.createChangeBlockPostEvent(context, transactions);
                SpongeImpl.postEvent(post);
                ChangeBlockEvent.Post post2 = post;
                return post2;
            }
        }
        return null;
    }
}

