/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.data.type.HandType;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.asm.util.PrettyPrinter;
import org.spongepowered.common.event.tracking.PhaseContext;
import org.spongepowered.common.event.tracking.phase.packet.PacketState;

public class PacketContext<P extends PacketContext<P>>
extends PhaseContext<P> {
    @Nullable
    protected EntityPlayerMP packetPlayer;
    @Nullable
    Packet<?> packet;
    @Nullable
    private ItemStackSnapshot cursor;
    @Nullable
    private ItemStack itemUsed;
    @Nullable
    private BlockSnapshot targetBlock;
    @Nullable
    private HandType handUsed;
    private boolean ignoreCreative;
    private boolean interactItemChanged;

    protected PacketContext(PacketState<? extends P> state) {
        super(state);
    }

    public P packet(Packet<?> packet) {
        this.packet = packet;
        return (P)this;
    }

    public P packetPlayer(EntityPlayerMP playerMP) {
        this.packetPlayer = playerMP;
        return (P)this;
    }

    public P targetBlock(BlockSnapshot snapshot) {
        this.targetBlock = snapshot;
        return (P)this;
    }

    public P cursor(ItemStackSnapshot snapshot) {
        this.cursor = snapshot;
        return (P)this;
    }

    public P ignoreCreative(boolean creative) {
        this.ignoreCreative = creative;
        return (P)this;
    }

    public EntityPlayerMP getPacketPlayer() {
        return this.packetPlayer;
    }

    public Player getSpongePlayer() {
        return (Player)this.packetPlayer;
    }

    public <K extends Packet<?>> K getPacket() {
        return (K)this.packet;
    }

    public ItemStackSnapshot getCursor() {
        return this.cursor;
    }

    public BlockSnapshot getTargetBlock() {
        return this.targetBlock;
    }

    public boolean getIgnoringCreative() {
        return this.ignoreCreative;
    }

    public P itemUsed(ItemStack stack) {
        this.itemUsed = stack;
        return (P)this;
    }

    public ItemStack getItemUsed() {
        return this.itemUsed;
    }

    public P interactItemChanged(boolean changed) {
        this.interactItemChanged = changed;
        return (P)this;
    }

    public boolean getInteractItemChanged() {
        return this.interactItemChanged;
    }

    public P handUsed(HandType hand) {
        this.handUsed = hand;
        return (P)this;
    }

    public HandType getHandUsed() {
        return this.handUsed;
    }

    @Override
    public PrettyPrinter printCustom(PrettyPrinter printer, int indent) {
        String s = String.format("%1$" + indent + "s", "");
        return super.printCustom(printer, indent).add(s + "- %s: %s", "PacketPlayer", this.packetPlayer).add(s + "- %s: %s", "Packet", this.packet).add(s + "- %s: %s", "IgnoreCreative", this.ignoreCreative).add(s + "- %s: %s", "ItemStackUsed", this.itemUsed);
    }
}

