/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.event.tracking.phase.packet.drag;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.crafting.CraftingInventory;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.SlotTransaction;
import org.spongepowered.api.item.recipe.crafting.CraftingRecipe;
import org.spongepowered.api.world.World;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.tracking.phase.packet.PacketConstants;
import org.spongepowered.common.event.tracking.phase.packet.drag.NamedInventoryState;
import org.spongepowered.common.event.tracking.phase.packet.inventory.InventoryPacketContext;
import org.spongepowered.common.interfaces.IMixinContainer;
import org.spongepowered.common.item.recipe.crafting.SpongeCraftingRecipeRegistry;

public abstract class DragInventoryStopState
extends NamedInventoryState {
    public DragInventoryStopState(String name, int buttonId) {
        super(name, PacketConstants.MODE_DRAG | buttonId | 0x20 | 0x20000, 262143);
    }

    @Override
    public void populateContext(EntityPlayerMP playerMP, Packet<?> packet, InventoryPacketContext context) {
        super.populateContext(playerMP, packet, context);
        ((IMixinContainer)playerMP.field_71070_bA).setFirePreview(false);
    }

    @Override
    public void unwind(InventoryPacketContext context) {
        DragInventoryStopState.unwindCraftPreview(context);
        super.unwind(context);
    }

    public static void unwindCraftPreview(InventoryPacketContext context) {
        List<SlotTransaction> previewTransactions;
        EntityPlayerMP player = context.getPacketPlayer();
        ((IMixinContainer)player.field_71070_bA).setFirePreview(true);
        Object craftInv = ((Inventory)player.field_71070_bA).query(QueryOperationTypes.INVENTORY_TYPE.of(CraftingInventory.class));
        if (craftInv instanceof CraftingInventory && !(previewTransactions = ((IMixinContainer)player.field_71070_bA).getPreviewTransactions()).isEmpty()) {
            CraftingRecipe recipe = SpongeCraftingRecipeRegistry.getInstance().findMatchingRecipe(((CraftingInventory)craftInv).getCraftingGrid(), (World)player.field_70170_p).orElse(null);
            SpongeCommonEventFactory.callCraftEventPre((EntityPlayer)player, (CraftingInventory)craftInv, previewTransactions.get(0), recipe, player.field_71070_bA, previewTransactions);
            previewTransactions.clear();
        }
    }
}

