/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.concurrentchecks;

import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import org.spongepowered.api.Sponge;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.common.SpongeImpl;

@Mixin(value={PlayerChunkMap.class})
public abstract class MixinPlayerChunkMap_ConcurrentChecks {
    @Inject(method={"entryChanged"}, at={@At(value="HEAD")}, cancellable=true)
    private void onEntryChanged(PlayerChunkMapEntry entry, CallbackInfo ci) {
        if (!Sponge.getServer().isMainThread()) {
            SpongeImpl.getLogger().error(String.format("Tried to mark PlayerChunkMapEntry %s as dirty from off the main thread!", entry), (Throwable)new Exception("Dummy exception"));
            ci.cancel();
        }
    }

    @Inject(method={"removeEntry"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRemoveEntry(PlayerChunkMapEntry entry, CallbackInfo ci) {
        if (!Sponge.getServer().isMainThread()) {
            SpongeImpl.getLogger().error(String.format("Tried to remove PlayerChunkMapEntry %s from off the main thread!", entry), (Throwable)new Exception("Dummy exception"));
            ci.cancel();
        }
    }
}

