/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.block;

import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.immutable.block.ImmutableConnectedDirectionData;
import org.spongepowered.api.data.value.BaseValue;
import org.spongepowered.api.util.Direction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.data.ImmutableDataCachingUtil;
import org.spongepowered.common.data.manipulator.immutable.block.ImmutableSpongeConnectedDirectionData;
import org.spongepowered.common.mixin.core.block.MixinBlock;

@Mixin(value={BlockPane.class})
public abstract class MixinBlockPane
extends MixinBlock {
    @Override
    public List<ImmutableDataManipulator<?, ?>> getManipulators(IBlockState blockState) {
        return ImmutableList.of((Object)this.getConnectedDirectionData(blockState));
    }

    @Override
    public boolean supports(Class<? extends ImmutableDataManipulator<?, ?>> immutable) {
        return ImmutableConnectedDirectionData.class.isAssignableFrom(immutable);
    }

    @Override
    public Optional<BlockState> getStateWithData(IBlockState blockState, ImmutableDataManipulator<?, ?> manipulator) {
        if (manipulator instanceof ImmutableConnectedDirectionData) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithData(blockState, manipulator);
    }

    @Override
    public <E> Optional<BlockState> getStateWithValue(IBlockState blockState, Key<? extends BaseValue<E>> key, E value) {
        if (key.equals(Keys.CONNECTED_DIRECTIONS) || key.equals(Keys.CONNECTED_EAST) || key.equals(Keys.CONNECTED_NORTH) || key.equals(Keys.CONNECTED_SOUTH) || key.equals(Keys.CONNECTED_WEST)) {
            return Optional.of((BlockState)blockState);
        }
        return super.getStateWithValue(blockState, key, value);
    }

    private ImmutableConnectedDirectionData getConnectedDirectionData(IBlockState blockState) {
        HashSet<Direction> directions = new HashSet<Direction>();
        Boolean north = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176241_b);
        Boolean east = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176242_M);
        Boolean west = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176244_O);
        Boolean south = (Boolean)blockState.func_177229_b((IProperty)BlockPane.field_176243_N);
        if (north.booleanValue()) {
            directions.add(Direction.NORTH);
        }
        if (south.booleanValue()) {
            directions.add(Direction.SOUTH);
        }
        if (west.booleanValue()) {
            directions.add(Direction.WEST);
        }
        if (east.booleanValue()) {
            directions.add(Direction.EAST);
        }
        return ImmutableDataCachingUtil.getManipulator(ImmutableSpongeConnectedDirectionData.class, directions);
    }
}

