/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity;

import co.aikar.timings.Timing;
import com.flowpowered.math.vector.Vector3d;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityTracker;
import net.minecraft.entity.EntityTrackerEntry;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketDestroyEntities;
import net.minecraft.network.play.server.SPacketPlayerListItem;
import net.minecraft.network.play.server.SPacketPlayerPosLook;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.DataHolder;
import org.spongepowered.api.data.DataView;
import org.spongepowered.api.data.Queries;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.IgniteableData;
import org.spongepowered.api.data.manipulator.mutable.entity.VehicleData;
import org.spongepowered.api.data.persistence.InvalidDataException;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.EntityArchetype;
import org.spongepowered.api.entity.EntitySnapshot;
import org.spongepowered.api.entity.EntityType;
import org.spongepowered.api.entity.Transform;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.api.event.cause.EventContextKeys;
import org.spongepowered.api.event.cause.entity.dismount.DismountType;
import org.spongepowered.api.event.cause.entity.dismount.DismountTypes;
import org.spongepowered.api.event.cause.entity.teleport.TeleportTypes;
import org.spongepowered.api.event.entity.IgniteEntityEvent;
import org.spongepowered.api.event.entity.MoveEntityEvent;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.translation.Translation;
import org.spongepowered.api.util.AABB;
import org.spongepowered.api.util.Direction;
import org.spongepowered.api.util.RelativePositions;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Implements;
import org.spongepowered.asm.mixin.Interface;
import org.spongepowered.asm.mixin.Intrinsic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.SpongeImplHooks;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeGravityData;
import org.spongepowered.common.data.nbt.CustomDataNbtUtil;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.data.util.DataQueries;
import org.spongepowered.common.data.util.DataUtil;
import org.spongepowered.common.data.util.NbtDataUtil;
import org.spongepowered.common.entity.EntityUtil;
import org.spongepowered.common.entity.SpongeEntityArchetypeBuilder;
import org.spongepowered.common.entity.SpongeEntitySnapshotBuilder;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.event.ShouldFire;
import org.spongepowered.common.event.SpongeCommonEventFactory;
import org.spongepowered.common.event.damage.DamageEventHandler;
import org.spongepowered.common.event.damage.MinecraftBlockDamageSource;
import org.spongepowered.common.event.tracking.phase.plugin.BasicPluginContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.IMixinTrackable;
import org.spongepowered.common.interfaces.block.IMixinBlock;
import org.spongepowered.common.interfaces.data.IMixinCustomDataHolder;
import org.spongepowered.common.interfaces.entity.IMixinEntity;
import org.spongepowered.common.interfaces.entity.IMixinGriefer;
import org.spongepowered.common.interfaces.network.IMixinNetHandlerPlayServer;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.profile.SpongeProfileManager;
import org.spongepowered.common.relocate.co.aikar.timings.SpongeTimings;
import org.spongepowered.common.text.SpongeTexts;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.util.VecHelper;

@Mixin(value={net.minecraft.entity.Entity.class})
@Implements(value={@Interface(iface=Entity.class, prefix="entity$")})
public abstract class MixinEntity
implements Entity,
IMixinEntity,
IMixinTrackable {
    private static final String WORLD_SPAWN_PARTICLE = "Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V";
    private static final String RIDING_ENTITY_FIELD = "Lnet/minecraft/entity/Entity;ridingEntity:Lnet/minecraft/entity/Entity;";
    private static final String ENTITY_ITEM_INIT = "Lnet/minecraft/entity/item/EntityItem;<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V";
    private EntityType entityType = SpongeImpl.getRegistry().getTranslated(this.getClass(), EntityType.class);
    private boolean teleporting;
    private WeakReference<IMixinChunk> activeChunk = new WeakReference<Object>(null);
    private net.minecraft.entity.Entity teleportVehicle;
    private float origWidth;
    private float origHeight;
    protected boolean isConstructing = true;
    @Nullable
    private Text displayName;
    private BlockState currentCollidingBlock;
    private BlockPos lastCollidedBlockPos;
    private final boolean isVanilla = this.getClass().getName().startsWith("net.minecraft.");
    private SpongeProfileManager spongeProfileManager;
    private UserStorageService userStorageService;
    private Timing timing;
    private boolean allowsBlockBulkCapture = true;
    private boolean allowsEntityBulkCapture = true;
    private boolean allowsBlockEventCreation = true;
    private boolean allowsEntityEventCreation = true;
    private boolean trackedInWorld = false;
    @Shadow
    public net.minecraft.entity.Entity field_184239_as;
    @Shadow
    @Final
    private List<net.minecraft.entity.Entity> field_184244_h;
    @Shadow
    private UUID field_96093_i;
    @Shadow
    public net.minecraft.world.World field_70170_p;
    @Shadow
    public double field_70165_t;
    @Shadow
    public double field_70163_u;
    @Shadow
    public double field_70161_v;
    @Shadow
    public double field_70159_w;
    @Shadow
    public double field_70181_x;
    @Shadow
    public double field_70179_y;
    @Shadow
    public boolean field_70133_I;
    @Shadow
    public double field_70169_q;
    @Shadow
    public double field_70167_r;
    @Shadow
    public double field_70166_s;
    @Shadow
    public float field_70177_z;
    @Shadow
    public float field_70125_A;
    @Shadow
    public float field_70130_N;
    @Shadow
    public float field_70131_O;
    @Shadow
    public float field_70143_R;
    @Shadow
    public boolean field_70128_L;
    @Shadow
    public boolean field_70122_E;
    @Shadow
    public boolean field_70171_ac;
    @Shadow
    protected boolean field_70178_ae;
    @Shadow
    public int field_70172_ad;
    @Shadow
    public int field_190534_ay;
    @Shadow
    public int field_71093_bK;
    @Shadow
    protected Random field_70146_Z;
    @Shadow
    public float field_70141_P;
    @Shadow
    public float field_70140_Q;
    @Shadow
    protected EntityDataManager field_70180_af;
    @Shadow
    public int field_70173_aa;
    @Shadow
    public float field_70144_Y;
    @Shadow
    private boolean field_83001_bt;
    @Shadow
    protected boolean field_71087_bX;
    private boolean collision = false;
    private boolean untargetable = false;
    private boolean isVanished = false;
    private boolean pendingVisibilityUpdate = false;
    private int visibilityTicks = 0;
    private boolean skipSettingCustomNameTag = false;

    @Shadow
    public abstract void func_70107_b(double var1, double var3, double var5);

    @Shadow
    public abstract void func_70106_y();

    @Shadow
    public abstract int func_70086_ai();

    @Shadow
    public abstract void func_70050_g(int var1);

    @Shadow
    public abstract float func_70047_e();

    @Shadow
    public abstract void func_96094_a(String var1);

    @Shadow
    public abstract UUID func_110124_au();

    @Shadow
    @Nullable
    public abstract AxisAlignedBB func_174813_aQ();

    @Shadow
    public abstract void func_70015_d(int var1);

    @Shadow
    public abstract NBTTagCompound func_189511_e(NBTTagCompound var1);

    @Shadow
    public abstract boolean func_70097_a(DamageSource var1, float var2);

    @Shadow
    public abstract int func_145782_y();

    @Shadow
    public abstract boolean func_184207_aI();

    @Shadow
    public abstract SoundCategory func_184176_by();

    @Shadow
    public abstract List<net.minecraft.entity.Entity> shadow$func_184188_bt();

    @Shadow
    public abstract net.minecraft.entity.Entity func_184208_bv();

    @Shadow
    public abstract net.minecraft.entity.Entity func_184187_bx();

    @Shadow
    public abstract void func_184226_ay();

    @Shadow
    public abstract void func_184185_a(SoundEvent var1, float var2, float var3);

    @Shadow
    public abstract boolean func_180431_b(DamageSource var1);

    @Shadow
    public abstract boolean func_70051_ag();

    @Shadow
    public abstract boolean func_70090_H();

    @Shadow
    public abstract boolean func_184218_aH();

    @Shadow
    public abstract boolean func_184191_r(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract double func_70068_e(net.minecraft.entity.Entity var1);

    @Shadow
    public abstract void func_70012_b(double var1, double var3, double var5, float var7, float var8);

    @Shadow
    public abstract boolean func_189652_ae();

    @Shadow
    public abstract void func_189654_d(boolean var1);

    @Shadow
    public abstract void func_70634_a(double var1, double var3, double var5);

    @Shadow
    protected abstract void func_184225_p(net.minecraft.entity.Entity var1);

    @Shadow
    protected abstract void shadow$func_70101_b(float var1, float var2);

    @Shadow
    protected abstract void func_70105_a(float var1, float var2);

    @Shadow
    protected abstract void func_174815_a(EntityLivingBase var1, net.minecraft.entity.Entity var2);

    @Shadow
    public abstract void func_70066_B();

    @Shadow
    protected abstract void func_70052_a(int var1, boolean var2);

    @Shadow
    public abstract void func_184201_a(EntityEquipmentSlot var1, ItemStack var2);

    @Redirect(method={"<init>"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;dimension:I", opcode=181))
    private void onSet(net.minecraft.entity.Entity self, int dimensionId, net.minecraft.world.World worldIn) {
        self.field_71093_bK = worldIn instanceof IMixinWorldServer ? ((IMixinWorldServer)worldIn).getDimensionId() : dimensionId;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onSpongeConstruction(net.minecraft.world.World worldIn, CallbackInfo ci) {
        if (this.entityType instanceof SpongeEntityType) {
            SpongeEntityType spongeEntityType = (SpongeEntityType)this.entityType;
            this.refreshCache();
            if (spongeEntityType.getEnumCreatureType() == null) {
                for (EnumCreatureType type : EnumCreatureType.values()) {
                    if (!SpongeImplHooks.isCreatureOfType((net.minecraft.entity.Entity)this, type)) continue;
                    spongeEntityType.setEnumCreatureType(type);
                    break;
                }
            }
        }
        if (worldIn != null && !worldIn.field_72995_K) {
            this.spongeProfileManager = (SpongeProfileManager)Sponge.getServer().getGameProfileManager();
            this.userStorageService = SpongeImpl.getGame().getServiceManager().provide(UserStorageService.class).get();
        }
    }

    @Override
    public boolean isInConstructPhase() {
        return this.isConstructing;
    }

    @Override
    public void firePostConstructEvents() {
        this.isConstructing = false;
    }

    @Override
    public boolean isTrackedInWorld() {
        return this.trackedInWorld;
    }

    @Override
    public void setTrackedInWorld(boolean tracked) {
        this.trackedInWorld = tracked;
    }

    @Inject(method={"startRiding(Lnet/minecraft/entity/Entity;Z)Z"}, at={@At(value="FIELD", target="Lnet/minecraft/entity/Entity;ridingEntity:Lnet/minecraft/entity/Entity;", ordinal=0)}, cancellable=true)
    private void onStartRiding(net.minecraft.entity.Entity vehicle, boolean force, CallbackInfoReturnable<Boolean> ci) {
        if (!this.field_70170_p.field_72995_K && (ShouldFire.RIDE_ENTITY_EVENT_MOUNT || ShouldFire.RIDE_ENTITY_EVENT)) {
            Sponge.getCauseStackManager().pushCause(this);
            if (SpongeImpl.postEvent(SpongeEventFactory.createRideEntityEventMount(Sponge.getCauseStackManager().getCurrentCause(), (Entity)vehicle))) {
                ci.cancel();
            }
            Sponge.getCauseStackManager().popCause();
        }
    }

    @Overwrite
    public void func_184210_p() {
        if (this.field_184239_as != null) {
            if (this.func_184187_bx().field_70128_L) {
                this.dismountRidingEntity(DismountTypes.DEATH);
            } else {
                this.dismountRidingEntity(DismountTypes.PLAYER);
            }
        }
    }

    @Override
    public boolean dismountRidingEntity(DismountType type) {
        if (!this.field_70170_p.field_72995_K && (ShouldFire.RIDE_ENTITY_EVENT_DISMOUNT || ShouldFire.RIDE_ENTITY_EVENT)) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this);
                frame.addContext(EventContextKeys.DISMOUNT_TYPE, type);
                if (SpongeImpl.postEvent(SpongeEventFactory.createRideEntityEventDismount(frame.getCurrentCause(), type, (Entity)this.func_184187_bx()))) {
                    boolean bl = false;
                    return bl;
                }
            }
        }
        if (this.field_184239_as != null) {
            MixinEntity entity = (MixinEntity)this.field_184239_as;
            this.field_184239_as = null;
            entity.func_184225_p((net.minecraft.entity.Entity)this);
        }
        return true;
    }

    @Override
    public boolean removePassengers(DismountType type) {
        boolean dismount = false;
        for (int i = this.field_184244_h.size() - 1; i >= 0; --i) {
            dismount = ((IMixinEntity)this.field_184244_h.get(i)).dismountRidingEntity(type) || dismount;
        }
        return dismount;
    }

    @Inject(method={"setSize"}, at={@At(value="RETURN")})
    private void onSpongeSetSize(float width, float height, CallbackInfo ci) {
        if (this.origWidth == 0.0f || this.origHeight == 0.0f) {
            this.origWidth = this.field_70130_N;
            this.origHeight = this.field_70131_O;
        }
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSpongeMoveEntity(MoverType type, double x, double y, double z, CallbackInfo ci) {
        if (!this.field_70170_p.field_72995_K && !SpongeHooks.checkEntitySpeed((net.minecraft.entity.Entity)this, x, y, z)) {
            ci.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"setOnFireFromLava"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean onSpongeRedirectForBlockDamageSource(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            AxisAlignedBB bb = this.func_174813_aQ().func_72314_b((double)-0.1f, (double)-0.4f, (double)-0.1f);
            Location<World> location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.func_185904_a() == Material.field_151587_i);
            DamageSource.field_76371_c = new MinecraftBlockDamageSource("lava", location).func_76361_j();
            boolean bl = entity.func_70097_a(DamageSource.field_76371_c, damage);
            return bl;
        }
        finally {
            DamageSource.field_76371_c = source;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"dealFireDamage"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean onSpongeRedirectForFireDamage(net.minecraft.entity.Entity entity, DamageSource source, float damage) {
        if (this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            AxisAlignedBB bb = this.func_174813_aQ().func_72314_b(-0.001, -0.001, -0.001);
            Location<World> location = DamageEventHandler.findFirstMatchingBlock((net.minecraft.entity.Entity)this, bb, block -> block.func_177230_c() == Blocks.field_150480_ab || block.func_177230_c() == Blocks.field_150356_k || block.func_177230_c() == Blocks.field_150353_l);
            DamageSource.field_76372_a = new MinecraftBlockDamageSource("inFire", location).func_76361_j();
            boolean bl = entity.func_70097_a(DamageSource.field_76372_a, damage);
            return bl;
        }
        finally {
            DamageSource.field_76372_a = source;
        }
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        Optional<VehicleData> vehicleData = this.get(VehicleData.class);
        if (vehicleData.isPresent()) {
            manipulators.add(vehicleData.get());
        }
        if (this.field_190534_ay > 0) {
            manipulators.add(this.get(IgniteableData.class).get());
        }
        manipulators.add(new SpongeGravityData(!this.func_189652_ae()));
    }

    @Override
    public EntitySnapshot createSnapshot() {
        return new SpongeEntitySnapshotBuilder().from(this).build();
    }

    @Override
    public Random getRandom() {
        return this.field_70146_Z;
    }

    @Inject(method={"setPosition"}, at={@At(value="HEAD")})
    public void onSetPosition(double x, double y, double z, CallbackInfo ci) {
        if (this instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)this;
            if (player.field_71135_a != null) {
                ((IMixinNetHandlerPlayServer)player.field_71135_a).captureCurrentPlayerPosition();
            }
        }
    }

    public Vector3d getPosition() {
        return new Vector3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    @Override
    public Location<World> getLocation() {
        return new Location<World>((World)this.field_70170_p, this.getPosition());
    }

    @Override
    public boolean setLocationAndRotation(Location<World> location, Vector3d rotation) {
        boolean result = this.setLocation(location);
        if (result) {
            this.setRotation(rotation);
            return true;
        }
        return false;
    }

    @Override
    public boolean setLocation(Location<World> location) {
        Preconditions.checkNotNull(location, (Object)"The location was null!");
        if (this.isRemoved()) {
            return false;
        }
        try (BasicPluginContext context = PluginPhase.State.TELEPORT.createPhaseContext();){
            context.buildAndSwitch();
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                MoveEntityEvent.Teleport event;
                if (!frame.getCurrentContext().containsKey(EventContextKeys.TELEPORT_TYPE)) {
                    frame.addContext(EventContextKeys.TELEPORT_TYPE, TeleportTypes.PLUGIN);
                }
                if ((event = EntityUtil.handleDisplaceEntityTeleportEvent((net.minecraft.entity.Entity)this, location)).isCancelled()) {
                    boolean bl = false;
                    return bl;
                }
                location = event.getToTransform().getLocation();
                this.field_70125_A = (float)event.getToTransform().getPitch();
                this.field_70177_z = (float)event.getToTransform().getYaw();
            }
            IMixinChunkProviderServer chunkProviderServer = (IMixinChunkProviderServer)((WorldServer)this.field_70170_p).func_72863_F();
            chunkProviderServer.setForceChunkRequests(true);
            net.minecraft.entity.Entity thisEntity = (net.minecraft.entity.Entity)this;
            List passengers = thisEntity.func_184188_bt();
            boolean isTeleporting = true;
            if (location.getExtent().getUniqueId() != ((World)this.field_70170_p).getUniqueId()) {
                net.minecraft.world.World nmsWorld = (net.minecraft.world.World)location.getExtent();
                if ((net.minecraft.entity.Entity)this instanceof EntityPlayerMP) {
                    EntityPlayerMP entityPlayerMP = (EntityPlayerMP)this;
                    if (entityPlayerMP.field_71070_bA != entityPlayerMP.field_71069_bz) {
                        ((Player)entityPlayerMP).closeInventory();
                    }
                }
                EntityUtil.changeWorld((net.minecraft.entity.Entity)this, location, ((IMixinWorldServer)this.field_70170_p).getDimensionId(), ((IMixinWorldServer)nmsWorld).getDimensionId());
            } else {
                double distance = location.getPosition().distance(this.getPosition());
                if (distance <= 4.0) {
                    isTeleporting = false;
                }
                if (thisEntity instanceof EntityPlayerMP && ((EntityPlayerMP)thisEntity).field_71135_a != null) {
                    EntityPlayerMP entityPlayerMP = (EntityPlayerMP)thisEntity;
                    if (isTeleporting) {
                        if (entityPlayerMP.field_71070_bA != entityPlayerMP.field_71069_bz) {
                            ((Player)entityPlayerMP).closeInventory();
                        }
                        ((WorldServer)location.getExtent()).func_72863_F().func_186028_c(location.getChunkPosition().getX(), location.getChunkPosition().getZ());
                    }
                    entityPlayerMP.field_71135_a.func_147364_a(location.getX(), location.getY(), location.getZ(), thisEntity.field_70177_z, thisEntity.field_70125_A);
                    ((IMixinNetHandlerPlayServer)entityPlayerMP.field_71135_a).setLastMoveLocation(null);
                } else {
                    this.func_70107_b(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ());
                }
            }
            if (isTeleporting) {
                for (net.minecraft.entity.Entity passenger : passengers) {
                    passenger.func_184205_a(thisEntity, true);
                }
            }
            chunkProviderServer.setForceChunkRequests(false);
            boolean bl = true;
            return bl;
        }
    }

    @Override
    public void setLocationAndAngles(Location<World> location) {
        if (this instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this).field_71135_a.func_147364_a(location.getX(), location.getY(), location.getZ(), this.field_70177_z, this.field_70125_A);
        } else {
            this.func_70107_b(location.getX(), location.getY(), location.getZ());
        }
        if (this.field_70170_p != location.getExtent()) {
            this.field_70170_p = (net.minecraft.world.World)location.getExtent();
        }
    }

    @Override
    public void setLocationAndAngles(Transform<World> transform) {
        Vector3d position = transform.getPosition();
        EntityPlayerMP player = null;
        if (this instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)this;
        }
        if (player != null && player.field_71135_a != null) {
            player.field_71135_a.func_147364_a(position.getX(), position.getY(), position.getZ(), (float)transform.getYaw(), (float)transform.getPitch());
        } else {
            this.func_70012_b(position.getX(), position.getY(), position.getZ(), (float)transform.getYaw(), (float)transform.getPitch());
        }
        if (this.field_70170_p != transform.getExtent()) {
            this.field_70170_p = (net.minecraft.world.World)transform.getExtent();
        }
    }

    @Override
    public boolean setLocationAndRotation(Location<World> location, Vector3d rotation, EnumSet<RelativePositions> relativePositions) {
        boolean relocated = true;
        if (relativePositions.isEmpty()) {
            relocated = this.setLocation(location);
            this.setRotation(rotation);
        } else if (this instanceof EntityPlayerMP && ((EntityPlayerMP)this).field_71135_a != null) {
            EnumSet<SPacketPlayerPosLook.EnumFlags> relativeFlags = EnumSet.noneOf(SPacketPlayerPosLook.EnumFlags.class);
            if (relativePositions.contains((Object)RelativePositions.X)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.X);
            }
            if (relativePositions.contains((Object)RelativePositions.Y)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Y);
            }
            if (relativePositions.contains((Object)RelativePositions.Z)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Z);
            }
            if (relativePositions.contains((Object)RelativePositions.PITCH)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.X_ROT);
            }
            if (relativePositions.contains((Object)RelativePositions.YAW)) {
                relativeFlags.add(SPacketPlayerPosLook.EnumFlags.Y_ROT);
            }
            ((EntityPlayerMP)this).field_71135_a.func_175089_a(location.getPosition().getX(), location.getPosition().getY(), location.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), relativeFlags);
        } else {
            Location<World> resultantLocation = this.getLocation();
            Vector3d resultantRotation = this.getRotation();
            if (relativePositions.contains((Object)RelativePositions.X)) {
                resultantLocation = resultantLocation.add(location.getPosition().getX(), 0.0, 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.Y)) {
                resultantLocation = resultantLocation.add(0.0, location.getPosition().getY(), 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.Z)) {
                resultantLocation = resultantLocation.add(0.0, 0.0, location.getPosition().getZ());
            }
            if (relativePositions.contains((Object)RelativePositions.PITCH)) {
                resultantRotation = resultantRotation.add(rotation.getX(), 0.0, 0.0);
            }
            if (relativePositions.contains((Object)RelativePositions.YAW)) {
                resultantRotation = resultantRotation.add(0.0, rotation.getY(), 0.0);
            }
            relocated = this.setLocation(resultantLocation);
            this.setRotation(resultantRotation);
        }
        return relocated;
    }

    @Inject(method={"onUpdate"}, at={@At(value="RETURN")})
    private void spongeOnUpdate(CallbackInfo callbackInfo) {
        if (this.pendingVisibilityUpdate && !this.field_70170_p.field_72995_K) {
            EntityTracker entityTracker = ((WorldServer)this.field_70170_p).func_73039_n();
            EntityTrackerEntry lookup = (EntityTrackerEntry)entityTracker.field_72794_c.func_76041_a(this.func_145782_y());
            if (this.visibilityTicks % 4 == 0) {
                if (this.isVanished) {
                    for (EntityPlayerMP entityPlayerMP : lookup.field_73134_o) {
                        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketDestroyEntities(new int[]{this.func_145782_y()}));
                        if (!(this instanceof EntityPlayerMP)) continue;
                        entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketPlayerListItem(SPacketPlayerListItem.Action.REMOVE_PLAYER, new EntityPlayerMP[]{(EntityPlayerMP)this}));
                    }
                } else {
                    this.visibilityTicks = 1;
                    this.pendingVisibilityUpdate = false;
                    for (EntityPlayerMP entityPlayerMP : SpongeImpl.getServer().func_184103_al().func_181057_v()) {
                        if (this == entityPlayerMP) continue;
                        if (this instanceof EntityPlayerMP) {
                            SPacketPlayerListItem packet = new SPacketPlayerListItem(SPacketPlayerListItem.Action.ADD_PLAYER, new EntityPlayerMP[]{(EntityPlayerMP)this});
                            entityPlayerMP.field_71135_a.func_147359_a((Packet)packet);
                        }
                        Packet newPacket = lookup.func_151260_c();
                        entityPlayerMP.field_71135_a.func_147359_a(newPacket);
                    }
                }
            }
            if (this.visibilityTicks > 0) {
                --this.visibilityTicks;
            } else {
                this.pendingVisibilityUpdate = false;
            }
        }
    }

    @Override
    public Vector3d getScale() {
        return Vector3d.ONE;
    }

    @Override
    public void setScale(Vector3d scale) {
    }

    @Override
    public Transform<World> getTransform() {
        return new Transform<World>(this.getWorld(), this.getPosition(), this.getRotation(), this.getScale());
    }

    @Override
    public boolean setTransform(Transform<World> transform) {
        Preconditions.checkNotNull(transform, (Object)"The transform cannot be null!");
        boolean result = this.setLocation(transform.getLocation());
        if (result) {
            this.setRotation(transform.getRotation());
            this.setScale(transform.getScale());
            return true;
        }
        return false;
    }

    @Override
    public boolean transferToWorld(World world, Vector3d position) {
        Preconditions.checkNotNull((Object)world, (Object)"World was null!");
        Preconditions.checkNotNull((Object)position, (Object)"Position was null!");
        return this.setLocation(new Location<World>(world, position));
    }

    @Override
    public Vector3d getRotation() {
        return new Vector3d(this.field_70125_A, this.field_70177_z, 0.0f);
    }

    @Override
    public void setRotation(Vector3d rotation) {
        Preconditions.checkNotNull((Object)rotation, (Object)"Rotation was null!");
        if (this.isRemoved()) {
            return;
        }
        if (this instanceof EntityPlayerMP && ((EntityPlayerMP)this).field_71135_a != null) {
            ((EntityPlayerMP)this).field_71135_a.func_175089_a(this.getPosition().getX(), this.getPosition().getY(), this.getPosition().getZ(), (float)rotation.getY(), (float)rotation.getX(), EnumSet.noneOf(RelativePositions.class));
        } else {
            if (!this.field_70170_p.field_72995_K) {
                ((IMixinWorldServer)((Object)this.getWorld())).addEntityRotationUpdate((net.minecraft.entity.Entity)this, rotation);
            }
            this.shadow$func_70101_b((float)rotation.getY(), (float)rotation.getX());
        }
    }

    @Override
    public Optional<AABB> getBoundingBox() {
        AxisAlignedBB boundingBox = this.func_174813_aQ();
        if (boundingBox == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(VecHelper.toSpongeAABB(boundingBox));
        }
        catch (IllegalArgumentException exception) {
            return Optional.empty();
        }
    }

    @Override
    public boolean isOnGround() {
        return this.field_70122_E;
    }

    @Override
    public boolean isRemoved() {
        return this.field_70128_L;
    }

    @Override
    public boolean isLoaded() {
        return !this.isRemoved();
    }

    @Override
    public void remove() {
        this.field_70128_L = true;
    }

    @Override
    public boolean damage(double damage, org.spongepowered.api.event.cause.entity.damage.source.DamageSource damageSource) {
        if (!(damageSource instanceof DamageSource)) {
            SpongeImpl.getLogger().error("An illegal DamageSource was provided in the cause! The damage source must extend AbstractDamageSource!");
            return false;
        }
        return this.func_70097_a((DamageSource)damageSource, (float)damage);
    }

    @Override
    public boolean isTeleporting() {
        return this.teleporting;
    }

    @Override
    public net.minecraft.entity.Entity getTeleportVehicle() {
        return this.teleportVehicle;
    }

    @Override
    public void setIsTeleporting(boolean teleporting) {
        this.teleporting = teleporting;
    }

    @Override
    public void setTeleportVehicle(net.minecraft.entity.Entity vehicle) {
        this.teleportVehicle = vehicle;
    }

    @Override
    public EntityType getType() {
        return this.entityType;
    }

    @Override
    public UUID getUniqueId() {
        return this.field_96093_i;
    }

    @Intrinsic
    public List<Entity> entity$getPassengers() {
        return this.shadow$func_184188_bt();
    }

    @Override
    public Optional<Entity> getVehicle() {
        return Optional.ofNullable((Entity)this.func_184187_bx());
    }

    @Override
    public Entity getBaseVehicle() {
        return (Entity)this.func_184208_bv();
    }

    @Override
    public boolean hasPassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        return entity.getPassengers().contains(this);
    }

    @Override
    public boolean addPassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        if (entity.getPassengers().contains(this)) {
            throw new IllegalArgumentException(String.format("Cannot add entity %s as a passenger of %s, because the former already has the latter as a passenger!", entity, this));
        }
        return ((net.minecraft.entity.Entity)entity).func_184205_a((net.minecraft.entity.Entity)this, true);
    }

    @Override
    public void removePassenger(Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        if (!entity.getPassengers().contains(this)) {
            throw new IllegalArgumentException(String.format("Cannot remove entity %s, because it is not a passenger of %s ", entity, this));
        }
        ((net.minecraft.entity.Entity)entity).func_184210_p();
    }

    @Override
    public void clearPassengers() {
        this.func_184226_ay();
    }

    @Override
    public boolean setVehicle(@Nullable Entity entity) {
        if (this.func_184187_bx() == null && entity == null) {
            return false;
        }
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
            return true;
        }
        return entity != null && entity.addPassenger(this);
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;writeToNBT(Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraft/nbt/NBTTagCompound;"}, at={@At(value="HEAD")})
    private void onSpongeWriteToNBT(NBTTagCompound compound, CallbackInfoReturnable<NBTTagCompound> ci) {
        this.writeToNbt(this.getSpongeData());
    }

    @Inject(method={"Lnet/minecraft/entity/Entity;readFromNBT(Lnet/minecraft/nbt/NBTTagCompound;)V"}, at={@At(value="RETURN")})
    private void onSpongeReadFromNBT(NBTTagCompound compound, CallbackInfo ci) {
        if (this.isConstructing) {
            this.firePostConstructEvents();
        }
        this.readFromNbt(this.getSpongeData());
    }

    @Override
    public boolean validateRawData(DataView container) {
        return false;
    }

    @Override
    public void setRawData(DataView container) throws InvalidDataException {
    }

    @Override
    public void readFromNbt(NBTTagCompound compound) {
        CustomDataNbtUtil.readCustomData(compound, this);
        if (this instanceof IMixinGriefer && ((IMixinGriefer)((Object)this)).isGriefer() && compound.func_74764_b("CanGrief")) {
            ((IMixinGriefer)((Object)this)).setCanGrief(compound.func_74767_n("CanGrief"));
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound compound) {
        CustomDataNbtUtil.writeCustomData(compound, this);
        if (this instanceof IMixinGriefer && ((IMixinGriefer)((Object)this)).isGriefer()) {
            compound.func_74757_a("CanGrief", ((IMixinGriefer)((Object)this)).canGrief());
        }
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        Transform<World> transform = this.getTransform();
        NBTTagCompound compound = new NBTTagCompound();
        this.func_189511_e(compound);
        NbtDataUtil.filterSpongeCustomData(compound);
        DataContainer unsafeNbt = NbtTranslator.getInstance().translateFrom(compound);
        DataContainer container = DataContainer.createNew().set(Queries.CONTENT_VERSION, (Object)this.getContentVersion()).set(DataQueries.ENTITY_CLASS, (Object)this.getClass().getName()).set(Queries.WORLD_ID, (Object)transform.getExtent().getUniqueId().toString()).createView(DataQueries.SNAPSHOT_WORLD_POSITION).set(Queries.POSITION_X, (Object)transform.getPosition().getX()).set(Queries.POSITION_Y, (Object)transform.getPosition().getY()).set(Queries.POSITION_Z, (Object)transform.getPosition().getZ()).getContainer().createView(DataQueries.ENTITY_ROTATION).set(Queries.POSITION_X, (Object)transform.getRotation().getX()).set(Queries.POSITION_Y, (Object)transform.getRotation().getY()).set(Queries.POSITION_Z, (Object)transform.getRotation().getZ()).getContainer().createView(DataQueries.ENTITY_SCALE).set(Queries.POSITION_X, (Object)transform.getScale().getX()).set(Queries.POSITION_Y, (Object)transform.getScale().getY()).set(Queries.POSITION_Z, (Object)transform.getScale().getZ()).getContainer().set(DataQueries.ENTITY_TYPE, (Object)this.entityType.getId()).set(DataQueries.UNSAFE_NBT, (Object)unsafeNbt);
        List<DataManipulator<?, ?>> manipulators = ((IMixinCustomDataHolder)((Object)this)).getCustomManipulators();
        if (!manipulators.isEmpty()) {
            container.set(DataQueries.DATA_MANIPULATORS, DataUtil.getSerializedManipulatorList(manipulators));
        }
        return container;
    }

    @Override
    public Collection<DataManipulator<?, ?>> getContainers() {
        ArrayList list = Lists.newArrayList();
        this.supplyVanillaManipulators(list);
        if (this instanceof IMixinCustomDataHolder && ((IMixinCustomDataHolder)((Object)this)).hasManipulators()) {
            list.addAll(((IMixinCustomDataHolder)((Object)this)).getCustomManipulators());
        }
        return list;
    }

    @Override
    public DataHolder copy() {
        if (this instanceof Player) {
            throw new IllegalArgumentException("Cannot copy player entities!");
        }
        try {
            NBTTagCompound compound = new NBTTagCompound();
            this.func_189511_e(compound);
            net.minecraft.entity.Entity entity = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(this.entityType.getId()), (net.minecraft.world.World)this.field_70170_p);
            compound.func_186854_a("UUID", entity.func_110124_au());
            entity.func_70020_e(compound);
            return (Entity)entity;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not copy the entity:", e);
        }
    }

    @Override
    public Optional<User> getTrackedPlayer(String nbtKey) {
        return Optional.empty();
    }

    @Override
    public Optional<User> getCreatorUser() {
        return Optional.empty();
    }

    @Override
    public Optional<User> getNotifierUser() {
        return Optional.empty();
    }

    @Override
    public void trackEntityUniqueId(String nbtKey, @Nullable UUID uuid) {
    }

    @Override
    public Optional<UUID> getCreator() {
        return Optional.empty();
    }

    @Override
    public Optional<UUID> getNotifier() {
        return Optional.empty();
    }

    @Override
    public void setCreator(@Nullable UUID uuid) {
    }

    @Override
    public void setNotifier(@Nullable UUID uuid) {
    }

    @Override
    public void setImplVelocity(Vector3d velocity) {
        this.field_70159_w = ((Vector3d)Preconditions.checkNotNull((Object)velocity)).getX();
        this.field_70181_x = velocity.getY();
        this.field_70179_y = velocity.getZ();
        this.field_70133_I = true;
    }

    @Override
    public Vector3d getVelocity() {
        return new Vector3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    @Redirect(method={"move"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityWalk(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;)V"))
    public void onEntityCollideWithBlock(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.entity.Entity entity) {
        if (!((IMixinBlock)block).hasCollideLogic()) {
            return;
        }
        if (world.field_72995_K) {
            block.func_176199_a(world, pos, entity);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        this.setCurrentCollidingBlock((BlockState)state);
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.NONE)) {
            block.func_176199_a(world, pos, entity);
            this.lastCollidedBlockPos = pos;
        }
        this.setCurrentCollidingBlock(null);
    }

    @Redirect(method={"doBlockCollisions"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onEntityCollision(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/Entity;)V"))
    public void onEntityCollideWithBlockState(Block block, net.minecraft.world.World world, BlockPos pos, IBlockState state, net.minecraft.entity.Entity entity) {
        if (!((IMixinBlock)block).hasCollideWithStateLogic()) {
            return;
        }
        if (world.field_72995_K) {
            block.func_180634_a(world, pos, state, entity);
            return;
        }
        this.setCurrentCollidingBlock((BlockState)state);
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.NONE)) {
            block.func_180634_a(world, pos, state, entity);
            this.lastCollidedBlockPos = pos;
        }
        this.setCurrentCollidingBlock(null);
    }

    @Redirect(method={"updateFallState"}, at=@At(value="INVOKE", target="Lnet/minecraft/block/Block;onFallenUpon(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/entity/Entity;F)V"))
    public void onBlockFallenUpon(Block block, net.minecraft.world.World world, BlockPos pos, net.minecraft.entity.Entity entity, float fallDistance) {
        if (world.field_72995_K) {
            block.func_180658_a(world, pos, entity, fallDistance);
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        this.setCurrentCollidingBlock((BlockState)state);
        if (!SpongeCommonEventFactory.handleCollideBlockEvent(block, world, pos, state, entity, Direction.UP)) {
            block.func_180658_a(world, pos, entity, fallDistance);
            this.lastCollidedBlockPos = pos;
        }
        this.setCurrentCollidingBlock(null);
    }

    @Override
    public Translation getTranslation() {
        return this.getType().getTranslation();
    }

    @Override
    public boolean isVanished() {
        return this.isVanished;
    }

    @Override
    public void setVanished(boolean vanished) {
        this.isVanished = vanished;
        this.pendingVisibilityUpdate = true;
        this.visibilityTicks = 20;
    }

    @Override
    public boolean ignoresCollision() {
        return this.collision;
    }

    @Override
    public void setIgnoresCollision(boolean prevents) {
        this.collision = prevents;
    }

    @Override
    public boolean isUntargetable() {
        return this.untargetable;
    }

    @Override
    public void setUntargetable(boolean untargetable) {
        this.untargetable = untargetable;
    }

    @Redirect(method={"playSound"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;isSilent()Z"))
    private boolean checkIsSilentOrInvis(net.minecraft.entity.Entity entity) {
        return entity.func_174814_R() || this.isVanished;
    }

    @Redirect(method={"applyEntityCollision"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;noClip:Z", opcode=180))
    private boolean spongeApplyEntityCollisionCheckVanish(net.minecraft.entity.Entity entity) {
        return entity.field_70145_X || ((IMixinEntity)entity).isVanished();
    }

    @Redirect(method={"doWaterSplashEffect"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    private void spawnParticle(net.minecraft.world.World world, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_175688_14_) {
        if (!this.isVanished) {
            this.field_70170_p.func_175688_a(particleTypes, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
        }
    }

    @Redirect(method={"createRunningParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/World;spawnParticle(Lnet/minecraft/util/EnumParticleTypes;DDDDDD[I)V"))
    private void runningSpawnParticle(net.minecraft.world.World world, EnumParticleTypes particleTypes, double xCoord, double yCoord, double zCoord, double xOffset, double yOffset, double zOffset, int ... p_175688_14_) {
        if (!this.isVanished) {
            this.field_70170_p.func_175688_a(particleTypes, xCoord, yCoord, zCoord, xOffset, yOffset, zOffset, p_175688_14_);
        }
    }

    @Override
    @Nullable
    public Text getDisplayNameText() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(@Nullable Text displayName) {
        this.displayName = displayName;
        this.skipSettingCustomNameTag = true;
        if (this.displayName == null) {
            this.func_96094_a("");
        } else {
            this.func_96094_a(SpongeTexts.toLegacy(this.displayName));
        }
        this.skipSettingCustomNameTag = false;
    }

    @Inject(method={"setCustomNameTag"}, at={@At(value="RETURN")})
    public void onSetCustomNameTag(String name, CallbackInfo ci) {
        if (!this.skipSettingCustomNameTag) {
            this.displayName = SpongeTexts.fromLegacy(name);
        }
    }

    @Override
    public boolean canSee(Entity entity) {
        Optional<Boolean> optional = entity.get(Keys.VANISH);
        return (!optional.isPresent() || optional.get() == false) && !((IMixinEntity)entity).isVanished();
    }

    @Overwrite
    @Nullable
    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (this.field_70170_p.field_72995_K) {
            if (stack.func_190926_b()) {
                return null;
            }
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_174869_p();
            this.field_70170_p.func_72838_d((net.minecraft.entity.Entity)entityitem);
            return entityitem;
        }
        return EntityUtil.entityOnDropItem((net.minecraft.entity.Entity)this, stack, offsetY);
    }

    @Override
    public void setCurrentCollidingBlock(BlockState state) {
        this.currentCollidingBlock = state;
    }

    @Override
    public BlockState getCurrentCollidingBlock() {
        if (this.currentCollidingBlock == null) {
            return (BlockState)Blocks.field_150350_a.func_176223_P();
        }
        return this.currentCollidingBlock;
    }

    @Override
    public BlockPos getLastCollidedBlockPos() {
        return this.lastCollidedBlockPos;
    }

    @Override
    public boolean isVanilla() {
        return this.isVanilla;
    }

    @Override
    public Timing getTimingsHandler() {
        if (this.timing == null) {
            this.timing = SpongeTimings.getEntityTiming(this);
        }
        return this.timing;
    }

    @Override
    public EntityArchetype createArchetype() {
        return new SpongeEntityArchetypeBuilder().from(this).build();
    }

    @Override
    public Value<Boolean> gravity() {
        return this.getValue(Keys.HAS_GRAVITY).get();
    }

    @Override
    @Nullable
    public IMixinChunk getActiveChunk() {
        return (IMixinChunk)this.activeChunk.get();
    }

    @Override
    public void setActiveChunk(@Nullable IMixinChunk chunk) {
        this.activeChunk = new WeakReference<IMixinChunk>(chunk);
    }

    @Override
    public boolean shouldTick() {
        IMixinChunk chunk = this.getActiveChunk();
        return chunk == null || chunk.isActive();
    }

    @Override
    public void setInvulnerable(boolean value) {
        this.field_83001_bt = value;
    }

    @Override
    public boolean allowsBlockBulkCapture() {
        return this.allowsBlockBulkCapture;
    }

    @Override
    public boolean allowsEntityBulkCapture() {
        return this.allowsEntityBulkCapture;
    }

    @Override
    public boolean allowsBlockEventCreation() {
        return this.allowsBlockEventCreation;
    }

    @Override
    public boolean allowsEntityEventCreation() {
        return this.allowsEntityEventCreation;
    }

    @Override
    public void refreshCache() {
        if (this.entityType instanceof SpongeEntityType) {
            this.allowsBlockBulkCapture = ((SpongeEntityType)this.entityType).allowsBlockBulkCapture;
            this.allowsEntityBulkCapture = ((SpongeEntityType)this.entityType).allowsEntityBulkCapture;
            this.allowsBlockEventCreation = ((SpongeEntityType)this.entityType).allowsBlockEventCreation;
            this.allowsEntityEventCreation = ((SpongeEntityType)this.entityType).allowsEntityEventCreation;
        }
    }

    @Redirect(method={"setFire"}, at=@At(value="FIELD", target="Lnet/minecraft/entity/Entity;fire:I", opcode=181))
    private void onFire(net.minecraft.entity.Entity entity, int ticks) {
        if (((IMixinWorld)this.field_70170_p).isFake() || !ShouldFire.IGNITE_ENTITY_EVENT) {
            this.field_190534_ay = ticks;
            return;
        }
        if (this.field_190534_ay < 1 && !this.isImmuneToFireForIgniteEvent()) {
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(this.getLocation().getExtent());
                IgniteEntityEvent event = SpongeEventFactory.createIgniteEntityEvent(frame.getCurrentCause(), ticks, ticks, this);
                if (SpongeImpl.postEvent(event)) {
                    this.field_190534_ay = 0;
                    return;
                }
                this.field_190534_ay = event.getFireTicks();
            }
        }
    }

    @Override
    public boolean isImmuneToFireForIgniteEvent() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"onStruckByLightning"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;attackEntityFrom(Lnet/minecraft/util/DamageSource;F)Z"))
    private boolean onSpongeLightningDamage(net.minecraft.entity.Entity entity, DamageSource source, float damage, EntityLightningBolt lightningBolt) {
        if (!this.field_70170_p.field_72995_K) {
            return entity.func_70097_a(source, damage);
        }
        try {
            DamageSource.field_180137_b = new EntityDamageSource("lightningBolt", (net.minecraft.entity.Entity)lightningBolt);
            boolean bl = entity.func_70097_a(DamageSource.field_180137_b, damage);
            return bl;
        }
        finally {
            DamageSource.field_180137_b = source;
        }
    }
}

