/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.entity.passive;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.mutable.entity.ParrotData;
import org.spongepowered.api.data.type.ParrotVariant;
import org.spongepowered.api.data.value.mutable.Value;
import org.spongepowered.api.entity.living.animal.Parrot;
import org.spongepowered.api.event.CauseStackManager;
import org.spongepowered.api.event.SpongeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeParrotData;
import org.spongepowered.common.data.manipulator.mutable.entity.SpongeSittingData;
import org.spongepowered.common.data.util.DataConstants;
import org.spongepowered.common.data.value.mutable.SpongeValue;
import org.spongepowered.common.mixin.core.entity.passive.MixinEntityTameable;
import org.spongepowered.common.registry.type.entity.ParrotVariantRegistryModule;

@Mixin(value={EntityParrot.class})
public abstract class MixinEntityParrot
extends MixinEntityTameable
implements Parrot {
    @Shadow
    public abstract int func_191998_ds();

    @Redirect(method={"processInteract"}, at=@At(value="INVOKE", target="Ljava/util/Random;nextInt(I)I", ordinal=0, remap=false))
    public int onTame(Random rand, int bound, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int random = rand.nextInt(bound);
        if (random == 0) {
            stack.func_190920_e(stack.func_190916_E() + 1);
            try (CauseStackManager.StackFrame frame = Sponge.getCauseStackManager().pushCauseFrame();){
                frame.pushCause(player);
                if (!SpongeImpl.postEvent(SpongeEventFactory.createTameEntityEvent(frame.getCurrentCause(), this))) {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                    int n = random;
                    return n;
                }
            }
        }
        return 1;
    }

    @Override
    public ParrotData getParrotData() {
        return new SpongeParrotData(ParrotVariantRegistryModule.PARROT_VARIANT_IDMAP.get(this.func_191998_ds()));
    }

    @Override
    public Value<ParrotVariant> variant() {
        return new SpongeValue<ParrotVariant>(Keys.PARROT_VARIANT, DataConstants.Parrot.DEFAULT_VARIANT, ParrotVariantRegistryModule.PARROT_VARIANT_IDMAP.get(this.func_191998_ds()));
    }

    @Override
    public void supplyVanillaManipulators(List<DataManipulator<?, ?>> manipulators) {
        super.supplyVanillaManipulators(manipulators);
        manipulators.add(new SpongeSittingData(this.shadow$func_70906_o()));
        manipulators.add(this.getParrotData());
    }
}

