/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.biome;

import java.util.Collection;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeHell;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.BlockTypes;
import org.spongepowered.api.util.weighted.ChanceTable;
import org.spongepowered.api.util.weighted.EmptyObject;
import org.spongepowered.api.util.weighted.TableEntry;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.util.weighted.WeightedObject;
import org.spongepowered.api.world.gen.populator.Glowstone;
import org.spongepowered.api.world.gen.populator.NetherFire;
import org.spongepowered.api.world.gen.populator.Ore;
import org.spongepowered.api.world.gen.populator.RandomBlock;
import org.spongepowered.api.world.gen.type.MushroomType;
import org.spongepowered.api.world.gen.type.MushroomTypes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.common.mixin.core.world.biome.MixinBiome;
import org.spongepowered.common.world.biome.SpongeBiomeGenerationSettings;
import org.spongepowered.common.world.gen.WorldGenConstants;
import org.spongepowered.common.world.gen.populators.HellMushroomPopulator;

@Mixin(value={BiomeHell.class})
public abstract class MixinBiomeHell
extends MixinBiome {
    @Override
    public void buildPopulators(World world, SpongeBiomeGenerationSettings gensettings) {
        RandomBlock lava1 = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).perChunk(8).height(VariableAmount.baseWithRandomAddition(4.0, 120.0)).placementTarget(WorldGenConstants.HELL_LAVA).build();
        gensettings.getPopulators().add(lava1);
        NetherFire fire = NetherFire.builder().perChunk(VariableAmount.baseWithRandomAddition(1.0, VariableAmount.baseWithRandomAddition(1.0, 10.0))).perCluster(64).build();
        gensettings.getPopulators().add(fire);
        Glowstone glowstone1 = Glowstone.builder().blocksPerCluster(1500).clusterHeight(VariableAmount.baseWithRandomAddition(-11.0, 12.0)).perChunk(VariableAmount.baseWithRandomAddition(0.0, VariableAmount.baseWithRandomAddition(1.0, 10.0))).height(VariableAmount.baseWithRandomAddition(4.0, 120.0)).build();
        gensettings.getPopulators().add(glowstone1);
        Glowstone glowstone2 = Glowstone.builder().blocksPerCluster(1500).clusterHeight(VariableAmount.baseWithRandomAddition(0.0, 12.0)).perChunk(10).height(VariableAmount.baseWithRandomAddition(0.0, 128.0)).build();
        gensettings.getPopulators().add(glowstone2);
        ChanceTable<MushroomType> types = new ChanceTable<MushroomType>();
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.BROWN, 1.0));
        types.add(new EmptyObject(1.0));
        HellMushroomPopulator smallMushroom = new HellMushroomPopulator();
        smallMushroom.setMushroomsPerChunk(1);
        smallMushroom.getTypes().addAll((Collection<TableEntry<MushroomType>>)types);
        gensettings.getPopulators().add(smallMushroom);
        ChanceTable types2 = new ChanceTable();
        types.add((TableEntry<MushroomType>)new WeightedObject<MushroomType>(MushroomTypes.RED, 1.0));
        types.add(new EmptyObject(1.0));
        HellMushroomPopulator smallMushroom2 = new HellMushroomPopulator();
        smallMushroom2.setMushroomsPerChunk(1);
        smallMushroom2.getTypes().addAll(types2);
        gensettings.getPopulators().add(smallMushroom2);
        Ore quartz = Ore.builder().height(VariableAmount.baseWithRandomAddition(10.0, 108.0)).ore(BlockTypes.QUARTZ_ORE.getDefaultState()).perChunk(16).placementCondition(o -> o != null && o.getType() == BlockTypes.NETHERRACK).size(14).build();
        gensettings.getPopulators().add(quartz);
        int halfSeaLevel = world.func_181545_F() / 2 + 1;
        Ore magma = Ore.builder().height(VariableAmount.baseWithRandomAddition((double)(halfSeaLevel - 5), 10.0)).ore(BlockTypes.MAGMA.getDefaultState()).perChunk(4).placementCondition(o -> o != null && o.getType() == BlockTypes.NETHERRACK).size(33).build();
        gensettings.getPopulators().add(magma);
        RandomBlock lava2 = RandomBlock.builder().block((BlockState)Blocks.field_150356_k.func_176223_P()).perChunk(16).height(VariableAmount.baseWithRandomAddition(10.0, 108.0)).placementTarget(WorldGenConstants.HELL_LAVA_ENCLOSED).build();
        gensettings.getPopulators().add(lava2);
    }
}

