/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.mixin.core.world.gen;

import com.flowpowered.math.vector.Vector3i;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraft.world.gen.IChunkGenerator;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.world.SerializationBehaviors;
import org.spongepowered.api.world.storage.ChunkDataStream;
import org.spongepowered.api.world.storage.WorldProperties;
import org.spongepowered.api.world.storage.WorldStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.common.config.SpongeConfig;
import org.spongepowered.common.config.type.GeneralConfigBase;
import org.spongepowered.common.event.tracking.IPhaseState;
import org.spongepowered.common.event.tracking.PhaseTracker;
import org.spongepowered.common.event.tracking.phase.TrackingPhases;
import org.spongepowered.common.event.tracking.phase.entity.EntityPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenerationPhase;
import org.spongepowered.common.event.tracking.phase.generation.GenericGenerationContext;
import org.spongepowered.common.event.tracking.phase.plugin.PluginPhase;
import org.spongepowered.common.event.tracking.phase.tick.TickPhase;
import org.spongepowered.common.interfaces.IMixinChunk;
import org.spongepowered.common.interfaces.world.IMixinAnvilChunkLoader;
import org.spongepowered.common.interfaces.world.IMixinWorld;
import org.spongepowered.common.interfaces.world.IMixinWorldServer;
import org.spongepowered.common.interfaces.world.gen.IMixinChunkProviderServer;
import org.spongepowered.common.util.CachedLong2ObjectMap;
import org.spongepowered.common.util.SpongeHooks;
import org.spongepowered.common.world.SpongeEmptyChunk;
import org.spongepowered.common.world.storage.SpongeChunkDataStream;
import org.spongepowered.common.world.storage.WorldStorageUtil;

@Mixin(value={ChunkProviderServer.class})
public abstract class MixinChunkProviderServer
implements WorldStorage,
IMixinChunkProviderServer {
    private SpongeEmptyChunk EMPTY_CHUNK;
    private boolean denyChunkRequests = true;
    private boolean forceChunkRequests = false;
    private long chunkUnloadDelay = 15000L;
    private int maxChunkUnloads = 100;
    @Shadow
    @Final
    public WorldServer field_73251_h;
    @Shadow
    @Final
    private IChunkLoader field_73247_e;
    @Shadow
    public IChunkGenerator field_186029_c;
    @Shadow
    @Final
    @Mutable
    public Long2ObjectMap<Chunk> field_73244_f = new CachedLong2ObjectMap();

    @Shadow
    public abstract Chunk func_186026_b(int var1, int var2);

    @Shadow
    public abstract Chunk func_186028_c(int var1, int var2);

    @Shadow
    public abstract Chunk func_73239_e(int var1, int var2);

    @Shadow
    public abstract Chunk func_186025_d(int var1, int var2);

    @Shadow
    public abstract void func_73243_a(Chunk var1);

    @Shadow
    public abstract void func_73242_b(Chunk var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onConstruct(WorldServer worldObjIn, IChunkLoader chunkLoaderIn, IChunkGenerator chunkGeneratorIn, CallbackInfo ci) {
        if (((IMixinWorld)worldObjIn).isFake()) {
            return;
        }
        this.EMPTY_CHUNK = new SpongeEmptyChunk((World)worldObjIn, 0, 0);
        SpongeConfig<? extends GeneralConfigBase> spongeConfig = SpongeHooks.getWorldConfig(worldObjIn);
        ((IMixinWorldServer)worldObjIn).updateConfigCache();
        this.denyChunkRequests = spongeConfig.getConfig().getWorld().getDenyChunkRequests();
        this.chunkUnloadDelay = spongeConfig.getConfig().getWorld().getChunkUnloadDelay() * 1000L;
        this.maxChunkUnloads = spongeConfig.getConfig().getWorld().getMaxChunkUnloads();
    }

    @Override
    public WorldServer getWorld() {
        return this.field_73251_h;
    }

    @Override
    public ChunkDataStream getGeneratedChunks() {
        if (!(this.field_73247_e instanceof IMixinAnvilChunkLoader)) {
            throw new UnsupportedOperationException("unknown chunkLoader");
        }
        return new SpongeChunkDataStream(((IMixinAnvilChunkLoader)this.field_73247_e).getWorldDir());
    }

    @Override
    public CompletableFuture<Boolean> doesChunkExist(Vector3i chunkCoords) {
        return WorldStorageUtil.doesChunkExist(this.field_73251_h, this.field_73247_e, chunkCoords);
    }

    @Override
    public CompletableFuture<Boolean> doesChunkExistSync(Vector3i chunkCoords) {
        return WorldStorageUtil.doesChunkExistSync(this.field_73251_h, this.field_73247_e, chunkCoords);
    }

    @Override
    public CompletableFuture<Optional<DataContainer>> getChunkData(Vector3i chunkCoords) {
        return WorldStorageUtil.getChunkData(this.field_73251_h, this.field_73247_e, chunkCoords);
    }

    @Override
    public WorldProperties getWorldProperties() {
        return (WorldProperties)this.field_73251_h.func_72912_H();
    }

    @Overwrite
    public void func_189549_a(Chunk chunkIn) {
        if (!((IMixinChunk)chunkIn).isPersistedChunk() && this.field_73251_h.field_73011_w.func_186056_c(chunkIn.field_76635_g, chunkIn.field_76647_h)) {
            chunkIn.field_189550_d = true;
        }
    }

    private Chunk loadChunkForce(int x, int z) {
        Chunk chunk = this.func_73239_e(x, z);
        if (chunk != null) {
            this.field_73244_f.put(ChunkPos.func_77272_a((int)x, (int)z), (Object)chunk);
            chunk.func_76631_c();
            chunk.func_186030_a((IChunkProvider)((ChunkProviderServer)this), this.field_186029_c);
        }
        return chunk;
    }

    @Redirect(method={"provideChunk"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/gen/ChunkProviderServer;loadChunk(II)Lnet/minecraft/world/chunk/Chunk;"))
    public Chunk onProvideChunkHead(ChunkProviderServer chunkProviderServer, int x, int z) {
        if (!this.denyChunkRequests) {
            return this.func_186028_c(x, z);
        }
        Chunk chunk = this.func_186026_b(x, z);
        if (chunk == null && this.canDenyChunkRequest()) {
            return this.EMPTY_CHUNK;
        }
        if (chunk == null) {
            chunk = this.loadChunkForce(x, z);
        }
        return chunk;
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/math/ChunkPos;asLong(II)J")})
    private void onProvideChunkStart(int x, int z, CallbackInfoReturnable<Chunk> cir) {
        ((GenericGenerationContext)GenerationPhase.State.TERRAIN_GENERATION.createPhaseContext().world((World)this.field_73251_h)).buildAndSwitch();
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/chunk/Chunk;populate(Lnet/minecraft/world/chunk/IChunkProvider;Lnet/minecraft/world/gen/IChunkGenerator;)V", shift=At.Shift.AFTER)})
    private void onProvideChunkEnd(int x, int z, CallbackInfoReturnable<Chunk> ci) {
        PhaseTracker.getInstance().getCurrentContext().close();
    }

    @Inject(method={"provideChunk"}, at={@At(value="INVOKE", target="Lnet/minecraft/crash/CrashReport;makeCrashReport(Ljava/lang/Throwable;Ljava/lang/String;)Lnet/minecraft/crash/CrashReport;")})
    private void onError(CallbackInfoReturnable<Chunk> ci) {
        PhaseTracker.getInstance().getCurrentContext().close();
    }

    private boolean canDenyChunkRequest() {
        if (!SpongeImpl.getServer().func_152345_ab()) {
            return true;
        }
        if (this.forceChunkRequests) {
            return false;
        }
        PhaseTracker phaseTracker = PhaseTracker.getInstance();
        IPhaseState<?> currentState = phaseTracker.getCurrentState();
        if (currentState == TickPhase.Tick.PLAYER || currentState == TickPhase.Tick.DIMENSION || currentState == EntityPhase.State.CHANGING_DIMENSION || currentState == EntityPhase.State.LEAVING_DIMENSION) {
            return false;
        }
        if (currentState == GenerationPhase.State.WORLD_SPAWNER_SPAWNING || currentState == PluginPhase.Listener.PRE_SERVER_TICK_LISTENER || currentState == PluginPhase.Listener.POST_SERVER_TICK_LISTENER) {
            return true;
        }
        return currentState.getPhase() == TrackingPhases.BLOCK || currentState.getPhase() == TrackingPhases.ENTITY || currentState.getPhase() == TrackingPhases.TICK;
    }

    @Override
    public boolean getForceChunkRequests() {
        return this.forceChunkRequests;
    }

    @Override
    public void setMaxChunkUnloads(int maxUnloads) {
        this.maxChunkUnloads = maxUnloads;
    }

    @Override
    public void setForceChunkRequests(boolean flag) {
        this.forceChunkRequests = flag;
    }

    @Override
    public void setDenyChunkRequests(boolean flag) {
        this.denyChunkRequests = flag;
    }

    @Override
    public long getChunkUnloadDelay() {
        return this.chunkUnloadDelay;
    }

    @Overwrite
    public boolean func_73156_b() {
        if (!this.field_73251_h.field_73058_d && !((IMixinWorld)this.field_73251_h).isFake()) {
            ((IMixinWorldServer)this.field_73251_h).getTimingsHandler().doChunkUnload.startTiming();
            ObjectIterator iterator = this.field_73244_f.values().iterator();
            int chunksUnloaded = 0;
            long now = System.currentTimeMillis();
            while (chunksUnloaded < this.maxChunkUnloads && iterator.hasNext()) {
                Chunk chunk = (Chunk)iterator.next();
                IMixinChunk spongeChunk = (IMixinChunk)chunk;
                if (chunk == null || !chunk.field_189550_d || spongeChunk.isPersistedChunk()) continue;
                if (this.getChunkUnloadDelay() > 0L) {
                    if (now - spongeChunk.getScheduledForUnload() < this.chunkUnloadDelay) continue;
                    spongeChunk.setScheduledForUnload(-1L);
                }
                chunk.func_76623_d();
                this.func_73242_b(chunk);
                this.func_73243_a(chunk);
                iterator.remove();
                ++chunksUnloaded;
            }
            ((IMixinWorldServer)this.field_73251_h).getTimingsHandler().doChunkUnload.stopTiming();
        }
        this.field_73247_e.func_75817_a();
        return false;
    }

    @Override
    public Chunk getLoadedChunkWithoutMarkingActive(int x, int z) {
        long i = ChunkPos.func_77272_a((int)x, (int)z);
        Chunk chunk = (Chunk)this.field_73244_f.get(i);
        return chunk;
    }

    @Inject(method={"canSave"}, at={@At(value="HEAD")}, cancellable=true)
    public void onCanSave(CallbackInfoReturnable<Boolean> cir) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            cir.setReturnValue(false);
        }
    }

    @Inject(method={"saveChunkData"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSaveChunkData(Chunk chunkIn, CallbackInfo ci) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            ci.cancel();
        }
    }

    @Inject(method={"flushToDisk"}, at={@At(value="HEAD")}, cancellable=true)
    public void onFlushToDisk(CallbackInfo ci) {
        if (((WorldProperties)this.field_73251_h.func_72912_H()).getSerializationBehavior() == SerializationBehaviors.NONE) {
            ci.cancel();
        }
    }

    @Override
    public void unloadChunkAndSave(Chunk chunk) {
        boolean saveChunk = false;
        if (chunk.func_76601_a(true)) {
            saveChunk = true;
        }
        chunk.func_76623_d();
        if (saveChunk) {
            this.func_73242_b(chunk);
        }
        this.field_73244_f.remove(ChunkPos.func_77272_a((int)chunk.field_76635_g, (int)chunk.field_76647_h));
        ((IMixinChunk)chunk).setScheduledForUnload(-1L);
    }
}

