/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.registry.type.world.gen;

import com.google.common.base.Preconditions;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenBigTree;
import net.minecraft.world.gen.feature.WorldGenBirchTree;
import net.minecraft.world.gen.feature.WorldGenCanopyTree;
import net.minecraft.world.gen.feature.WorldGenDesertWells;
import net.minecraft.world.gen.feature.WorldGenMegaJungle;
import net.minecraft.world.gen.feature.WorldGenMegaPineTree;
import net.minecraft.world.gen.feature.WorldGenSavannaTree;
import net.minecraft.world.gen.feature.WorldGenShrub;
import net.minecraft.world.gen.feature.WorldGenSwamp;
import net.minecraft.world.gen.feature.WorldGenTaiga1;
import net.minecraft.world.gen.feature.WorldGenTaiga2;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.spongepowered.api.registry.AdditionalCatalogRegistryModule;
import org.spongepowered.api.registry.AlternateCatalogRegistryModule;
import org.spongepowered.api.registry.util.RegisterCatalog;
import org.spongepowered.api.util.weighted.VariableAmount;
import org.spongepowered.api.world.gen.PopulatorObject;
import org.spongepowered.api.world.gen.PopulatorObjects;
import org.spongepowered.common.interfaces.world.gen.IWorldGenTrees;
import org.spongepowered.common.registry.type.AbstractPrefixAlternateCatalogTypeRegistryModule;

@RegisterCatalog(value=PopulatorObjects.class)
public class PopulatorObjectRegistryModule
extends AbstractPrefixAlternateCatalogTypeRegistryModule<PopulatorObject>
implements AlternateCatalogRegistryModule<PopulatorObject>,
AdditionalCatalogRegistryModule<PopulatorObject> {
    public PopulatorObjectRegistryModule() {
        super("minecraft");
    }

    @Override
    public void registerAdditionalCatalog(PopulatorObject extraCatalog) {
        Preconditions.checkNotNull((Object)extraCatalog, (Object)"CatalogType cannot be null");
        Preconditions.checkArgument((!extraCatalog.getId().isEmpty() ? 1 : 0) != 0, (Object)"Id cannot be empty");
        Preconditions.checkArgument((!this.catalogTypeMap.containsKey(extraCatalog.getId()) ? 1 : 0) != 0, (Object)"Duplicate Id");
        this.catalogTypeMap.put(extraCatalog.getId(), extraCatalog);
    }

    @Override
    public void registerDefaults() {
        this.register((WorldGenerator)new WorldGenDesertWells());
        this.register((WorldGenerator)new WorldGenTrees(false));
        this.register((WorldGenerator)new WorldGenBigTree(false));
        this.register((WorldGenerator)new WorldGenBirchTree(false, false));
        this.register((WorldGenerator)new WorldGenBirchTree(false, true));
        this.register((WorldGenerator)new WorldGenTaiga2(false));
        this.register((WorldGenerator)new WorldGenTaiga1());
        this.register((WorldGenerator)new WorldGenMegaPineTree(false, true));
        this.register((WorldGenerator)new WorldGenMegaPineTree(false, false));
        IBlockState jlog = Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE);
        IBlockState jleaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IBlockState leaf = Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false));
        IWorldGenTrees trees = (IWorldGenTrees)new WorldGenTrees(false, 4, jlog, jleaf, true);
        trees.setId("minecraft:jungle");
        trees.setName("Jungle tree");
        trees.setMinHeight(VariableAmount.baseWithRandomAddition(4.0, 7.0));
        this.register((WorldGenerator)((WorldGenTrees)trees));
        this.register((WorldGenerator)new WorldGenMegaJungle(false, 10, 20, jlog, jleaf));
        WorldGenShrub bush = new WorldGenShrub(jlog, leaf);
        this.register((WorldGenerator)bush);
        this.register((WorldGenerator)new WorldGenSavannaTree(false));
        this.register((WorldGenerator)new WorldGenCanopyTree(false));
        this.register((WorldGenerator)new WorldGenSwamp());
        this.register((WorldGenerator)new WorldGenBigMushroom(Blocks.field_150420_aW));
        this.register((WorldGenerator)new WorldGenBigMushroom(Blocks.field_150419_aX));
    }

    @Override
    private void register(WorldGenerator worldGenerator) {
        this.register((PopulatorObject)worldGenerator);
    }
}

