/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.text.action;

import net.minecraft.entity.EntityList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.event.HoverEvent;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.common.entity.SpongeEntityType;
import org.spongepowered.common.interfaces.text.IMixinHoverEvent;
import org.spongepowered.common.text.SpongeTexts;

public class SpongeHoverAction {
    private SpongeHoverAction() {
    }

    private static HoverEvent.Action getType(HoverAction<?> action) {
        if (action instanceof HoverAction.ShowEntity) {
            return HoverEvent.Action.SHOW_ENTITY;
        }
        if (action instanceof HoverAction.ShowItem) {
            return HoverEvent.Action.SHOW_ITEM;
        }
        if (action instanceof HoverAction.ShowText) {
            return HoverEvent.Action.SHOW_TEXT;
        }
        throw new UnsupportedOperationException(action.getClass().toString());
    }

    public static HoverEvent getHandle(HoverAction<?> action) {
        ITextComponent component;
        HoverEvent.Action type = SpongeHoverAction.getType(action);
        switch (type) {
            case SHOW_ENTITY: {
                HoverAction.ShowEntity.Ref entity = (HoverAction.ShowEntity.Ref)((HoverAction.ShowEntity)action).getResult();
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("id", entity.getUniqueId().toString());
                if (entity.getType().isPresent()) {
                    nbt.func_74778_a("type", EntityList.func_191306_a(((SpongeEntityType)entity.getType().get()).entityClass).toString());
                }
                nbt.func_74778_a("name", entity.getName());
                component = new TextComponentString(nbt.toString());
                break;
            }
            case SHOW_ITEM: {
                ItemStack item = (ItemStack)((ItemStackSnapshot)action.getResult()).createStack();
                NBTTagCompound nbt = new NBTTagCompound();
                item.func_77955_b(nbt);
                component = new TextComponentString(nbt.toString());
                break;
            }
            case SHOW_TEXT: {
                component = SpongeTexts.toComponent((Text)action.getResult());
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        HoverEvent event = new HoverEvent(type, component);
        ((IMixinHoverEvent)event).setHandle(action);
        return event;
    }
}

