/*
 * Decompiled with CFR 0.152.
 */
package com.nekokittygames.thaumictinkerer.common.tileentity;

import com.nekokittygames.thaumictinkerer.common.config.TTConfig;
import com.nekokittygames.thaumictinkerer.common.helper.Tuple4Int;
import com.nekokittygames.thaumictinkerer.common.multiblocks.MultiblockManager;
import com.nekokittygames.thaumictinkerer.common.tileentity.TileEntityThaumicTinkerer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.ArrayUtils;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.client.fx.FXDispatcher;
import thaumcraft.common.items.resources.ItemCrystalEssence;
import thaumcraft.common.lib.utils.InventoryUtils;

public class TileEntityEnchanter
extends TileEntityThaumicTinkerer
implements ITickable {
    private static final String TAG_ENCHANTS = "enchantsIntArray";
    private static final String TAG_LEVELS = "levelsIntArray";
    private static final String TAG_CACHED_ENCHANTS = "cachedEnchants";
    private static final String TAG_WORKING = "working";
    private static final String TAG_PROGRESS = "progress";
    public static final ResourceLocation MULTIBLOCK_LOCATION = new ResourceLocation("thaumictinkerer", "osmotic_enchanter");
    private List<Integer> enchantments = new ArrayList<Integer>();
    private List<Integer> levels = new ArrayList<Integer>();
    private List<Integer> cachedEnchantments = new ArrayList<Integer>();
    private int progress;
    private boolean working = false;
    private List<Tuple4Int> pillars = new ArrayList<Tuple4Int>();
    private Vec3d[] points = new Vec3d[]{new Vec3d(-1.2, 2.15, -1.2), new Vec3d(-2.2, 2.15, 0.5), new Vec3d(-1.2, 2.15, 2.2), new Vec3d(0.5, 2.15, 3.2), new Vec3d(2.2, 2.15, 2.2), new Vec3d(3.2, 2.15, 0.5), new Vec3d(2.2, 2.15, -1.2), new Vec3d(0.5, 2.15, -2.2)};
    private Color c;
    private ItemStackHandler inventory;

    public TileEntityEnchanter() {
        this.c = new Color(MapColor.field_151647_F.field_76291_p);
        this.inventory = new ItemStackHandler(1){

            protected void onContentsChanged(int slot) {
                super.onContentsChanged(slot);
                TileEntityEnchanter.this.onInventoryChanged(this.getStackInSlot(slot));
                TileEntityEnchanter.this.sendUpdates();
            }

            public boolean isItemValidForSlot(int index, ItemStack stack) {
                return TileEntityEnchanter.this.isItemValidForSlot(index, stack);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValidForSlot(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    public List<Integer> getEnchantments() {
        return this.enchantments;
    }

    public List<Integer> getLevels() {
        return this.levels;
    }

    public List<Integer> getCachedEnchantments() {
        return this.cachedEnchantments;
    }

    public boolean isWorking() {
        return this.working;
    }

    public List<Tuple4Int> getPillars() {
        return this.pillars;
    }

    public void clearEnchants() {
        this.enchantments.clear();
        this.levels.clear();
    }

    public void setWorking(boolean working) {
        this.working = working;
        this.sendUpdates();
    }

    public void appendEnchant(int enchant) {
        this.enchantments.add(enchant);
        this.refreshEnchants();
        this.sendUpdates();
    }

    public void appendLevel(int level) {
        this.levels.add(level);
    }

    public void removeEnchant(int index) {
        this.enchantments.remove(index);
    }

    public void removeLevel(int index) {
        this.levels.remove(index);
    }

    public void setEnchant(int index, int enchant) {
        this.enchantments.set(index, enchant);
    }

    public void setLevel(int index, int level) {
        this.levels.set(index, level);
    }

    private void onInventoryChanged(ItemStack stackInSlot) {
        this.refreshEnchants();
    }

    public void refreshEnchants() {
        List<Enchantment> enchantmentObjects = this.getAvailableEnchants(this.enchantments.stream().map(Enchantment::func_185262_c).collect(Collectors.toList()));
        this.cachedEnchantments = enchantmentObjects.stream().map(Enchantment::func_185258_b).collect(Collectors.toList());
    }

    public boolean isItemValidForSlot(int index, ItemStack stack) {
        Item item = stack.func_77973_b();
        return item.func_77616_k(stack);
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        nbttagcompound.func_74783_a(TAG_ENCHANTS, this.enchantments.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74783_a(TAG_LEVELS, this.levels.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74783_a(TAG_CACHED_ENCHANTS, this.cachedEnchantments.stream().mapToInt(i -> i).toArray());
        nbttagcompound.func_74768_a(TAG_PROGRESS, this.progress);
        nbttagcompound.func_74757_a(TAG_WORKING, this.working);
    }

    @Override
    public void readExtraNBT(NBTTagCompound nbttagcompound) {
        this.inventory.deserializeNBT(nbttagcompound.func_74775_l("inventory"));
        if (nbttagcompound.func_74764_b(TAG_ENCHANTS)) {
            this.enchantments.clear();
            this.levels.clear();
            this.cachedEnchantments.clear();
            int[] enchantmentArray = nbttagcompound.func_74759_k(TAG_ENCHANTS);
            Arrays.stream(enchantmentArray).forEach(i -> this.enchantments.add(i));
            int[] levelsArray = nbttagcompound.func_74759_k(TAG_LEVELS);
            Arrays.stream(levelsArray).forEach(i -> this.levels.add(i));
            int[] cachedEnchantmentArray = nbttagcompound.func_74759_k(TAG_CACHED_ENCHANTS);
            Arrays.stream(cachedEnchantmentArray).forEach(i -> this.cachedEnchantments.add(i));
        }
        if (nbttagcompound.func_74764_b(TAG_PROGRESS)) {
            this.progress = nbttagcompound.func_74762_e(TAG_PROGRESS);
        }
        if (nbttagcompound.func_74764_b(TAG_WORKING)) {
            this.working = nbttagcompound.func_74767_n(TAG_WORKING);
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            this.clearEnchants();
        }
        if (this.working) {
            ItemStack tool = this.inventory.getStackInSlot(0);
            if (tool == ItemStack.field_190927_a) {
                this.working = false;
                this.progress = 0;
                return;
            }
            this.checkStructure();
            if (!this.working) {
                this.progress = 0;
                return;
            }
            ++this.progress;
            if (this.field_145850_b.field_72995_K && !TTConfig.ClassicEnchanter) {
                float tmp = (float)this.progress / 300.0f * 100.0f / 75.0f * 100.0f;
                if (tmp >= 0.0f) {
                    this.arcPoints(0, 1);
                }
                if ((double)tmp >= 12.5) {
                    this.arcPoints(1, 2);
                }
                if (tmp >= 25.0f) {
                    this.arcPoints(2, 3);
                }
                if ((double)tmp >= 37.5) {
                    this.arcPoints(3, 4);
                }
                if (tmp >= 50.0f) {
                    this.arcPoints(4, 5);
                }
                if ((double)tmp >= 62.5) {
                    this.arcPoints(5, 6);
                }
                if (tmp >= 75.0f) {
                    this.arcPoints(6, 7);
                }
                if ((double)tmp >= 87.5) {
                    this.arcPoints(7, 0);
                }
                if (tmp >= 100.0f) {
                    for (Vec3d point : this.points) {
                        Vec3d curPos = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                        Vec3d originPos = curPos.func_178787_e(point);
                        FXDispatcher.INSTANCE.arcLightning(originPos.field_72450_a, originPos.field_72448_b, originPos.field_72449_c, (double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177984_a().func_177956_o() + 0.5f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f), (float)this.c.getRed() / 255.0f, (float)this.c.getGreen() / 255.0f, (float)this.c.getBlue() / 255.0f, 0.5f);
                    }
                }
            }
            if (this.progress > 300) {
                if (!this.field_145850_b.field_72995_K) {
                    for (int i = 0; i < this.enchantments.size(); ++i) {
                        tool.func_77966_a(Enchantment.func_185262_c((int)this.enchantments.get(i)), this.levels.get(i).intValue());
                    }
                }
                this.progress = 0;
                this.working = false;
                this.clearEnchants();
                this.sendUpdates();
            }
        }
    }

    public boolean playerHasIngredients(List<ItemStack> stacks, EntityPlayer player) {
        for (ItemStack stack : stacks) {
            if (InventoryUtils.isPlayerCarryingAmount((EntityPlayer)player, (ItemStack)stack, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    public void takeIngredients(List<ItemStack> stacks, EntityPlayer player) {
        for (ItemStack stack : stacks) {
            InventoryUtils.consumePlayerItem((EntityPlayer)player, (ItemStack)stack, (boolean)true, (boolean)false);
        }
    }

    private void arcPoints(int start, int end) {
        Vec3d curPos = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
        Vec3d originPos = curPos.func_178787_e(this.points[start]);
        Vec3d nextPos = curPos.func_178787_e(this.points[end]);
        FXDispatcher.INSTANCE.arcLightning(originPos.field_72450_a, originPos.field_72448_b, originPos.field_72449_c, nextPos.field_72450_a, nextPos.field_72448_b, nextPos.field_72449_c, (float)this.c.getRed() / 255.0f, (float)this.c.getGreen() / 255.0f, (float)this.c.getBlue() / 255.0f, 1.0f);
    }

    private void checkStructure() {
        if (TTConfig.ClassicEnchanter) {
            this.checkPillars();
        } else if (!MultiblockManager.checkMultiblockCombined(this.field_145850_b, this.func_174877_v(), MULTIBLOCK_LOCATION)) {
            this.working = false;
        }
    }

    public boolean checkPillars() {
        if (this.pillars.isEmpty()) {
            if (this.assignPillars()) {
                this.working = false;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.pillars.size(); ++i) {
            Tuple4Int pillar = this.pillars.get(i);
            int pillarHeight = this.findPillar(new BlockPos(pillar.i1, pillar.i2, pillar.i3));
            if (pillarHeight == -1) {
                this.pillars.clear();
                return this.checkPillars();
            }
            if (pillarHeight == pillar.i4) continue;
            pillar.i4 = pillarHeight;
        }
        return true;
    }

    public boolean assignPillars() {
        int y = this.field_174879_c.func_177956_o();
        for (int x = this.field_174879_c.func_177958_n() - 4; x <= this.field_174879_c.func_177958_n() + 4; ++x) {
            for (int z = this.field_174879_c.func_177952_p() - 4; z <= this.field_174879_c.func_177952_p() + 4; ++z) {
                int height = this.findPillar(new BlockPos(x, y, z));
                if (height != -1) {
                    this.pillars.add(new Tuple4Int(x, y, z, height));
                }
                if (this.pillars.size() != 6) continue;
                return false;
            }
        }
        this.pillars.clear();
        return true;
    }

    public int findPillar(BlockPos pillarPos) {
        int obsidianFound = 0;
        int i = 0;
        while (pillarPos.func_177956_o() + i < 256) {
            IBlockState id = this.field_145850_b.func_180495_p(pillarPos.func_177981_b(i));
            if (id.func_177230_c() == Blocks.field_150343_Z) {
                ++obsidianFound;
            } else {
                if (BlocksTC.nitor.containsValue(id.func_177230_c())) {
                    if (obsidianFound >= 2 && obsidianFound < 13) {
                        return pillarPos.func_177956_o() + i;
                    }
                    return -1;
                }
                return -1;
            }
            ++i;
        }
        return -1;
    }

    public List<Enchantment> getValidEnchantments() {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            return enchantments;
        }
        ItemStack item = this.inventory.getStackInSlot(0);
        for (Enchantment enchantment : Enchantment.field_185264_b) {
            if (item.func_77973_b().getItemEnchantability(item) == 0 || !TileEntityEnchanter.canApply(item, enchantment, enchantments, false)) continue;
            enchantments.add(enchantment);
        }
        return enchantments;
    }

    public List<Enchantment> getAvailableEnchants(List<Enchantment> currentEnchants) {
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>();
        if (this.inventory.getStackInSlot(0) == ItemStack.field_190927_a) {
            return enchantments;
        }
        ItemStack item = this.inventory.getStackInSlot(0);
        List<Enchantment> valid = this.getValidEnchantments();
        for (Enchantment validEnchant : valid) {
            if (item.func_77973_b().getItemEnchantability(item) == 0 || !TileEntityEnchanter.canApply(item, validEnchant, enchantments, false) || !TileEntityEnchanter.canApply(item, validEnchant, currentEnchants)) continue;
            enchantments.add(validEnchant);
        }
        return enchantments;
    }

    public List<ItemStack> getEnchantmentCost() {
        ArrayList<ItemStack> costs = new ArrayList<ItemStack>();
        HashMap<Aspect, Integer> costItems = new HashMap<Aspect, Integer>();
        List enchantmentObjects = this.enchantments.stream().map(Enchantment::func_185262_c).collect(Collectors.toList());
        for (Enchantment enchantment : enchantmentObjects) {
            switch (enchantment.field_77351_y) {
                case ARMOR: {
                    this.addOneTo(costItems, Aspect.PROTECT);
                    break;
                }
                case ARMOR_FEET: {
                    this.addOneTo(costItems, Aspect.PROTECT);
                    this.addOneTo(costItems, Aspect.MOTION);
                    break;
                }
                case ARMOR_CHEST: {
                    this.addOneTo(costItems, Aspect.PROTECT);
                    this.addOneTo(costItems, Aspect.LIFE);
                    break;
                }
                case ARMOR_LEGS: {
                    this.addOneTo(costItems, Aspect.PROTECT);
                    break;
                }
                case ARMOR_HEAD: {
                    this.addOneTo(costItems, Aspect.PROTECT);
                    this.addOneTo(costItems, Aspect.MIND);
                    break;
                }
                case DIGGER: {
                    this.addOneTo(costItems, Aspect.ENTROPY);
                    this.addOneTo(costItems, Aspect.TOOL);
                    break;
                }
                case BREAKABLE: {
                    this.addOneTo(costItems, Aspect.ENTROPY);
                    break;
                }
                case WEARABLE: {
                    this.addOneTo(costItems, Aspect.MAN);
                    break;
                }
                case WEAPON: {
                    this.addOneTo(costItems, Aspect.ENTROPY);
                    this.addOneTo(costItems, Aspect.DEATH);
                    break;
                }
                case BOW: {
                    this.addOneTo(costItems, Aspect.ENTROPY);
                    this.addOneTo(costItems, Aspect.DEATH);
                    break;
                }
                case FISHING_ROD: {
                    this.addOneTo(costItems, Aspect.ENTROPY);
                    this.addOneTo(costItems, Aspect.BEAST);
                }
            }
        }
        for (Aspect item : costItems.keySet()) {
            ItemStack crystal = new ItemStack(ItemsTC.crystalEssence);
            ((ItemCrystalEssence)crystal.func_77973_b()).setAspects(crystal, new AspectList().add(item, ((Integer)costItems.get(item)).intValue()));
            costs.add(crystal);
        }
        return costs;
    }

    private void addOneTo(Map<Aspect, Integer> costItems, Aspect crystalEssence) {
        if (costItems.containsKey(crystalEssence)) {
            costItems.put(crystalEssence, costItems.get(crystalEssence) + 1);
        } else {
            costItems.put(crystalEssence, 1);
        }
    }

    public static boolean canApply(ItemStack itemStack, Enchantment enchantment, List<Enchantment> currentEnchants) {
        return TileEntityEnchanter.canApply(itemStack, enchantment, currentEnchants, true);
    }

    public static boolean canApply(ItemStack itemStack, Enchantment enchantment, List<Enchantment> currentEnchants, boolean checkConflicts) {
        if (ArrayUtils.contains((int[])TTConfig.blacklistedEnchants, (int)Enchantment.func_185258_b((Enchantment)enchantment))) {
            return false;
        }
        if (!enchantment.func_92089_a(itemStack) || !enchantment.field_77351_y.func_77557_a(itemStack.func_77973_b()) || currentEnchants.contains(enchantment)) {
            return false;
        }
        if (EnchantmentHelper.func_82781_a((ItemStack)itemStack).keySet().contains(enchantment)) {
            return false;
        }
        if (checkConflicts) {
            for (Enchantment curEnchant : currentEnchants) {
                if (curEnchant.func_191560_c(enchantment)) continue;
                return false;
            }
        }
        return true;
    }

    public int getProgress() {
        return this.progress;
    }
}

