/*
 * Decompiled with CFR 0.152.
 */
package cubex2.cs4.util;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class RenderHelper {
    public static void renderGuiFluid(FluidStack fluid, float fill, int x, int y, int width, int maxHeight) {
        TextureAtlasSprite sprite;
        if (fluid != null && fluid.getFluid() != null && fluid.amount > 0 && (sprite = RenderHelper.getStillTexture(fluid)) != null) {
            int rendHeight = (int)Math.max(Math.min((float)maxHeight, (float)maxHeight * fill), 1.0f);
            int yPos = y + maxHeight - rendHeight;
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int fluidColor = fluid.getFluid().getColor(fluid);
            GL11.glColor3ub((byte)((byte)(fluidColor >> 16 & 0xFF)), (byte)((byte)(fluidColor >> 8 & 0xFF)), (byte)((byte)(fluidColor & 0xFF)));
            GlStateManager.func_179147_l();
            for (int i = 0; i < width; i += 16) {
                for (int j = 0; j < rendHeight; j += 16) {
                    int dwt = Math.min(width - i, 16);
                    int dht = Math.min(rendHeight - j, 16);
                    int dx = x + i;
                    int dy = yPos + j;
                    double minU = sprite.func_94209_e();
                    double maxU = sprite.func_94212_f();
                    double minV = sprite.func_94206_g();
                    double maxV = sprite.func_94210_h();
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder tes = tessellator.func_178180_c();
                    tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    tes.func_181662_b((double)dx, (double)(dy + dht), 0.0).func_187315_a(minU, minV + (maxV - minV) * (double)dht / 16.0).func_181675_d();
                    tes.func_181662_b((double)(dx + dwt), (double)(dy + dht), 0.0).func_187315_a(minU + (maxU - minU) * (double)dwt / 16.0, minV + (maxV - minV) * (double)dht / 16.0).func_181675_d();
                    tes.func_181662_b((double)(dx + dwt), (double)dy, 0.0).func_187315_a(minU + (maxU - minU) * (double)dwt / 16.0, minV).func_181675_d();
                    tes.func_181662_b((double)dx, (double)dy, 0.0).func_187315_a(minU, minV).func_181675_d();
                    tessellator.func_78381_a();
                }
            }
            GlStateManager.func_179084_k();
        }
    }

    public static TextureAtlasSprite getStillTexture(FluidStack fluid) {
        return fluid != null && fluid.getFluid() != null ? RenderHelper.getStillTexture(fluid.getFluid()) : null;
    }

    public static TextureAtlasSprite getStillTexture(Fluid fluid) {
        ResourceLocation tex = fluid.getStill();
        return tex == null ? null : Minecraft.func_71410_x().func_147117_R().getTextureExtry(tex.toString());
    }
}

