/*
 * Decompiled with CFR 0.152.
 */
package net.machinemuse.powersuits.capabilities;

import javax.annotation.Nonnull;
import net.machinemuse.numina.item.MuseItemUtils;
import net.machinemuse.numina.module.IModuleManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.EnergyStorage;

public class ForgeEnergyItemWrapper
extends EnergyStorage
implements INBTSerializable<NBTTagCompound> {
    ItemStack container;
    IModuleManager moduleManager;

    public ForgeEnergyItemWrapper(@Nonnull ItemStack container, IModuleManager moduleManagerIn) {
        super((int)moduleManagerIn.getOrSetModularPropertyDouble(container, "maxEnergy"));
        this.moduleManager = moduleManagerIn;
        this.container = container;
    }

    public int receiveEnergy(int energyProvided, boolean simulate) {
        if (!this.canReceive()) {
            return 0;
        }
        int energyReceived = super.receiveEnergy(energyProvided, simulate);
        if (!simulate && energyReceived > 0) {
            NBTTagCompound nbt = this.serializeNBT();
            this.energy = nbt.func_150297_b("currEnergy", 3) ? nbt.func_74762_e("currEnergy") : 0;
            MuseItemUtils.setDoubleOrRemove((ItemStack)this.container, (String)"currEnergy", (double)this.energy);
        }
        return energyReceived;
    }

    public int extractEnergy(int energyRequested, boolean simulate) {
        if (!this.canExtract()) {
            return 0;
        }
        int energyExtracted = super.extractEnergy(energyRequested, simulate);
        if (!simulate && energyExtracted > 0) {
            NBTTagCompound nbt = this.serializeNBT();
            this.energy = nbt.func_150297_b("currEnergy", 3) ? nbt.func_74762_e("currEnergy") : 0;
            MuseItemUtils.setDoubleOrRemove((ItemStack)this.container, (String)"currEnergy", (double)this.energy);
        }
        return energyExtracted;
    }

    public void updateFromNBT() {
        this.maxExtract = this.maxReceive = (int)this.moduleManager.getOrSetModularPropertyDouble(this.container, "maxEnergy");
        this.capacity = this.maxReceive;
        this.energy = Math.min(this.capacity, (int)Math.round(MuseItemUtils.getDoubleOrZero((ItemStack)this.container, (String)"currEnergy")));
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        if (this.energy > 0) {
            nbt.func_74768_a("currEnergy", this.energy);
        }
        nbt.func_74768_a("maxEnergy", this.capacity);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.energy = nbt.func_150297_b("currEnergy", 3) ? nbt.func_74762_e("currEnergy") : 0;
        this.maxExtract = this.maxReceive = nbt.func_74762_e("maxEnergy");
        this.capacity = this.maxReceive;
    }
}

