/*
 * Decompiled with CFR 0.152.
 */
package lumien.randomthings.handler.spectrecoils;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.energy.IEnergyStorage;

public class SpectreCoilHandler
extends WorldSavedData {
    static final String ID = "rtSpectreCoilHandler";
    static final int MAX_ENERGY = 1000000;
    Map<UUID, Integer> coilEntries = new HashMap<UUID, Integer>();

    public SpectreCoilHandler() {
        this(ID);
    }

    public SpectreCoilHandler(String id) {
        super(id);
    }

    public IEnergyStorage getStorage(final UUID owner) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int currentEnergy = SpectreCoilHandler.this.coilEntries.containsKey(owner) ? SpectreCoilHandler.this.coilEntries.get(owner) : 0;
                int newEnergy = Math.min(1000000, currentEnergy + maxReceive);
                SpectreCoilHandler.this.coilEntries.put(owner, newEnergy);
                return newEnergy - currentEnergy;
            }

            public int getMaxEnergyStored() {
                return 1000000;
            }

            public int getEnergyStored() {
                return SpectreCoilHandler.this.coilEntries.containsKey(owner) ? SpectreCoilHandler.this.coilEntries.get(owner) : 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                return 0;
            }

            public boolean canReceive() {
                return true;
            }

            public boolean canExtract() {
                return false;
            }
        };
    }

    public static SpectreCoilHandler get(World worldObj) {
        SpectreCoilHandler instance = (SpectreCoilHandler)worldObj.func_175693_T().func_75742_a(SpectreCoilHandler.class, ID);
        if (instance == null) {
            instance = new SpectreCoilHandler();
            worldObj.func_175693_T().func_75745_a(ID, (WorldSavedData)instance);
        }
        return instance;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList list = nbt.func_150295_c("coilEntries", 10);
        this.coilEntries.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            UUID uuid = UUID.fromString(compound.func_74779_i("uuid"));
            int energy = compound.func_74762_e("energy");
            this.coilEntries.put(uuid, energy);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry<UUID, Integer> entry : this.coilEntries.entrySet()) {
            NBTTagCompound entryCompound = new NBTTagCompound();
            entryCompound.func_74778_a("uuid", entry.getKey().toString());
            entryCompound.func_74768_a("energy", entry.getValue().intValue());
            list.func_74742_a((NBTBase)entryCompound);
        }
        compound.func_74782_a("coilEntries", (NBTBase)list);
        return compound;
    }

    public boolean func_76188_b() {
        return true;
    }

    public IEnergyStorage getStorageCoil(final UUID owner) {
        return new IEnergyStorage(){

            public int receiveEnergy(int maxReceive, boolean simulate) {
                int currentEnergy = SpectreCoilHandler.this.coilEntries.containsKey(owner) ? SpectreCoilHandler.this.coilEntries.get(owner) : 0;
                int newEnergy = Math.min(1000000, currentEnergy + maxReceive);
                if (!simulate) {
                    SpectreCoilHandler.this.coilEntries.put(owner, newEnergy);
                }
                return newEnergy - currentEnergy;
            }

            public int getMaxEnergyStored() {
                return 1000000;
            }

            public int getEnergyStored() {
                return SpectreCoilHandler.this.coilEntries.containsKey(owner) ? SpectreCoilHandler.this.coilEntries.get(owner) : 0;
            }

            public int extractEnergy(int maxExtract, boolean simulate) {
                int currentEnergy = SpectreCoilHandler.this.coilEntries.containsKey(owner) ? SpectreCoilHandler.this.coilEntries.get(owner) : 0;
                int newEnergy = Math.max(0, currentEnergy - maxExtract);
                if (!simulate) {
                    SpectreCoilHandler.this.coilEntries.put(owner, newEnergy);
                }
                return currentEnergy - newEnergy;
            }

            public boolean canReceive() {
                return true;
            }

            public boolean canExtract() {
                return true;
            }
        };
    }
}

