/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.tileentity;

import cofh.redstoneflux.api.IEnergyReceiver;
import cofh.redstoneflux.impl.EnergyStorage;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tinker_io.helper.OreCrusherRecipe;
import tinker_io.registry.ItemRegistry;
import tinker_io.registry.OreCrusherRecipeRegister;
import tinker_io.tileentity.TileEntityItemCapacity;

public class TileEntityOreCrusher
extends TileEntityItemCapacity
implements ITickable,
IEnergyReceiver {
    public static final String TAG_ENERGY_CONSUME = "energyConsume";
    public static final String TAG_PROGRESS = "progress";
    public static final String TAG_CHANCE = "chance";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_TARGET_ITEMSTACK = "targetItemStack";
    private static final int SLOT_SIZE = 6;
    private static final int PROGRESS_MAX = 300;
    private OreCrusherRecipe recipe = OreCrusherRecipe.EMPTY;
    private ItemStack targetItemStack = ItemStack.field_190927_a;
    private ItemStack lastOre = ItemStack.field_190927_a;
    private EnergyStorage storage = new EnergyStorage(100000, 2000, 0);
    private int energyConsume = 0;
    private int tick = 0;
    private int initSyncCount = 0;
    private int syncPacketCount = 0;
    private int progress = 0;
    private int chance = 0;
    private int speed = 1;

    public TileEntityOreCrusher() {
        super(6);
    }

    @Override
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 2) {
            return this.inventory.extractItem(slot, amount, simulate);
        }
        return super.extractItem(slot, amount, simulate);
    }

    @Override
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (slot == 1) {
            return this.inventory.insertItem(slot, stack, simulate);
        }
        return super.insertItem(slot, stack, simulate);
    }

    public void func_73660_a() {
        if (this.initSyncCount <= 40) {
            this.notifyBlockUpdate();
            ++this.initSyncCount;
        }
        if (this.syncPacketCount <= 5 && this.tick % 4 == 0) {
            this.notifyBlockUpdate();
            ++this.syncPacketCount;
        }
        if (this.tick % 2 == 0) {
            this.calculateChance();
            this.calculateSpeed();
            this.calculateEnergyConsume();
            if (this.isChanged()) {
                ItemStack oreIn = this.inventory.getStackInSlot(1);
                this.recipe = OreCrusherRecipeRegister.find(oreIn);
            }
            this.doCrush();
        }
        this.tick = (this.tick + 1) % 200;
    }

    private void doCrush() {
        if (this.progress == 0) {
            if (!this.recipe.isEmpty() && this.canOutput() && this.storage.getEnergyStored() - this.energyConsume > 0) {
                this.inventory.extractItem(1, 1, false);
                this.targetItemStack = this.recipe.getItemStackOutput().func_77946_l();
                this.progress += this.speed;
                this.func_70296_d();
            }
        } else {
            if (this.storage.getEnergyStored() - this.energyConsume > 0 && !this.targetItemStack.func_190926_b()) {
                this.progress += this.speed;
                this.storage.setEnergyStored(this.storage.getEnergyStored() - this.energyConsume);
                this.syncPacketCount = 0;
            }
            if (this.progress >= 300) {
                this.progress = 0;
                int rate = (int)(Math.random() * 99.0);
                int amount = rate <= this.chance ? 3 : 2;
                ItemStack product = this.targetItemStack;
                product.func_190920_e(amount);
                this.inventory.insertItem(2, product, false);
                this.targetItemStack = ItemStack.field_190927_a;
                this.func_70296_d();
                this.syncPacketCount = 0;
            }
        }
    }

    private void calculateEnergyConsume() {
        this.energyConsume = 90;
        ItemStack speedUpg = this.inventory.getStackInSlot(0);
        if (!speedUpg.func_190926_b()) {
            this.energyConsume += speedUpg.func_190916_E() * 4;
        }
    }

    private void calculateChance() {
        this.chance = 0;
        int bookAmount = 0;
        ItemStack slotFortune1 = this.inventory.getStackInSlot(3);
        ItemStack slotFortune2 = this.inventory.getStackInSlot(4);
        ItemStack slotFortune3 = this.inventory.getStackInSlot(5);
        if (TileEntityOreCrusher.isFortuneEnchantedBook(slotFortune1)) {
            bookAmount += 2;
        }
        if (TileEntityOreCrusher.isFortuneEnchantedBook(slotFortune2)) {
            bookAmount += 2;
        }
        if (!slotFortune3.func_190926_b() && slotFortune3.func_77969_a(new ItemStack((Item)ItemRegistry.upgrade, 1, 6))) {
            bookAmount += 3;
        }
        this.chance = 30 + bookAmount * 10;
    }

    private void calculateSpeed() {
        this.speed = 1;
        ItemStack speedUpg = this.inventory.getStackInSlot(0);
        if (!speedUpg.func_190926_b()) {
            this.speed = speedUpg.func_190916_E() / 2 / 3;
        }
    }

    private boolean isChanged() {
        ItemStack itemStack = this.inventory.getStackInSlot(1);
        boolean changed = !ItemStack.func_179545_c((ItemStack)this.lastOre, (ItemStack)itemStack) || !ItemStack.func_77970_a((ItemStack)this.lastOre, (ItemStack)itemStack);
        this.lastOre = itemStack;
        return changed;
    }

    public static boolean isFortuneEnchantedBook(ItemStack itemstack) {
        if (itemstack != null && !itemstack.func_190926_b()) {
            return TileEntityOreCrusher.getEnchantID(itemstack) == 35;
        }
        return false;
    }

    private static int getEnchantID(ItemStack itemstack) {
        if (itemstack != null && !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemEnchantedBook) {
            NBTTagCompound tag = (NBTTagCompound)ItemEnchantedBook.func_92110_g((ItemStack)itemstack).func_179238_g(0);
            return tag.func_74762_e("id");
        }
        return 0;
    }

    private boolean canOutput() {
        ItemStack productSlot = this.inventory.getStackInSlot(2);
        return (productSlot.func_190926_b() || productSlot.func_77969_a(this.recipe.getItemStackOutput()) && ItemStack.func_77970_a((ItemStack)productSlot, (ItemStack)this.recipe.getItemStackOutput())) && this.inventory.getStackInSlot(2).func_77976_d() - productSlot.func_190916_E() >= 3;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProgress(int pixel) {
        return (int)((float)this.progress / 300.0f * (float)pixel);
    }

    public int getChance() {
        return this.chance;
    }

    public int getEnergyConsume() {
        return this.energyConsume / 2;
    }

    @SideOnly(value=Side.CLIENT)
    public int getEnergyBar(int pixel) {
        return (int)((float)this.storage.getEnergyStored() / (float)this.storage.getMaxEnergyStored() * (float)pixel);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        this.func_70296_d();
        this.syncPacketCount = 0;
        return this.storage.receiveEnergy(Math.min(this.storage.getMaxReceive(), maxReceive), simulate);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.storage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        this.storage.writeToNBT(compound);
        compound.func_74768_a(TAG_CHANCE, this.chance);
        compound.func_74768_a(TAG_ENERGY_CONSUME, this.energyConsume);
        compound.func_74768_a(TAG_PROGRESS, this.progress);
        compound.func_74768_a(TAG_SPEED, this.speed);
        NBTTagCompound nbt = new NBTTagCompound();
        this.targetItemStack.func_77955_b(nbt);
        compound.func_74782_a(TAG_TARGET_ITEMSTACK, (NBTBase)nbt);
        return super.func_189515_b(compound);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        this.storage.readFromNBT(compound);
        this.chance = compound.func_74762_e(TAG_CHANCE);
        this.energyConsume = compound.func_74762_e(TAG_ENERGY_CONSUME);
        this.progress = compound.func_74762_e(TAG_PROGRESS);
        this.speed = compound.func_74762_e(TAG_SPEED);
        this.targetItemStack = new ItemStack(compound.func_74775_l(TAG_TARGET_ITEMSTACK));
        super.func_145839_a(compound);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_189515_b(nbtTag);
        return new SPacketUpdateTileEntity(this.field_174879_c, 1, nbtTag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    private void notifyBlockUpdate() {
        if (this.field_145850_b != null && this.field_174879_c != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public ItemStack getTargetItemStack() {
        return this.targetItemStack;
    }
}

