/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.caching.type;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.luckperms.api.Contexts;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.api.caching.PermissionData;
import me.lucko.luckperms.common.calculators.CalculatorFactory;
import me.lucko.luckperms.common.calculators.PermissionCalculator;
import me.lucko.luckperms.common.calculators.PermissionCalculatorMetadata;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import org.checkerframework.checker.nullness.qual.NonNull;

public class PermissionCache
implements PermissionData {
    private final Contexts contexts;
    private final Map<String, Boolean> permissions;
    private final Map<String, Boolean> permissionsUnmodifiable;
    private final PermissionCalculator calculator;

    public PermissionCache(Contexts contexts, PermissionCalculatorMetadata metadata, CalculatorFactory calculatorFactory) {
        this.contexts = contexts;
        this.permissions = new ConcurrentHashMap<String, Boolean>();
        this.permissionsUnmodifiable = Collections.unmodifiableMap(this.permissions);
        this.calculator = calculatorFactory.build(contexts, metadata);
        this.calculator.setSourcePermissions(this.permissions);
    }

    @Override
    public void invalidateCache() {
        this.calculator.invalidateCache();
    }

    private void setPermissionsInternal(Map<String, Boolean> permissions) {
        this.permissions.clear();
        this.permissions.putAll(permissions);
        this.calculator.setSourcePermissions(this.permissions);
        this.invalidateCache();
    }

    public void setPermissions(Map<String, Boolean> toApply) {
        if (!this.permissions.equals(toApply)) {
            this.setPermissionsInternal(toApply);
        }
    }

    public PermissionCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public @NonNull Map<String, Boolean> getImmutableBacking() {
        return this.permissionsUnmodifiable;
    }

    @Override
    public @NonNull Tristate getPermissionValue(@NonNull String permission) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        return this.calculator.getPermissionValue(permission, CheckOrigin.API);
    }

    public Tristate getPermissionValue(String permission, CheckOrigin origin) {
        if (permission == null) {
            throw new NullPointerException("permission");
        }
        return this.calculator.getPermissionValue(permission, origin);
    }

    @Override
    public @NonNull Contexts getContexts() {
        return this.contexts;
    }
}

