/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.log;

import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.UUID;
import me.lucko.luckperms.common.actionlog.ExtendedLogEntry;
import me.lucko.luckperms.common.actionlog.Log;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.command.utils.ArgumentParser;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.Paginated;
import me.lucko.luckperms.common.utils.Predicates;

public class LogUserHistory
extends SubCommand<Log> {
    private static final int ENTRIES_PER_PAGE = 10;

    public LogUserHistory(LocaleManager locale) {
        super(CommandSpec.LOG_USER_HISTORY.localize(locale), "userhistory", CommandPermission.LOG_USER_HISTORY, Predicates.notInRange(1, 2));
    }

    @Override
    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Log log, List<String> args, String label) {
        UUID uuid = ArgumentParser.parseUserTarget(0, args, plugin, sender);
        if (uuid == null) {
            return CommandResult.INVALID_ARGS;
        }
        Paginated<ExtendedLogEntry> content = new Paginated<ExtendedLogEntry>(log.getUserHistory(uuid));
        int page = ArgumentParser.parseIntOrElse(1, args, Integer.MIN_VALUE);
        if (page != Integer.MIN_VALUE) {
            return LogUserHistory.showLog(page, sender, content);
        }
        return LogUserHistory.showLog(content.getMaxPages(10), sender, content);
    }

    private static CommandResult showLog(int page, Sender sender, Paginated<ExtendedLogEntry> log) {
        int maxPage = log.getMaxPages(10);
        if (maxPage == 0) {
            Message.LOG_NO_ENTRIES.send(sender, new Object[0]);
            return CommandResult.STATE_ERROR;
        }
        if (page < 1 || page > maxPage) {
            Message.LOG_INVALID_PAGE_RANGE.send(sender, maxPage);
            return CommandResult.INVALID_ARGS;
        }
        SortedMap<Integer, ExtendedLogEntry> entries = log.getPage(page, 10);
        String name = entries.values().stream().findAny().get().getActedName();
        Message.LOG_HISTORY_USER_HEADER.send(sender, name, page, maxPage);
        long now = System.currentTimeMillis() / 1000L;
        for (Map.Entry<Integer, ExtendedLogEntry> e : entries.entrySet()) {
            long time = e.getValue().getTimestamp();
            Message.LOG_ENTRY.send(sender, e.getKey(), DurationFormatter.CONCISE_LOW_ACCURACY.format(now - time), e.getValue().getActorFriendlyString(), Character.toString(e.getValue().getType().getCode()), e.getValue().getActedFriendlyString(), e.getValue().getAction());
        }
        return CommandResult.SUCCESS;
    }
}

