/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.commands.migration;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantLock;
import me.lucko.luckperms.common.command.CommandResult;
import me.lucko.luckperms.common.command.abstraction.Command;
import me.lucko.luckperms.common.command.abstraction.MainCommand;
import me.lucko.luckperms.common.command.abstraction.SubCommand;
import me.lucko.luckperms.common.command.access.CommandPermission;
import me.lucko.luckperms.common.locale.LocaleManager;
import me.lucko.luckperms.common.locale.command.CommandSpec;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Predicates;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MigrationMainCommand
extends MainCommand<Object, Object> {
    private static final Map<String, String> PLUGINS = ImmutableBiMap.builder().put((Object)"me.lucko.luckperms.bukkit.migration.MigrationGroupManager", (Object)"org.anjocaido.groupmanager.GroupManager").put((Object)"me.lucko.luckperms.bukkit.migration.MigrationPermissionsEx", (Object)"ru.tehkode.permissions.bukkit.PermissionsEx").put((Object)"me.lucko.luckperms.bukkit.migration.MigrationPowerfulPerms", (Object)"com.github.gustav9797.PowerfulPermsAPI.PowerfulPermsPlugin").put((Object)"me.lucko.luckperms.bukkit.migration.MigrationZPermissions", (Object)"org.tyrannyofheaven.bukkit.zPermissions.ZPermissionsService").put((Object)"me.lucko.luckperms.bukkit.migration.MigrationBPermissions", (Object)"de.bananaco.bpermissions.api.WorldManager").put((Object)"me.lucko.luckperms.bukkit.migration.MigrationPermissionsBukkit", (Object)"com.platymuus.bukkit.permissions.PermissionsPlugin").put((Object)"me.lucko.luckperms.bungee.migration.MigrationBungeePerms", (Object)"net.alpenblock.bungeeperms.BungeePerms").build().inverse();
    private final ReentrantLock lock = new ReentrantLock();
    private List<Command<Object, ?>> commands = null;
    private boolean display = true;

    public MigrationMainCommand(LocaleManager locale) {
        super(CommandSpec.MIGRATION.localize(locale), "Migration", 1, null);
    }

    @Override
    public synchronized @NonNull Optional<List<Command<Object, ?>>> getChildren() {
        if (this.commands == null) {
            this.commands = MigrationMainCommand.getAvailableCommands(this.getSpec().getLocaleManager());
            if (this.commands.isEmpty()) {
                this.display = false;
                this.commands.add(new SubCommand<Object>(CommandSpec.MIGRATION_COMMAND.localize(this.getSpec().getLocaleManager()), "No available plugins to migrate from", CommandPermission.MIGRATION, Predicates.alwaysFalse()){

                    @Override
                    public CommandResult execute(LuckPermsPlugin plugin, Sender sender, Object o, List<String> args, String label) {
                        return CommandResult.SUCCESS;
                    }
                });
            }
        }
        return Optional.of(this.commands);
    }

    @Override
    public boolean isAuthorized(Sender sender) {
        return sender.hasPermission(CommandPermission.MIGRATION);
    }

    @Override
    public boolean shouldDisplay() {
        this.getChildren();
        return this.display;
    }

    private static List<Command<Object, ?>> getAvailableCommands(LocaleManager locale) {
        ArrayList l = new ArrayList();
        for (Map.Entry<String, String> plugin : PLUGINS.entrySet()) {
            try {
                Class.forName(plugin.getKey());
                l.add((SubCommand)Class.forName(plugin.getValue()).getConstructor(LocaleManager.class).newInstance(locale));
            }
            catch (Throwable throwable) {}
        }
        return l;
    }

    @Override
    protected ReentrantLock getLockForTarget(Object target) {
        return this.lock;
    }

    @Override
    protected List<String> getTargets(LuckPermsPlugin plugin) {
        return Collections.emptyList();
    }

    @Override
    protected Object parseTarget(String target, LuckPermsPlugin plugin, Sender sender) {
        return this;
    }

    @Override
    protected Object getTarget(Object target, LuckPermsPlugin plugin, Sender sender) {
        return this;
    }

    @Override
    protected void cleanup(Object o, LuckPermsPlugin plugin) {
    }
}

