/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.implementation.sql.connection.hikari;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.luckperms.common.storage.implementation.sql.connection.ConnectionFactory;
import me.lucko.luckperms.common.storage.misc.StorageCredentials;
import me.lucko.luckperms.lib.hikari.HikariConfig;
import me.lucko.luckperms.lib.hikari.HikariDataSource;

public abstract class HikariConnectionFactory
implements ConnectionFactory {
    protected final StorageCredentials configuration;
    private HikariDataSource hikari;

    public HikariConnectionFactory(StorageCredentials configuration) {
        this.configuration = configuration;
    }

    protected String getDriverClass() {
        return null;
    }

    protected void appendProperties(HikariConfig config, StorageCredentials credentials) {
        for (Map.Entry<String, String> property : credentials.getProperties().entrySet()) {
            config.addDataSourceProperty(property.getKey(), (Object)property.getValue());
        }
    }

    protected void appendConfigurationInfo(HikariConfig config) {
        String address = this.configuration.getAddress();
        String[] addressSplit = address.split(":");
        address = addressSplit[0];
        String port = addressSplit.length > 1 ? addressSplit[1] : "3306";
        config.setDataSourceClassName(this.getDriverClass());
        config.addDataSourceProperty("serverName", (Object)address);
        config.addDataSourceProperty("port", (Object)port);
        config.addDataSourceProperty("databaseName", (Object)this.configuration.getDatabase());
        config.setUsername(this.configuration.getUsername());
        config.setPassword(this.configuration.getPassword());
    }

    @Override
    public void init() {
        HikariConfig config = new HikariConfig();
        config.setPoolName("luckperms-hikari");
        this.appendConfigurationInfo(config);
        this.appendProperties(config, this.configuration);
        config.setMaximumPoolSize(this.configuration.getMaxPoolSize());
        config.setMinimumIdle(this.configuration.getMinIdleConnections());
        config.setMaxLifetime((long)this.configuration.getMaxLifetime());
        config.setConnectionTimeout((long)this.configuration.getConnectionTimeout());
        config.setInitializationFailTimeout(-1L);
        this.hikari = new HikariDataSource(config);
    }

    @Override
    public void shutdown() {
        if (this.hikari != null) {
            this.hikari.close();
        }
    }

    @Override
    public Map<String, String> getMeta() {
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        boolean success = true;
        long start = System.currentTimeMillis();
        try (Connection c = this.hikari.getConnection();
             Statement s = c.createStatement();){
            s.execute("/* ping */ SELECT 1");
        }
        catch (SQLException e) {
            success = false;
        }
        long duration = System.currentTimeMillis() - start;
        if (success) {
            ret.put("Ping", "&a" + duration + "ms");
            ret.put("Connected", "true");
        } else {
            ret.put("Connected", "false");
        }
        return ret;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection connection = this.hikari.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from the pool.");
        }
        return connection;
    }
}

