/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.storage.misc;

import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class DataConstraints {
    public static final int MAX_PERMISSION_LENGTH = 200;
    public static final int MAX_TRACK_NAME_LENGTH = 36;
    public static final int MAX_GROUP_NAME_LENGTH = 36;
    public static final int MAX_PLAYER_USERNAME_LENGTH = 16;
    public static final Pattern PLAYER_USERNAME_INVALID_CHAR_MATCHER = Pattern.compile("[^A-Za-z0-9_]");
    public static final int MAX_SERVER_LENGTH = 36;
    public static final int MAX_WORLD_LENGTH = 36;
    public static final Predicate<String> PERMISSION_TEST = s -> !s.isEmpty() && s.length() <= 200;
    public static final Predicate<String> PLAYER_USERNAME_TEST = s -> !s.isEmpty() && s.length() <= 16 && !PLAYER_USERNAME_INVALID_CHAR_MATCHER.matcher((CharSequence)s).find();
    public static final Predicate<String> PLAYER_USERNAME_TEST_LENIENT = s -> !s.isEmpty() && s.length() <= 16;
    public static final Predicate<String> GROUP_NAME_TEST = s -> !s.isEmpty() && s.length() <= 36 && !s.contains(" ");
    public static final Predicate<String> GROUP_NAME_TEST_ALLOW_SPACE = s -> !s.isEmpty() && s.length() <= 36;
    public static final Predicate<String> TRACK_NAME_TEST = s -> !s.isEmpty() && s.length() <= 36 && !s.contains(" ");
    public static final Predicate<String> TRACK_NAME_TEST_ALLOW_SPACE = s -> !s.isEmpty() && s.length() <= 36;
    public static final Predicate<String> SERVER_NAME_TEST = s -> !s.isEmpty() && s.length() <= 36 && !s.contains(" ");
    public static final Predicate<String> WORLD_NAME_TEST = s -> !s.isEmpty() && s.length() <= 36;

    private DataConstraints() {
    }
}

