/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.verbose;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.lucko.luckperms.api.Tristate;
import me.lucko.luckperms.common.command.utils.MessageUtils;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.DurationFormatter;
import me.lucko.luckperms.common.utils.StackTracePrinter;
import me.lucko.luckperms.common.utils.TextUtils;
import me.lucko.luckperms.common.utils.gson.JArray;
import me.lucko.luckperms.common.utils.gson.JObject;
import me.lucko.luckperms.common.verbose.CheckData;
import me.lucko.luckperms.common.verbose.CheckOrigin;
import me.lucko.luckperms.common.verbose.VerboseFilter;
import me.lucko.luckperms.common.web.StandardPastebin;
import me.lucko.luckperms.lib.text.Component;
import me.lucko.luckperms.lib.text.TextComponent;
import me.lucko.luckperms.lib.text.event.HoverEvent;

public class VerboseListener {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private static final int DATA_TRUNCATION = 10000;
    private static final int STACK_TRUNCATION_CHAT = 15;
    private static final int STACK_TRUNCATION_WEB = 30;
    private static final StackTracePrinter FILTERING_PRINTER = StackTracePrinter.builder().ignoreClassStartingWith("me.lucko.luckperms.").ignoreClassStartingWith("me.lucko.luckperms.lib.caffeine").ignoreClass("java.util.concurrent.CompletableFuture").ignoreClass("java.util.concurrent.ConcurrentHashMap").build();
    private static final StackTracePrinter CHAT_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(15).build();
    private static final StackTracePrinter CHAT_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(15).build();
    private static final StackTracePrinter WEB_FILTERED_PRINTER = FILTERING_PRINTER.toBuilder().truncateLength(30).build();
    private static final StackTracePrinter WEB_UNFILTERED_PRINTER = StackTracePrinter.builder().truncateLength(30).build();
    private final long startTime = System.currentTimeMillis();
    private final Sender notifiedSender;
    private final VerboseFilter filter;
    private final boolean notify;
    private final AtomicInteger counter = new AtomicInteger(0);
    private final AtomicInteger matchedCounter = new AtomicInteger(0);
    private final List<CheckData> results = new ArrayList<CheckData>(1000);

    public VerboseListener(Sender notifiedSender, VerboseFilter filter, boolean notify) {
        this.notifiedSender = notifiedSender;
        this.filter = filter;
        this.notify = notify;
    }

    public void acceptData(CheckData data) {
        this.counter.incrementAndGet();
        if (!this.filter.evaluate(data)) {
            return;
        }
        this.matchedCounter.incrementAndGet();
        if (this.results.size() < 10000) {
            this.results.add(data);
        }
        if (this.notify) {
            this.sendNotification(data);
        }
    }

    private void sendNotification(CheckData data) {
        if (this.notifiedSender.isConsole()) {
            Message.VERBOSE_LOG.send(this.notifiedSender, data.getCheckTarget(), data.getPermission(), VerboseListener.getTristateColor(data.getResult()), data.getResult().name().toLowerCase());
            return;
        }
        TextComponent textComponent = Message.VERBOSE_LOG.asComponent(this.notifiedSender.getPlugin().getLocaleManager(), data.getCheckTarget(), data.getPermission(), VerboseListener.getTristateColor(data.getResult()), data.getResult().name().toLowerCase());
        ArrayList<String> hover = new ArrayList<String>();
        hover.add("&bOrigin: &2" + data.getCheckOrigin().name());
        hover.add("&bContext: &r" + MessageUtils.contextSetToString(this.notifiedSender.getPlugin().getLocaleManager(), data.getCheckContext()));
        hover.add("&bTrace: &r");
        Consumer<StackTraceElement> printer = StackTracePrinter.elementToString(str -> hover.add("&7" + str));
        int overflow = data.getCheckOrigin() == CheckOrigin.API || data.getCheckOrigin() == CheckOrigin.INTERNAL ? CHAT_UNFILTERED_PRINTER.process(data.getCheckTrace(), printer) : CHAT_FILTERED_PRINTER.process(data.getCheckTrace(), printer);
        if (overflow != 0) {
            hover.add("&f... and " + overflow + " more");
        }
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Component)TextUtils.fromLegacy(TextUtils.joinNewline(hover.stream()), '&'));
        TextComponent text = ((TextComponent.Builder)textComponent.toBuilder().applyDeep(comp -> comp.hoverEvent(hoverEvent))).build();
        this.notifiedSender.sendMessage((Component)text);
    }

    public String uploadPasteData() {
        long now = System.currentTimeMillis();
        String startDate = DATE_FORMAT.format(new Date(this.startTime));
        String endDate = DATE_FORMAT.format(new Date(now));
        long secondsTaken = (now - this.startTime) / 1000L;
        String duration = DurationFormatter.CONCISE.format(secondsTaken);
        String filter = this.filter.isBlank() ? "any" : this.filter.toString();
        boolean truncated = this.matchedCounter.get() > this.results.size();
        JObject metadata = new JObject().add("startTime", startDate).add("endTime", endDate).add("duration", duration).add("count", new JObject().add("matched", this.matchedCounter.get()).add("total", this.counter.get())).add("uploader", new JObject().add("name", this.notifiedSender.getNameWithLocation()).add("uuid", this.notifiedSender.getUuid().toString())).add("filter", filter).add("truncated", truncated);
        JArray data = new JArray();
        for (CheckData c : this.results) {
            if (c.getCheckOrigin() == CheckOrigin.API || c.getCheckOrigin() == CheckOrigin.INTERNAL) {
                data.add((JsonElement)c.toJson(WEB_UNFILTERED_PRINTER));
                continue;
            }
            data.add((JsonElement)c.toJson(WEB_FILTERED_PRINTER));
        }
        this.results.clear();
        JsonObject payload = new JObject().add("metadata", metadata).add("data", data).toJson();
        return StandardPastebin.BYTEBIN.postJson((JsonElement)payload, true).id();
    }

    private static String getTristateColor(Tristate tristate) {
        switch (tristate) {
            case TRUE: {
                return "&2";
            }
            case FALSE: {
                return "&c";
            }
        }
        return "&7";
    }

    public Sender getNotifiedSender() {
        return this.notifiedSender;
    }
}

