/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.web;

import java.io.IOException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import me.lucko.luckperms.lib.okhttp3.Interceptor;
import me.lucko.luckperms.lib.okhttp3.OkHttpClient;
import me.lucko.luckperms.lib.okhttp3.Request;
import me.lucko.luckperms.lib.okhttp3.Response;
import me.lucko.luckperms.lib.okhttp3.ResponseBody;

public class HttpClient {
    private static OkHttpClient client = null;

    private static synchronized OkHttpClient getClient() {
        if (client == null) {
            client = new OkHttpClient.Builder().proxySelector((ProxySelector)new NullSafeProxySelector()).addInterceptor((Interceptor)new LuckPermsUserAgentInterceptor()).build();
        }
        return client;
    }

    public static Response makeCall(Request request) throws IOException {
        Response response = HttpClient.getClient().newCall(request).execute();
        if (!response.isSuccessful()) {
            throw HttpClient.exceptionForUnsuccessfulResponse(response);
        }
        return response;
    }

    private static RuntimeException exceptionForUnsuccessfulResponse(Response response) {
        String msg = "";
        try (ResponseBody responseBody = response.body();){
            if (responseBody != null) {
                msg = responseBody.string();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new RuntimeException("Got response: " + response.code() + " - " + response.message() + " - " + msg);
    }

    private HttpClient() {
    }

    private static final class NullSafeProxySelector
    extends ProxySelector {
        private static final List<Proxy> DIRECT = Collections.singletonList(Proxy.NO_PROXY);

        private NullSafeProxySelector() {
        }

        @Override
        public List<Proxy> select(URI uri) {
            ProxySelector def = ProxySelector.getDefault();
            if (def == null) {
                return DIRECT;
            }
            return def.select(uri);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            ProxySelector def = ProxySelector.getDefault();
            if (def != null) {
                def.connectFailed(uri, sa, ioe);
            }
        }
    }

    private static final class LuckPermsUserAgentInterceptor
    implements Interceptor {
        private LuckPermsUserAgentInterceptor() {
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request orig = chain.request();
            Request modified = orig.newBuilder().header("User-Agent", "luckperms").build();
            return chain.proceed(modified);
        }
    }
}

