/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.common.web;

import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import me.lucko.luckperms.api.context.ImmutableContextSet;
import me.lucko.luckperms.common.contexts.ContextSetJsonSerializer;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.Group;
import me.lucko.luckperms.common.model.PermissionHolder;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.node.model.NodeDataContainer;
import me.lucko.luckperms.common.plugin.LuckPermsPlugin;
import me.lucko.luckperms.common.sender.Sender;
import me.lucko.luckperms.common.utils.Uuids;
import me.lucko.luckperms.common.utils.gson.JArray;
import me.lucko.luckperms.common.utils.gson.JObject;

public final class WebEditor {
    private static final String USER_ID_PATTERN = "user/";
    private static final String GROUP_ID_PATTERN = "group/";

    private static JObject writeData(PermissionHolder holder) {
        return new JObject().add("who", new JObject().add("id", WebEditor.getHolderIdentifier(holder)).add("friendly", holder.getPlainDisplayName()).consume(obj -> {
            if (holder.getType().isUser()) {
                obj.add("uuid", ((User)holder).getUuid().toString());
            }
        })).add("nodes", (JsonElement)WebEditor.serializePermissions(holder.enduringData().immutable().values().stream().map(NodeDataContainer::fromNode)));
    }

    public static JsonObject formPayload(List<PermissionHolder> holders, Sender sender, String cmdLabel, LuckPermsPlugin plugin) {
        Preconditions.checkArgument((!holders.isEmpty() ? 1 : 0) != 0, (Object)"holders is empty");
        return new JObject().add("metadata", new JObject().add("cmdAlias", cmdLabel).add("uploader", new JObject().add("name", sender.getNameWithLocation()).add("uuid", sender.getUuid().toString())).add("time", System.currentTimeMillis())).add("sessions", new JArray().consume(arr -> {
            for (PermissionHolder holder : holders) {
                arr.add(WebEditor.writeData(holder));
            }
        })).add("knownPermissions", new JArray().consume(arr -> {
            for (String perm : plugin.getPermissionRegistry().rootAsList()) {
                arr.add(perm);
            }
        })).toJson();
    }

    private static String getHolderIdentifier(PermissionHolder holder) {
        if (holder.getType().isUser()) {
            User user = (User)holder;
            return USER_ID_PATTERN + user.getUuid().toString();
        }
        Group group = (Group)holder;
        return GROUP_ID_PATTERN + group.getName();
    }

    public static PermissionHolder getHolderFromIdentifier(LuckPermsPlugin plugin, Sender sender, String who) {
        if (who.startsWith(GROUP_ID_PATTERN)) {
            String group = who.substring(GROUP_ID_PATTERN.length());
            Group holder = plugin.getStorage().loadGroup(group).join().orElse(null);
            if (holder == null) {
                Message.APPLY_EDITS_TARGET_GROUP_NOT_EXISTS.send(sender, group);
            }
            return holder;
        }
        if (who.startsWith(USER_ID_PATTERN)) {
            String user = who.substring(USER_ID_PATTERN.length());
            UUID uuid = Uuids.parse(user);
            if (uuid == null) {
                Message.APPLY_EDITS_TARGET_USER_NOT_UUID.send(sender, user);
                return null;
            }
            User holder = plugin.getStorage().loadUser(uuid, null).join();
            if (holder == null) {
                Message.APPLY_EDITS_TARGET_USER_UNABLE_TO_LOAD.send(sender, uuid.toString());
            }
            return holder;
        }
        Message.APPLY_EDITS_TARGET_UNKNOWN.send(sender, who);
        return null;
    }

    /*
     * Exception decompiling
     */
    public static JsonObject getDataFromGist(String id) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 7 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static JsonArray serializePermissions(Stream<NodeDataContainer> nodes) {
        JsonArray arr = new JsonArray();
        nodes.forEach(node -> {
            JsonObject attributes = new JsonObject();
            attributes.addProperty("permission", node.getPermission());
            attributes.addProperty("value", Boolean.valueOf(node.getValue()));
            if (!node.getServer().equals("global")) {
                attributes.addProperty("server", node.getServer());
            }
            if (!node.getWorld().equals("global")) {
                attributes.addProperty("world", node.getWorld());
            }
            if (node.getExpiry() != 0L) {
                attributes.addProperty("expiry", (Number)node.getExpiry());
            }
            if (!node.getContexts().isEmpty()) {
                attributes.add("context", (JsonElement)ContextSetJsonSerializer.serializeContextSet(node.getContexts()));
            }
            arr.add((JsonElement)attributes);
        });
        return arr;
    }

    public static Set<NodeDataContainer> deserializePermissions(JsonArray permissionsSection) {
        HashSet<NodeDataContainer> nodes = new HashSet<NodeDataContainer>();
        for (JsonElement ent : permissionsSection) {
            if (!ent.isJsonObject()) continue;
            JsonObject data = ent.getAsJsonObject();
            String permission = data.get("permission").getAsString();
            boolean value = true;
            String server = "global";
            String world = "global";
            long expiry = 0L;
            ImmutableContextSet context = ImmutableContextSet.empty();
            if (data.has("value")) {
                value = data.get("value").getAsBoolean();
            }
            if (data.has("server")) {
                server = data.get("server").getAsString();
            }
            if (data.has("world")) {
                world = data.get("world").getAsString();
            }
            if (data.has("expiry")) {
                expiry = data.get("expiry").getAsLong();
            }
            if (data.has("context") && data.get("context").isJsonObject()) {
                JsonObject contexts = data.get("context").getAsJsonObject();
                context = ContextSetJsonSerializer.deserializeContextSet((JsonElement)contexts).makeImmutable();
            }
            nodes.add(NodeDataContainer.of(permission, value, server, world, expiry, context));
        }
        return nodes;
    }

    private WebEditor() {
    }
}

