/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.sponge.listeners;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.lucko.luckperms.common.config.ConfigKeys;
import me.lucko.luckperms.common.locale.message.Message;
import me.lucko.luckperms.common.model.User;
import me.lucko.luckperms.common.plugin.util.AbstractConnectionListener;
import me.lucko.luckperms.sponge.LPSpongePlugin;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.profile.GameProfile;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.Tristate;

public class SpongeConnectionListener
extends AbstractConnectionListener {
    private final LPSpongePlugin plugin;
    private final Set<UUID> deniedAsyncLogin = Collections.synchronizedSet(new HashSet());
    private final Set<UUID> deniedLogin = Collections.synchronizedSet(new HashSet());

    public SpongeConnectionListener(LPSpongePlugin plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @Listener(order=Order.EARLY)
    @IsCancelled(value=Tristate.UNDEFINED)
    public void onClientAuth(ClientConnectionEvent.Auth e) {
        GameProfile profile = e.getProfile();
        String username = (String)profile.getName().orElseThrow(() -> new RuntimeException("No username present for user " + profile.getUniqueId()));
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing auth event for " + profile.getUniqueId() + " - " + profile.getName());
        }
        try {
            User user = this.loadUser(profile.getUniqueId(), username);
            this.plugin.getEventFactory().handleUserLoginProcess(profile.getUniqueId(), username, user);
            this.recordConnection(profile.getUniqueId());
        }
        catch (Exception ex) {
            this.plugin.getLogger().severe("Exception occurred whilst loading data for " + profile.getUniqueId() + " - " + profile.getName());
            ex.printStackTrace();
            this.deniedAsyncLogin.add(profile.getUniqueId());
            e.setCancelled(true);
            e.setMessageCancelled(false);
            e.setMessage((TextRepresentable)TextSerializers.LEGACY_FORMATTING_CODE.deserialize(Message.LOADING_DATABASE_ERROR.asString(this.plugin.getLocaleManager(), new Object[0])));
        }
    }

    @Listener(order=Order.LAST)
    @IsCancelled(value=Tristate.UNDEFINED)
    public void onClientAuthMonitor(ClientConnectionEvent.Auth e) {
        if (this.deniedAsyncLogin.remove(e.getProfile().getUniqueId()) && e.isCancelled()) {
            this.plugin.getLogger().severe("Player connection was re-allowed for " + e.getProfile().getUniqueId());
            e.setCancelled(true);
        }
    }

    @Listener(order=Order.FIRST)
    @IsCancelled(value=Tristate.UNDEFINED)
    public void onClientLogin(ClientConnectionEvent.Login e) {
        Object user;
        GameProfile profile = e.getProfile();
        if (this.plugin.getConfiguration().get(ConfigKeys.DEBUG_LOGINS).booleanValue()) {
            this.plugin.getLogger().info("Processing login event for " + profile.getUniqueId() + " - " + profile.getName());
        }
        if ((user = this.plugin.getUserManager().getIfLoaded(profile.getUniqueId())) == null) {
            this.deniedLogin.add(profile.getUniqueId());
            if (!this.getUniqueConnections().contains(profile.getUniqueId())) {
                this.plugin.getLogger().warn("User " + profile.getUniqueId() + " - " + profile.getName() + " doesn't have data pre-loaded, they have never been processed during pre-login in this session. - denying login.");
            } else {
                this.plugin.getLogger().warn("User " + profile.getUniqueId() + " - " + profile.getName() + " doesn't currently have data pre-loaded, but they have been processed before in this session. - denying login.");
            }
            e.setCancelled(true);
            e.setMessageCancelled(false);
            e.setMessage((TextRepresentable)TextSerializers.LEGACY_FORMATTING_CODE.deserialize(Message.LOADING_STATE_ERROR.asString(this.plugin.getLocaleManager(), new Object[0])));
        }
    }

    @Listener(order=Order.LAST)
    @IsCancelled(value=Tristate.UNDEFINED)
    public void onClientLoginMonitor(ClientConnectionEvent.Login e) {
        if (this.deniedLogin.remove(e.getProfile().getUniqueId()) && !e.isCancelled()) {
            this.plugin.getLogger().severe("Player connection was re-allowed for " + e.getProfile().getUniqueId());
            e.setCancelled(true);
        }
    }

    @Listener(order=Order.POST)
    public void onClientLeave(ClientConnectionEvent.Disconnect e) {
        this.handleDisconnect(e.getTargetEntity().getUniqueId());
    }
}

