/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.api.fluids;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import sonar.core.api.ISonarStack;
import sonar.core.helpers.NBTHelper;

public class StoredFluidStack
implements ISonarStack<StoredFluidStack> {
    public FluidStack fluid;
    public long stored;
    public long capacity;

    public StoredFluidStack() {
    }

    public StoredFluidStack(FluidStack stack) {
        this.fluid = stack.copy();
        this.stored = stack.amount;
        this.capacity = stack.amount;
    }

    public StoredFluidStack(FluidStack stack, long capacity) {
        this.fluid = stack.copy();
        this.stored = stack.amount;
        this.capacity = capacity;
    }

    public StoredFluidStack(FluidStack stack, long stored, long capacity) {
        this.fluid = stack.copy();
        this.stored = stored;
        this.capacity = capacity;
    }

    @Override
    public void add(StoredFluidStack stack) {
        if (this.equalStack(stack.fluid)) {
            this.stored += stack.stored;
            this.capacity += stack.capacity;
        }
    }

    @Override
    public void remove(StoredFluidStack stack) {
        if (this.equalStack(stack.fluid)) {
            this.stored -= stack.stored;
            this.capacity -= stack.capacity;
        }
    }

    @Override
    public StoredFluidStack copy() {
        return new StoredFluidStack(this.fluid, this.stored, this.capacity);
    }

    public StoredFluidStack setStackSize(StoredFluidStack stack) {
        this.stored = stack == null ? 0L : stack.stored;
        return this;
    }

    @Override
    public StoredFluidStack setStackSize(long size) {
        this.stored = size;
        return this;
    }

    public static boolean isEqualStack(FluidStack main, FluidStack stack) {
        return main != null && stack != null && main.isFluidEqual(stack);
    }

    public boolean equalStack(FluidStack stack) {
        return StoredFluidStack.isEqualStack(this.fluid, stack);
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt);
        this.stored = nbt.func_74763_f("stored");
        this.capacity = nbt.func_74763_f("capacity");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.fluid.writeToNBT(nbt);
        nbt.func_74772_a("stored", this.stored);
        nbt.func_74772_a("capacity", this.capacity);
        return nbt;
    }

    public static StoredFluidStack readFromBuf(ByteBuf buf) {
        return new StoredFluidStack(NBTHelper.readFluidFromBuf(buf), buf.readLong(), buf.readLong());
    }

    public static void writeToBuf(ByteBuf buf, StoredFluidStack storedStack) {
        NBTHelper.writeFluidToBuf(storedStack.fluid, buf);
        buf.writeLong(storedStack.stored);
        buf.writeLong(storedStack.capacity);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StoredFluidStack) {
            StoredFluidStack target = (StoredFluidStack)obj;
            return this.equalStack(target.fluid) && this.stored == target.stored && this.capacity == target.capacity;
        }
        return false;
    }

    public FluidStack getFullStack() {
        FluidStack stack = this.fluid.copy();
        stack.amount = (int)Math.min(this.stored, Integer.MAX_VALUE);
        return stack;
    }

    @Override
    public ISonarStack.StorageTypes getStorageType() {
        return ISonarStack.StorageTypes.FLUIDS;
    }

    @Override
    public long getStackSize() {
        return this.stored;
    }

    public String toString() {
        if (this.fluid != null) {
            return this.stored + " mb x " + this.fluid.getLocalizedName();
        }
        return super.toString() + " : NULL";
    }
}

