/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.util;

import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import thaumicenergistics.util.ForgeUtil;

public class ItemHandlerUtil {
    @Nonnull
    public static ItemStack insert(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.insert(handler, stack, false);
    }

    @Nonnull
    public static ItemStack insertSim(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.insert(handler, stack, true);
    }

    @Nonnull
    public static ItemStack extract(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.extract(handler, stack, false);
    }

    @Nonnull
    public static ItemStack extractSim(IItemHandler handler, ItemStack stack) {
        return ItemHandlerUtil.extract(handler, stack, true);
    }

    @Nonnull
    public static ItemStack insert(IItemHandler handler, ItemStack original, boolean simulate) {
        int slot;
        if (original == null || original.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack copy = original.func_77946_l();
        for (slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack existing = handler.getStackInSlot(slot);
            if (ForgeUtil.areItemStacksEqual(existing, copy)) {
                copy = handler.insertItem(slot, copy, simulate);
            }
            if (!copy.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        for (slot = 0; slot < handler.getSlots(); ++slot) {
            if (!(copy = handler.insertItem(slot, copy, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return copy;
    }

    @Nonnull
    public static ItemStack extract(IItemHandler handler, ItemStack original, boolean simulate) {
        if (original == null || original.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack extracted = null;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            if (extracted != null && original.func_190916_E() == extracted.func_190916_E()) {
                return extracted;
            }
            ItemStack inSlot = handler.getStackInSlot(slot);
            if (inSlot.func_190926_b() || !ForgeUtil.areItemStacksEqual(original, inSlot)) continue;
            if (extracted == null) {
                extracted = handler.extractItem(slot, original.func_190916_E(), simulate);
                continue;
            }
            ItemStack s = handler.extractItem(slot, original.func_190916_E() - extracted.func_190916_E(), simulate);
            if (s.func_190926_b() || !ForgeUtil.areItemStacksEqual(original, s)) continue;
            extracted.func_190917_f(s.func_190916_E());
        }
        return extracted == null || extracted.func_190926_b() ? ItemStack.field_190927_a : extracted;
    }

    public static void getInventoryAsList(IItemHandler handler, List<ItemStack> list) {
        if (handler == null) {
            return;
        }
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
    }
}

