/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wft.items;

import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.util.IConfigManager;
import appeng.core.localization.GuiText;
import appeng.core.localization.PlayerMessages;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.client.IBaubleItem;
import p455w0rd.ae2wtlib.api.client.ReadableNumberConverter;
import p455w0rd.ae2wtlib.api.item.ItemWT;
import p455w0rd.wft.api.IWirelessFluidTerminalItem;
import p455w0rd.wft.api.WFTApi;
import p455w0rd.wft.util.WFTUtils;

public class ItemWFT
extends ItemWT
implements IWirelessFluidTerminalItem,
IBaubleItem {
    public ItemWFT() {
        this(new ResourceLocation("wft", "wft"));
    }

    public ItemWFT(ResourceLocation registryName) {
        super(registryName);
    }

    public IConfigManager getConfigManager(ItemStack target) {
        IConfigManager out = super.getConfigManager(target);
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData((ItemStack)target).func_74737_b());
        return out;
    }

    public void openGui(EntityPlayer player, boolean isBauble, int playerSlot) {
        WFTApi.instance().openWFTGui(player, isBauble, playerSlot);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (world.field_72995_K && hand == EnumHand.MAIN_HAND && !item.func_190926_b() && this.getAECurrentPower(item) > 0.0) {
            this.openGui(player, false, player.field_71071_by.field_70461_c);
        } else if (!world.field_72995_K) {
            if (this.getAECurrentPower(item) <= 0.0) {
                player.func_145747_a(PlayerMessages.DeviceNotPowered.get());
                return new ActionResult(EnumActionResult.FAIL, (Object)item);
            }
            if (!WFTApi.instance().isTerminalLinked(item)) {
                player.func_145747_a(PlayerMessages.DeviceNotLinked.get());
                return new ActionResult(EnumActionResult.FAIL, (Object)item);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
    }

    @SideOnly(value=Side.CLIENT)
    public void addCheckedInformation(ItemStack is, World world, List<String> list, ITooltipFlag advancedTooltips) {
        if (this.getPlayer() == null || WTApi.instance().getGUIObject(is, this.getPlayer()) == null) {
            return;
        }
        String encKey = this.getEncryptionKey(is);
        String pctTxtColor = TextFormatting.WHITE + "";
        double aeCurrPower = this.getAECurrentPower(is);
        double aeCurrPowerPct = (double)((int)Math.floor(aeCurrPower / this.getAEMaxPower(is) * 10000.0)) / 100.0;
        if ((int)aeCurrPowerPct >= 75) {
            pctTxtColor = TextFormatting.GREEN + "";
        }
        if ((int)aeCurrPowerPct <= 5) {
            pctTxtColor = TextFormatting.RED + "";
        }
        list.add(TextFormatting.AQUA + "==============================");
        if (WTApi.instance().isWTCreative(is)) {
            list.add(GuiText.StoredEnergy.getLocal() + ": " + TextFormatting.GREEN + "" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinite(), (Object[])new Object[0]));
        } else {
            list.add(GuiText.StoredEnergy.getLocal() + ": " + pctTxtColor + (int)aeCurrPower + " AE - " + aeCurrPowerPct + "%");
        }
        String linked = TextFormatting.RED + GuiText.Unlinked.getLocal();
        if (encKey != null && !encKey.isEmpty()) {
            linked = TextFormatting.BLUE + GuiText.Linked.getLocal();
        }
        list.add("Link Status: " + linked);
        if (WTApi.instance().getConfig().isInfinityBoosterCardEnabled()) {
            if (WTApi.instance().getConfig().isOldInfinityMechanicEnabled()) {
                list.add(I18n.func_135052_a((String)WTApi.instance().getConstants().boosterCardUnlocalizedName(), (Object[])new Object[0]) + ": " + (this.hasInfiniteRange(is) ? TextFormatting.GREEN + "" : TextFormatting.RED + "" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().not(), (Object[])new Object[0])) + " " + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().installed(), (Object[])new Object[0]));
            } else {
                boolean outsideOfWAPRange;
                int infinityEnergyAmount = WTApi.instance().getInfinityEnergy(is);
                String amountColor = infinityEnergyAmount < WTApi.instance().getConfig().getLowInfinityEnergyWarningAmount() ? TextFormatting.RED.toString() : TextFormatting.GREEN.toString();
                String reasonString = "";
                if (infinityEnergyAmount <= 0) {
                    reasonString = "(" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().outOf(), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinityEnergy(), (Object[])new Object[0]) + ")";
                }
                boolean bl = outsideOfWAPRange = !WTApi.instance().isInRange(is);
                if (!outsideOfWAPRange) {
                    reasonString = I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().inWapRange(), (Object[])new Object[0]);
                }
                String activeString = infinityEnergyAmount > 0 && outsideOfWAPRange ? TextFormatting.GREEN + "" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().active(), (Object[])new Object[0]) : TextFormatting.GRAY + "" + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().inactive(), (Object[])new Object[0]) + " " + reasonString;
                list.add(I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infiniteRange(), (Object[])new Object[0]) + ": " + activeString);
                String infinityEnergyString = WFTUtils.isWFTCreative(is) ? I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinite(), (Object[])new Object[0]) : (ItemWFT.isShiftKeyDown() ? "" + infinityEnergyAmount + "" + TextFormatting.GRAY + " " + I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().units(), (Object[])new Object[0]) : ReadableNumberConverter.INSTANCE.toSlimReadableForm((long)infinityEnergyAmount));
                list.add(I18n.func_135052_a((String)WTApi.instance().getConstants().getTooltips().infinityEnergy(), (Object[])new Object[0]) + ": " + amountColor + "" + infinityEnergyString);
            }
        }
    }

    public ResourceLocation getMenuIcon() {
        return new ResourceLocation("wft", "textures/items/wft.png");
    }

    public int getColor() {
        return -11227137;
    }
}

