/*
 * Decompiled with CFR 0.152.
 */
package asmodeuscore.core.utils;

import asmodeuscore.core.utils.JsonUtils$ACAttributePlayer$2;
import asmodeuscore.core.utils.Utils$Utils;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.SpaceStationWorldData;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class Utils {
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;
    private static volatile transient Object[] \ub980;

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBlockTexture(Block block) {
        return Utils.getBlockTexture(block, "");
    }

    public static TextureAtlasSprite getBlockTexture(Block block, String addpath) {
        if (block == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = block.getRegistryName();
        TextureAtlasSprite sprite = texMap.func_110572_b((String)Utils.\u9d5c("\u8254", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)new StringBuilder(), (String)spriteLocation.func_110624_b()), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub109\ud729\u0abf\u2637\u932c\u18eb\ub676\ub47c")), (String)spriteLocation.func_110623_a()), (String)addpath)));
        return sprite != null ? sprite : missingIcon;
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static void drawFluid(int xPos, int yPos, int scale, FluidStack fluid) {
        int renderRemaining;
        if (fluid == null) {
            return;
        }
        int guiWidth = 0;
        int guiHeight = 0;
        int start = 0;
        do {
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            Utils.drawTexturedModalRect(guiWidth + xPos, guiHeight + yPos + 58 - renderRemaining - start, Utils.getFluidTexture(fluid.getFluid(), FluidType.STILL), 16, 16 - (16 - renderRemaining));
            start += 16;
        } while (renderRemaining != 0 && scale != 0);
    }

    public static void drawTexturedModalRect(int xCoord, int yCoord, TextureAtlasSprite textureSprite, int widthIn, int heightIn) {
        double zLevel = 0.0;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + heightIn), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94210_h()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + widthIn), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94212_f(), (double)textureSprite.func_94206_g()).func_181675_d();
        bufferbuilder.func_181662_b((double)(xCoord + 0), (double)(yCoord + 0), zLevel).func_187315_a((double)textureSprite.func_94209_e(), (double)textureSprite.func_94206_g()).func_181675_d();
        tessellator.func_78381_a();
    }

    public static int getIntColor(int r, int g, int b, int a) {
        int A = a * 256 * 256 * 256;
        int R = r * 256 * 256;
        int G = g * 256;
        int B = b;
        int color = A + R + G + B;
        return color - 0x1000000;
    }

    public static float calculateCelestialAngle(long worldtime, float ticks, float daylenght) {
        int j = (int)((float)worldtime % daylenght);
        float f1 = ((float)j + ticks) / daylenght - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 1.0f - (float)((Utils.\u06c9("\u0c19", (double)((double)f1 * Math.PI)) + 1.0) / 2.0);
        f1 = f2 + (f1 - f2) / 3.0f;
        return f1;
    }

    public static List<Integer> getPossibleDimensionsForSpaceshipTier(int tier, EntityPlayerMP playerBase) {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        if (!ConfigManagerCore.disableRocketsToOverworld) {
            temp.add((Integer)Utils.\ud03f("\ub037", (int)ConfigManagerCore.idDimensionOverworld));
        }
        for (Integer element : WorldUtil.registeredPlanets) {
            WorldProvider provider;
            if (Utils.\u8c7f("\ua208", (Integer)element) == ConfigManagerCore.idDimensionOverworld || (provider = WorldUtil.getProviderForDimensionServer((int)Utils.\u8c7f("\ua208", (Integer)element))) == null) continue;
            if (provider instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)provider).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        Iterator iterator = Utils.\u6c41("\u0e87", (HashMap)WorldUtil.registeredSpaceStations).iterator();
        while (iterator.hasNext()) {
            WorldProvider homeWorld;
            Integer element;
            element = (Integer)iterator.next();
            SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\u8c7f("\ua208", (Integer)element), null);
            if (ConfigManagerCore.spaceStationsRequirePermission && !data.getAllowedAll() && Utils.\u1ea4("\uc635", (ArrayList)data.getAllowedPlayers(), (Object)PlayerUtil.getName((EntityPlayer)playerBase)) == false && !ArrayUtils.contains((Object[])playerBase.field_71133_b.func_184103_al().func_152606_n(), (Object)playerBase.func_70005_c_())) continue;
            if (playerBase != null) {
                SpaceStationWorldData dataCurrent;
                int currentWorld = playerBase.field_71093_bK;
                if (currentWorld == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
                if (playerBase.field_70170_p.field_73011_w instanceof IOrbitDimension && (dataCurrent = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)playerBase.field_71093_bK, null)).getHomePlanet() == data.getHomePlanet()) {
                    temp.add(element);
                    continue;
                }
            }
            if ((homeWorld = WorldUtil.getProviderForDimensionServer((int)data.getHomePlanet())) == null) continue;
            if (homeWorld instanceof IGalacticraftWorldProvider) {
                if (!((IGalacticraftWorldProvider)homeWorld).canSpaceshipTierPass(tier)) continue;
                temp.add(element);
                continue;
            }
            temp.add(element);
        }
        return temp;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensions(int tier, EntityPlayerMP playerBase) {
        List<Integer> ids = Utils.getPossibleDimensionsForSpaceshipTier(tier, playerBase);
        HashMap<String, Integer> map = new HashMap<String, Integer>(ids.size(), 1.0f);
        for (Integer id : ids) {
            CelestialBody celestialBody = WorldUtil.getReachableCelestialBodiesForDimensionID((int)Utils.\u8c7f("\ua208", (Integer)id));
            if (Utils.\u8c7f("\ua208", (Integer)id) > 0 && celestialBody == null) {
                celestialBody = GalacticraftCore.satelliteSpaceStation;
                if (playerBase == null) continue;
                SpaceStationWorldData data = SpaceStationWorldData.getStationData((World)playerBase.field_70170_p, (int)Utils.\u8c7f("\ua208", (Integer)id), null);
                Utils.\u9866("\ua84a", map, (Object)Utils.\u9d5c("\u8254", (StringBuilder)Utils.\u9386("\u71ec", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u37d0("\u026e", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)new StringBuilder(), (String)celestialBody.getName()), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub117")), (String)data.getOwner()), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub117")), (String)data.getSpaceStationName()), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub117")), (Object)id), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub117")), (int)data.getHomePlanet())), (Object)id);
                continue;
            }
            if (celestialBody == GalacticraftCore.planetOverworld) {
                Utils.\u9866("\ua84a", map, (Object)celestialBody.getName(), (Object)id);
                continue;
            }
            WorldProvider provider = WorldUtil.getProviderForDimensionServer((int)Utils.\u8c7f("\ua208", (Integer)id));
            if (celestialBody == null || provider == null || (!(provider instanceof IGalacticraftWorldProvider) || provider instanceof IOrbitDimension) && GCCoreUtil.getDimensionID((WorldProvider)provider) != 0) continue;
            Utils.\u9866("\ua84a", map, (Object)celestialBody.getName(), (Object)Utils.\ud03f("\ub037", (int)GCCoreUtil.getDimensionID((WorldProvider)provider)));
        }
        ArrayList cBodyList = new ArrayList();
        Utils.\u1887("\u6b18", cBodyList, GalaxyRegistry.getRegisteredPlanets().values());
        Utils.\u1887("\u6b18", cBodyList, GalaxyRegistry.getRegisteredMoons().values());
        Object object = Utils.\ua3c9("\u3c93", cBodyList);
        while (object.hasNext()) {
            CelestialBody body = (CelestialBody)object.next();
            if (body.getReachable()) continue;
            Utils.\u9866("\ua84a", map, (Object)Utils.\u9d5c("\u8254", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)Utils.\u8ddd("\u8e52", (StringBuilder)new StringBuilder(), (String)body.getLocalizedName()), (String)JsonUtils$ACAttributePlayer$2.\ua76d("\ub119"))), (Object)Utils.\ud03f("\ub037", (int)body.getDimensionID()));
        }
        WorldUtil.celestialMapCache.put(playerBase, map);
        return map;
    }

    public static HashMap<String, Integer> getArrayOfPossibleDimensionsAgain(int tier, EntityPlayerMP playerBase) {
        HashMap map = (HashMap)WorldUtil.celestialMapCache.get(playerBase);
        if (map != null) {
            return map;
        }
        return Utils.getArrayOfPossibleDimensions(tier, playerBase);
    }

    static {
        texMap = null;
    }

    private static Object \u1887(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[2] == null) {
            Utils.\ub980[2] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u9123\u1c14\u14ba\ue5eb\u4d8a\uae3e\u7914\u482e\u4065\u3aab\ue545\uca91\u7e91\u21ad")), Utils$Utils.\u558f("\u7050\u8e90\u57ba\ua9f9\ucada\u913a"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[2];
    }

    private static Object \u9386(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[8] == null) {
            Utils.\ub980[8] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer$2.\ua76d("\ub159\ud72a\u0aa5\u2639\u9361\u18ec\ub664\ub43d\u2273\ucec0\ud4b3\u1805\u58e1\u7395\ub93b\u282b\uc15c\ubf00\u4684\ua8ae\u18f2\ua97e\u53ea")), JsonUtils$ACAttributePlayer$2.\ua76d("\ub152\ud73b\u0aa3\u263d\u9321\u18e4"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[8];
    }

    private static Object \ud03f(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[3] == null) {
            Utils.\ub980[3] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(JsonUtils$ACAttributePlayer$2.\ua76d("\ub159\ud72a\u0aa5\u2639\u9361\u18ec\ub664\ub43d\u2273\ucec0\ud4a9\u181f\u58e7\u7399\ub932\u2829\uc16c")), JsonUtils$ACAttributePlayer$2.\ua76d("\ub145\ud72a\u0abf\u262d\u932a\u18cf\ub663"), methodType).asType(methodType));
        }
        return \ub980[3];
    }

    private static Object \u9d5c(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[10] == null) {
            Utils.\ub980[10] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(JsonUtils$ACAttributePlayer$2.\ua76d("\ub159\ud72a\u0aa5\u2639\u9361\u18ec\ub664\ub43d\u2273\ucec0\ud4b3\u1805\u58e1\u7395\ub93b\u282b\uc15c\ubf00\u4684\ua8ae\u18f2\ua97e\u53ea")), JsonUtils$ACAttributePlayer$2.\ua76d("\ub147\ud724\u0a80\u262c\u933d\u18e9\ub66b\ub434"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[10];
    }

    private static Object \u6c41(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[0] == null) {
            Utils.\ub980[0] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u9123\u1c14\u14ba\ue5eb\u4d8a\uae37\u7907\u482f\u406c\u3a9f\ue568\uca88")), Utils$Utils.\u558f("\u705a\u8e91\u57a7\ua9eb\ucad3\u9122"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[0];
    }

    private static Object \u8c7f(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[11] == null) {
            Utils.\ub980[11] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u913a\u1c01\u14bd\ue5e0\u4d8a\uae36\u7908\u4828\u4061\u3ab5\ue56c\uca8a")), Utils$Utils.\u558f("\u7058\u8e9a\u57aa\ua9ee\ucad7\u913a\u1c15\u14b6"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[11];
    }

    private static Object \u1ea4(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[7] == null) {
            Utils.\ub980[7] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u9123\u1c14\u14ba\ue5eb\u4d8a\uae3e\u7914\u482e\u4065\u3aab\ue545\uca91\u7e91\u21ad")), Utils$Utils.\u558f("\u7052\u8e9b\u57b0\ua9cc\ucad7\u913f\u1c0e\u14a0"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[7];
    }

    private static Object \ua3c9(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[1] == null) {
            Utils.\ub980[1] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u9123\u1c14\u14ba\ue5eb\u4d8a\uae3e\u7914\u482e\u4065\u3aab\ue545\uca91\u7e91\u21ad")), Utils$Utils.\u558f("\u7058\u8e80\u57bb\ua9ca\ucad7\u9122\u1c0f\u14a1"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[1];
    }

    private static Object \u06c9(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[9] == null) {
            Utils.\ub980[9] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u913a\u1c01\u14bd\ue5e0\u4d8a\uae32\u7907\u4828\u406c")), Utils$Utils.\u558f("\u7052\u8e9b\u57ad"), methodType).asType(methodType));
        }
        return \ub980[9];
    }

    private static Object \u8ddd(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[4] == null) {
            Utils.\ub980[4] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u913a\u1c01\u14bd\ue5e0\u4d8a\uae2c\u7912\u482e\u406d\u3abc\ue56e\ucaba\u7e97\u21b0\u3d7a\uef1a\u3a66\u3118")), Utils$Utils.\u558f("\u7050\u8e84\u57ae\ua9dd\ucad8\u9132"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[4];
    }

    private static Object \u9866(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[5] == null) {
            Utils.\ub980[5] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u9123\u1c14\u14ba\ue5eb\u4d8a\uae37\u7907\u482f\u406c\u3a9f\ue568\uca88")), Utils$Utils.\u558f("\u7041\u8e81\u57aa"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[5];
    }

    private static Object \u37d0(Object object, String string, MethodType methodType) {
        if (\ub980 == null) {
            \ub980 = new Object[12];
        }
        if (\ub980[6] == null) {
            Utils.\ub980[6] = new ConstantCallSite(MethodHandles.lookup().findVirtual(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u913a\u1c01\u14bd\ue5e0\u4d8a\uae2c\u7912\u482e\u406d\u3abc\ue56e\ucaba\u7e97\u21b0\u3d7a\uef1a\u3a66\u3118")), Utils$Utils.\u558f("\u7050\u8e84\u57ae\ua9dd\ucad8\u9132"), methodType.dropParameterTypes(0, 1)).asType(methodType));
        }
        return \ub980[6];
    }

    public static enum FluidType {
        STILL,
        FLOWING;

        private static volatile transient Object[] \u0e1c;

        private static Object \ubf97(Object object, String string, MethodType methodType) {
            if (\u0e1c == null) {
                \u0e1c = new Object[1];
            }
            if (\u0e1c[0] == null) {
                FluidType.\u0e1c[0] = new ConstantCallSite(MethodHandles.lookup().findStatic(Class.forName(Utils$Utils.\u558f("\u705b\u8e95\u57a8\ua9d9\uca98\u913a\u1c01\u14bd\ue5e0\u4d8a\uae3a\u7908\u4829\u4069")), Utils$Utils.\u558f("\u7047\u8e95\u57b2\ua9cd\ucad3\u9119\u1c06"), methodType).asType(methodType));
            }
            return \u0e1c[0];
        }
    }
}

