/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.help.Help;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandRename
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world rename").get();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String newWorldName;
        String srcWorldName;
        if (arguments.equalsIgnoreCase("rename")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            srcWorldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        try {
            newWorldName = args[1];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalWorld = Sponge.getServer().getWorldProperties(srcWorldName);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, srcWorldName, " does not exist"}), false);
        }
        WorldProperties world = (WorldProperties)optionalWorld.get();
        if (Sponge.getServer().getWorldProperties(newWorldName).isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, newWorldName, " already exists"}), false);
        }
        Optional rename = Sponge.getServer().renameWorld(world, newWorldName);
        if (!rename.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Could not rename ", world.getWorldName()}), false);
        }
        source.sendMessage(Text.of((Object[])new Object[]{TextColors.DARK_GREEN, world.getWorldName(), " renamed to ", newWorldName, " successfully"}));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list = new ArrayList<String>();
        if (arguments.equalsIgnoreCase("rename")) {
            return list;
        }
        String[] args = arguments.split(" ");
        if (args.length != 1) {
            return list;
        }
        for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
            if (world.getWorldName().equalsIgnoreCase(args[args.length - 1])) {
                return list;
            }
            if (!world.getWorldName().toLowerCase().startsWith(args[args.length - 1].toLowerCase())) continue;
            list.add(world.getWorldName());
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

