/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.trentech.pjw.commands;

import com.gmail.trentech.pjc.core.TeleportManager;
import com.gmail.trentech.pjc.help.Help;
import com.gmail.trentech.pjw.utils.Rotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.format.TextColors;
import org.spongepowered.api.text.format.TextStyles;
import org.spongepowered.api.text.title.Title;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;
import org.spongepowered.api.world.storage.WorldProperties;

public class CommandTeleport
implements CommandCallable {
    private final Help help = (Help)Help.get((String)"world teleport").get();
    public static List<String> worlds = new ArrayList<String>();

    public CommandResult process(CommandSource source, String arguments) throws CommandException {
        String worldName;
        if (!(source instanceof Player)) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Must be a player"}), false);
        }
        Player player = (Player)source;
        if (arguments.equalsIgnoreCase("teleport")) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        String[] args = arguments.split(" ");
        if (args[args.length - 1].equalsIgnoreCase("--help")) {
            this.help.execute(source);
            return CommandResult.success();
        }
        try {
            worldName = args[0];
        }
        catch (Exception e) {
            throw new CommandException(this.getHelp().getUsageText());
        }
        Optional optionalProperties = Sponge.getServer().getWorldProperties(worldName);
        if (!optionalProperties.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, worldName, " does not exist"}), false);
        }
        WorldProperties properties = (WorldProperties)optionalProperties.get();
        Optional optionalWorld = Sponge.getServer().getWorld(worldName);
        if (!optionalWorld.isPresent()) {
            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, properties.getWorldName(), " is not loaded"}), false);
        }
        World world = (World)optionalWorld.get();
        Location location = world.getSpawnLocation();
        Rotation rotation = Rotation.getClosest(player.getRotation().getFloorY());
        if (args.length > 2) {
            boolean skip = false;
            for (int i = 1; i < args.length - 1; ++i) {
                Optional optionalLocation;
                String value;
                if (skip) {
                    skip = false;
                    continue;
                }
                String arg = args[i];
                try {
                    value = args[i + 1];
                }
                catch (Exception e) {
                    throw new CommandException(this.getHelp().getUsageText());
                }
                if (arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("-coords")) {
                    if (arg.equalsIgnoreCase("random")) {
                        optionalLocation = TeleportManager.getRandomLocation((World)world, (int)2000);
                        if (!optionalLocation.isPresent()) {
                            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Took to long to find a safe random location. Try again"}), false);
                        }
                        location = (Location)optionalLocation.get();
                    } else {
                        String[] coords = value.split(",");
                        try {
                            int x = Integer.parseInt(coords[0]);
                            int y = Integer.parseInt(coords[1]);
                            int z = Integer.parseInt(coords[2]);
                            location = world.getLocation(x, y, z);
                        }
                        catch (Exception e) {
                            throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, coords.toString(), " is not a valid Coordinate"}), true);
                        }
                    }
                } else if (arg.equalsIgnoreCase("-d") || arg.equalsIgnoreCase("-direction")) {
                    Optional<Rotation> optionalRotation = Rotation.get(value);
                    if (!optionalRotation.isPresent()) {
                        throw new CommandException(Text.of((Object[])new Object[]{TextColors.RED, "Incorrect direction"}));
                    }
                    rotation = optionalRotation.get();
                } else if (arg.equalsIgnoreCase("-f") || arg.equalsIgnoreCase("-force")) {
                    optionalLocation = TeleportManager.getSafeLocation((Location)location);
                    if (!optionalLocation.isPresent()) {
                        throw new CommandException(Text.of((Object[])new Object[]{Text.builder().color(TextColors.RED).append(new Text[]{Text.of((String)"Unsafe spawn point detected. ")}).onClick((ClickAction)TextActions.executeCallback((Consumer)TeleportManager.setUnsafeLocation((Location)location))).append(new Text[]{Text.of((Object[])new Object[]{TextColors.GOLD, TextStyles.UNDERLINE, "Click Here"})}).build(), TextColors.RED, " or use the -f flag to force teleport."}));
                    }
                    location = (Location)optionalLocation.get();
                } else {
                    source.sendMessage(Text.of((Object[])new Object[]{TextColors.YELLOW, arg, " is not a valid Flag"}));
                    throw new CommandException(this.getHelp().getUsageText());
                }
                skip = true;
            }
        }
        player.setLocationAndRotation(location, rotation.toVector3d());
        player.sendTitle(Title.of((Text)Text.of((Object[])new Object[]{TextColors.DARK_GREEN, properties.getWorldName()}), (Text)Text.of((Object[])new Object[]{TextColors.AQUA, "x: ", location.getBlockX(), ", y: ", location.getBlockY(), ", z: ", location.getBlockZ()})));
        return CommandResult.success();
    }

    public List<String> getSuggestions(CommandSource source, String arguments, Location<World> targetPosition) throws CommandException {
        ArrayList<String> list;
        block9: {
            String arg;
            String[] args;
            block8: {
                list = new ArrayList<String>();
                if (arguments.equalsIgnoreCase("teleport")) {
                    return list;
                }
                args = arguments.split(" ");
                if (args.length == 1) {
                    for (WorldProperties world : Sponge.getServer().getAllWorldProperties()) {
                        if (world.getWorldName().equalsIgnoreCase(args[0])) {
                            return list;
                        }
                        if (!world.getWorldName().toLowerCase().startsWith(args[0].toLowerCase())) continue;
                        list.add(world.getWorldName());
                    }
                    return list;
                }
                arg = args[args.length - 1];
                if (arg.equalsIgnoreCase("-c") || arg.equalsIgnoreCase("-coords") || arg.equalsIgnoreCase("-f") || arg.equalsIgnoreCase("-force")) {
                    return list;
                }
                if (!arg.equalsIgnoreCase("-d") && !arg.equalsIgnoreCase("-direction")) break block8;
                for (Rotation type : Rotation.values()) {
                    list.add(type.getName());
                }
                break block9;
            }
            String parent = args[args.length - 2];
            if (parent.equalsIgnoreCase("-c") || parent.equalsIgnoreCase("-coords") || parent.equalsIgnoreCase("-f") || parent.equalsIgnoreCase("-force")) {
                return list;
            }
            if (!parent.equalsIgnoreCase("-d") && !parent.equalsIgnoreCase("-direction")) break block9;
            for (Rotation type : Rotation.values()) {
                if (!type.getName().toLowerCase().startsWith(arg.toLowerCase())) continue;
                list.add(type.getName());
            }
        }
        return list;
    }

    public boolean testPermission(CommandSource source) {
        Optional permission = this.getHelp().getPermission();
        if (permission.isPresent()) {
            return source.hasPermission((String)permission.get());
        }
        return true;
    }

    public Optional<Text> getShortDescription(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Optional<Text> getHelp(CommandSource source) {
        return Optional.of(Text.of((String)this.getHelp().getDescription()));
    }

    public Text getUsage(CommandSource source) {
        return this.getHelp().getUsageText();
    }

    public Help getHelp() {
        return this.help;
    }
}

