/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.Tracker;
import cofh.thermaldynamics.util.WorldGridList;
import com.google.common.math.DoubleMath;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public abstract class MultiBlockGridTracking<T extends IGridTile>
extends MultiBlockGrid<T> {
    private Tracker tracker;

    public MultiBlockGridTracking(WorldGridList worldGrid) {
        super(worldGrid);
    }

    public MultiBlockGridTracking(World worldObj) {
        super(worldObj);
    }

    @Override
    public void addInfo(List<ITextComponent> info, EntityPlayer player, boolean debug) {
        super.addInfo(info, player, debug);
        this.addInfo(info, "tracker.cur", this.format(this.getLevel()));
        if (this.tracker == null) {
            info.add((ITextComponent)new TextComponentTranslation("info.thermaldynamics.info.tracker.activate", new Object[0]));
            this.getTracker();
            return;
        }
        this.tracker.life = 0;
        this.addInfo(info, "tracker.avg", this.format(this.tracker.avgStuff()) + this.getUnit());
        this.addInfo(info, "tracker.avgInOut", String.format("+%s%s/-%s%s", this.format(this.tracker.avgStuffIn()), this.getUnit(), this.format(this.tracker.avgStuffOut()), this.getUnit()));
    }

    @Override
    public void tickGrid() {
        super.tickGrid();
        if (this.tracker != null) {
            this.tracker.newTick(this.getLevel());
            if (this.tracker.life > 3600) {
                this.tracker = null;
            }
        }
    }

    public Tracker getTracker() {
        if (this.tracker == null) {
            this.tracker = new Tracker(this.getLevel());
        }
        this.tracker.life = 0;
        return this.tracker;
    }

    protected abstract int getLevel();

    protected abstract String getUnit();

    public int trackIn(int a, boolean simulate) {
        if (!simulate && this.tracker != null) {
            this.tracker.stuffIn(a);
        }
        return a;
    }

    public int trackOut(int a, boolean simulate) {
        if (!simulate && this.tracker != null) {
            this.tracker.stuffOut(a);
        }
        return a;
    }

    public int trackInOut(int a, boolean simulate) {
        if (!simulate && this.tracker != null) {
            this.tracker.stuffIn(a);
            this.tracker.stuffOut(a);
        }
        return a;
    }

    protected String format(double v) {
        if (v == 0.0) {
            return "0";
        }
        if (DoubleMath.isMathematicalInteger((double)v)) {
            return Integer.toString((int)v);
        }
        return String.format("%.2f", v);
    }
}

