/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.fluid;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.tile.fluid.TileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.inventory.ITileInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public abstract class TileFluidInventory
extends TileFluid
implements ITileInventory {
    @Nonnull
    private String inventoryName;
    @Nonnull
    private NonNullList<ItemStack> inventoryStacks;
    @Nonnull
    private InventoryConnection[] inventoryConnections;

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, int capacity, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(name, size, inventoryConnections, Lists.newArrayList((Object[])new Integer[]{capacity}), Lists.newArrayList((Object[])new Integer[]{capacity}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, @Nonnull List<Integer> capacity, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        this(name, size, inventoryConnections, capacity, capacity, allowedFluidsLists, fluidConnections);
    }

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, int capacity, int maxTransfer, List<String> allowedFluidsList, @Nonnull FluidConnection[] fluidConnections) {
        this(name, size, inventoryConnections, Lists.newArrayList((Object[])new Integer[]{capacity}), Lists.newArrayList((Object[])new Integer[]{maxTransfer}), Lists.newArrayList((Object[])new List[]{allowedFluidsList}), fluidConnections);
    }

    public TileFluidInventory(String name, int size, @Nonnull InventoryConnection[] inventoryConnections, @Nonnull List<Integer> capacity, @Nonnull List<Integer> maxTransfer, List<List<String>> allowedFluidsLists, @Nonnull FluidConnection[] fluidConnections) {
        super(capacity, maxTransfer, allowedFluidsLists, fluidConnections);
        this.inventoryName = "nuclearcraft.container." + name;
        this.inventoryStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        this.inventoryConnections = inventoryConnections;
    }

    public String func_70005_c_() {
        return this.inventoryName;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side) && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)new InvWrapper((IInventory)this));
        }
        return super.getCapability(capability, side);
    }
}

