/*
 * Decompiled with CFR 0.152.
 */
package com.mcsimonflash.sponge.activetime.api;

import com.mcsimonflash.sponge.activetime.managers.Storage;
import com.mcsimonflash.sponge.activetime.managers.Util;
import com.mcsimonflash.sponge.activetime.objects.ServerReport;
import com.mcsimonflash.sponge.activetime.objects.TimeHolder;
import com.mcsimonflash.sponge.activetime.objects.UserReport;
import java.time.LocalDate;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.spongepowered.api.entity.living.player.User;

public class ActiveTimeAPI {
    public static TimeHolder getTotalTime(User user) {
        return Storage.getTotalTime(user.getUniqueId());
    }

    public static TimeHolder getDailyTime(User user) {
        return Storage.getDailyTime(user.getUniqueId());
    }

    public static Optional<TimeHolder> getTime(User user, LocalDate date) {
        return Storage.getTime(user.getUniqueId(), date);
    }

    public static Optional<Integer> getDailyPlayTime(User user) {
        return user.getOption("playtime").map(Util::parseTime);
    }

    @Deprecated
    public static CompletableFuture<UserReport> getUserReport(User user, LocalDate from, LocalDate to) {
        return CompletableFuture.supplyAsync(() -> new UserReport(user.getUniqueId(), from, to).generate());
    }

    @Deprecated
    public static CompletableFuture<ServerReport> getServerReport(LocalDate from, LocalDate to) {
        return CompletableFuture.supplyAsync(() -> new ServerReport(from, to).generate());
    }
}

