/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.config.bases.AbstractStandardNodeConfig;
import io.github.nucleuspowered.nucleus.internal.messages.ResourceMessageProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import ninja.leaping.configurate.commented.CommentedConfigurationNode;
import ninja.leaping.configurate.commented.SimpleCommentedConfigurationNode;
import ninja.leaping.configurate.hocon.HoconConfigurationLoader;

public class MessageConfig
extends AbstractStandardNodeConfig<CommentedConfigurationNode, HoconConfigurationLoader> {
    private static final Pattern keys = Pattern.compile("\\{(\\d+)}");
    private final ResourceMessageProvider fallback;

    public MessageConfig(Path file, ResourceMessageProvider fallback) throws Exception {
        super(file, Maps.newHashMap(), false);
        Preconditions.checkNotNull((Object)fallback);
        this.fallback = fallback;
        this.load();
    }

    @Override
    protected CommentedConfigurationNode getDefaults() {
        SimpleCommentedConfigurationNode ccn = SimpleCommentedConfigurationNode.root();
        this.fallback.getKeys().forEach(arg_0 -> this.lambda$getDefaults$0((CommentedConfigurationNode)ccn, arg_0));
        return ccn;
    }

    @Override
    protected HoconConfigurationLoader getLoader(Path file) {
        return ((HoconConfigurationLoader.Builder)HoconConfigurationLoader.builder().setPath(file)).build();
    }

    public Optional<String> getKey(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key);
        Object[] obj = key.split("\\.");
        return Optional.ofNullable(((CommentedConfigurationNode)this.node).getNode(obj).getString());
    }

    public List<String> walkThroughForMismatched() {
        Matcher keyMatcher = keys.matcher("");
        ArrayList keysToFix = Lists.newArrayList();
        this.fallback.getKeys().forEach(x -> {
            String resKey = this.fallback.getMessageFromKey((String)x).get();
            Optional<String> msgKey = this.getKey((String)x);
            if (msgKey.isPresent() && this.getTokens(resKey, keyMatcher) != this.getTokens(msgKey.get(), keyMatcher)) {
                keysToFix.add(x);
            }
        });
        return keysToFix;
    }

    public void fixMistmatched(List<String> toFix) throws IOException {
        Preconditions.checkNotNull(toFix);
        toFix.forEach(x -> {
            String resKey = this.fallback.getMessageFromKey((String)x).get();
            Optional<String> msgKey = this.getKey((String)x);
            Object[] nodeKey = x.split("\\.");
            CommentedConfigurationNode cn = ((CommentedConfigurationNode)this.node).getNode(nodeKey).setValue((Object)resKey);
            msgKey.ifPresent(arg_0 -> ((CommentedConfigurationNode)cn).setComment(arg_0));
        });
        this.save();
    }

    private int getTokens(String message, Matcher matcher) {
        int result = -1;
        matcher.reset(message);
        while (matcher.find()) {
            result = Math.max(result, Integer.parseInt(matcher.group(1)));
        }
        return result;
    }

    private /* synthetic */ void lambda$getDefaults$0(CommentedConfigurationNode ccn, String x) {
        ccn.getNode((Object[])x.split("\\.")).setValue((Object)this.fallback.getMessageFromKey(x).get());
    }
}

