/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.configurate;

import com.flowpowered.math.vector.Vector3d;
import com.google.common.reflect.TypeToken;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.InstantTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NucleusItemStackSnapshotSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.NucleusTextTemplateTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.typeserialisers.Vector3dTypeSerialiser;
import io.github.nucleuspowered.nucleus.configurate.wrappers.NucleusItemStackSnapshot;
import io.github.nucleuspowered.nucleus.internal.text.NucleusTextTemplateImpl;
import io.github.nucleuspowered.relocate.nucleus.neutrino.objectmapper.NeutrinoObjectMapperFactory;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.ByteArrayTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.IntArrayTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.PatternTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.SetTypeSerialiser;
import io.github.nucleuspowered.relocate.nucleus.neutrino.typeserialisers.ShortArrayTypeSerialiser;
import java.time.Instant;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ninja.leaping.configurate.ConfigurationOptions;
import ninja.leaping.configurate.objectmapping.ObjectMapperFactory;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializer;
import ninja.leaping.configurate.objectmapping.serialize.TypeSerializerCollection;

public class ConfigurateHelper {
    private static TypeSerializerCollection typeSerializerCollection = null;
    private static final NeutrinoObjectMapperFactory objectMapperFactory;
    private static final Pattern commentPattern;

    private ConfigurateHelper() {
    }

    public static ConfigurationOptions setOptions(ConfigurationOptions options) {
        TypeSerializerCollection tsc = ConfigurateHelper.getNucleusTypeSerialiserCollection();
        return options.setSerializers(tsc).setObjectMapperFactory((ObjectMapperFactory)objectMapperFactory);
    }

    private static TypeSerializerCollection getNucleusTypeSerialiserCollection() {
        if (typeSerializerCollection != null) {
            return typeSerializerCollection;
        }
        typeSerializerCollection = ConfigurationOptions.defaults().getSerializers().newChild();
        typeSerializerCollection.registerType(TypeToken.of(Vector3d.class), (TypeSerializer)new Vector3dTypeSerialiser());
        typeSerializerCollection.registerType(TypeToken.of(NucleusItemStackSnapshot.class), (TypeSerializer)new NucleusItemStackSnapshotSerialiser());
        typeSerializerCollection.registerType(TypeToken.of(Pattern.class), (TypeSerializer)new PatternTypeSerialiser());
        typeSerializerCollection.registerType(TypeToken.of(NucleusTextTemplateImpl.class), (TypeSerializer)new NucleusTextTemplateTypeSerialiser());
        typeSerializerCollection.registerPredicate(typeToken -> Set.class.isAssignableFrom(typeToken.getRawType()), (TypeSerializer)new SetTypeSerialiser());
        typeSerializerCollection.registerType((TypeToken)new TypeToken<byte[]>(){}, (TypeSerializer)new ByteArrayTypeSerialiser());
        typeSerializerCollection.registerType((TypeToken)new TypeToken<short[]>(){}, (TypeSerializer)new ShortArrayTypeSerialiser());
        typeSerializerCollection.registerType((TypeToken)new TypeToken<int[]>(){}, (TypeSerializer)new IntArrayTypeSerialiser());
        typeSerializerCollection.registerType(TypeToken.of(Instant.class), (TypeSerializer)new InstantTypeSerialiser());
        return typeSerializerCollection;
    }

    static {
        commentPattern = Pattern.compile("^(loc:)?(?<key>([a-zA-Z0-9_-]+\\.?)+)$");
        objectMapperFactory = NeutrinoObjectMapperFactory.builder().setCommentProcessor(setting -> {
            Matcher matcher;
            String comment = setting.comment();
            if (comment.contains(".") && !comment.contains(" ") && (matcher = commentPattern.matcher(comment)).matches()) {
                return Nucleus.getNucleus().getMessageProvider().getMessageWithFormat(matcher.group("key"), new String[0]);
            }
            return comment;
        }).build(true);
    }
}

