/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.connection.listeners;

import com.google.common.collect.Maps;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.interfaces.ListenerBase;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.connection.config.ConnectionConfig;
import io.github.nucleuspowered.nucleus.modules.connection.config.ConnectionConfigAdapter;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.filter.Getter;
import org.spongepowered.api.event.filter.IsCancelled;
import org.spongepowered.api.event.network.ClientConnectionEvent;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.api.service.permission.Subject;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.TextRepresentable;
import org.spongepowered.api.util.Tristate;

public class ConnectionListener
implements Reloadable,
ListenerBase {
    private final String joinFullServer = "nucleus.connection.joinfullserver";
    private int reservedSlots = 0;
    @Nullable
    private Text whitelistMessage;
    @Nullable
    private Text fullMessage;

    @Listener(order=Order.FIRST)
    @IsCancelled(value=Tristate.TRUE)
    public void onPlayerJoinAndCancelled(ClientConnectionEvent.Login event, @Getter(value="getTargetUser") User user) {
        BanService banService = (BanService)Sponge.getServiceManager().provideUnchecked(BanService.class);
        if (banService.isBanned(user.getProfile()) || banService.isBanned(event.getConnection().getAddress().getAddress())) {
            return;
        }
        if (Sponge.getServer().hasWhitelist()) {
            if (this.whitelistMessage != null) {
                event.setMessage((TextRepresentable)this.whitelistMessage);
                event.setMessageCancelled(false);
            }
            return;
        }
        int slotsLeft = Sponge.getServer().getMaxPlayers() - Sponge.getServer().getOnlinePlayers().size();
        if (slotsLeft <= 0) {
            if (this.hasPermission((Subject)user, this.joinFullServer) && (this.reservedSlots <= -1 || -slotsLeft < this.reservedSlots)) {
                event.setCancelled(false);
                return;
            }
            if (this.fullMessage != null) {
                event.setMessage((TextRepresentable)this.fullMessage);
            }
        }
    }

    @Override
    public Map<String, PermissionInformation> getPermissions() {
        HashMap mp = Maps.newHashMap();
        mp.put(this.joinFullServer, PermissionInformation.getWithTranslation("permission.connection.joinfullserver", SuggestedLevel.MOD));
        return mp;
    }

    @Override
    public void onReload() {
        ConnectionConfig connectionConfig = (ConnectionConfig)Nucleus.getNucleus().getConfigAdapter("connection", ConnectionConfigAdapter.class).get().getNodeOrDefault();
        this.reservedSlots = connectionConfig.getReservedSlots();
        this.whitelistMessage = connectionConfig.getWhitelistMessage().orElse(null);
        this.fullMessage = connectionConfig.getServerFullMessage().orElse(null);
    }
}

