/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.item.commands;

import com.google.common.collect.Lists;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.argumentparsers.PositiveIntegerArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.interfaces.Reloadable;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfig;
import io.github.nucleuspowered.nucleus.modules.item.config.ItemConfigAdapter;
import io.github.nucleuspowered.nucleus.modules.item.config.SkullConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.data.key.Keys;
import org.spongepowered.api.data.type.SkullTypes;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.item.ItemTypes;
import org.spongepowered.api.item.inventory.Inventory;
import org.spongepowered.api.item.inventory.ItemStack;
import org.spongepowered.api.item.inventory.ItemStackSnapshot;
import org.spongepowered.api.item.inventory.entity.Hotbar;
import org.spongepowered.api.item.inventory.query.QueryOperation;
import org.spongepowered.api.item.inventory.query.QueryOperationTypes;
import org.spongepowered.api.item.inventory.transaction.InventoryTransactionResult;
import org.spongepowered.api.item.inventory.type.GridInventory;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RegisterCommand(value={"skull"})
@Permissions(supportsOthers=true)
@EssentialsEquivalent(value={"skull", "playerskull", "head"})
public class SkullCommand
extends AbstractCommand<Player>
implements Reloadable {
    private final String limitExemptPermission = Nucleus.getNucleus().getPermissionRegistry().getPermissionsForNucleusCommand(SkullCommand.class).getPermissionWithSuffix("exempt.limit");
    private final String amountKey = "amount";
    private final String player = "subject";
    private int amountLimit = Integer.MAX_VALUE;
    private boolean isUseMinecraftCommand = false;

    @Override
    public void onReload() {
        SkullConfig config = ((ItemConfig)((ItemConfigAdapter)this.getServiceUnchecked(ItemConfigAdapter.class)).getNodeOrDefault()).getSkullConfig();
        this.isUseMinecraftCommand = config.isUseMinecraftCommand();
        this.amountLimit = config.getSkullLimit();
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("exempt.limit", PermissionInformation.getWithTranslation("permission.skull.exempt.limit", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.player))), this.permissions.getPermissionWithSuffix("others"))), GenericArguments.optional((CommandElement)new PositiveIntegerArgument((Text)Text.of((String)this.amountKey)))};
    }

    @Override
    public CommandResult executeCommand(Player pl, CommandContext args, Cause cause) throws Exception {
        User user = this.getUserFromArgs(User.class, (CommandSource)pl, this.player, args);
        int amount = args.getOne(this.amountKey).orElse(1);
        if (amount > this.amountLimit && !pl.hasPermission(this.limitExemptPermission)) {
            throw ReturnMessageException.fromKey((CommandSource)pl, "command.skull.limit", this.amountLimit);
        }
        if (this.isUseMinecraftCommand) {
            CommandResult result = Sponge.getCommandManager().process((CommandSource)Sponge.getServer().getConsole(), String.format("minecraft:give %s skull %d 3 {SkullOwner:%s}", pl.getName(), amount, user.getName()));
            if (result.getSuccessCount().orElse(0) > 0) {
                this.sendMessageTo((CommandSource)pl, "command.skull.success.plural", new String[]{String.valueOf(amount), user.getName()});
                return result;
            }
            throw ReturnMessageException.fromKey((CommandSource)pl, "command.skull.error", user.getName());
        }
        int fullStacks = amount / 64;
        int partialStack = amount % 64;
        ItemStack skullStack = ItemStack.builder().itemType(ItemTypes.SKULL).quantity(64).build();
        if (skullStack.offer(Keys.SKULL_TYPE, (Object)SkullTypes.PLAYER).isSuccessful() && skullStack.offer(Keys.REPRESENTED_PLAYER, (Object)user.getProfile()).isSuccessful()) {
            ArrayList itemStackList = Lists.newArrayList();
            if (fullStacks > 0) {
                itemStackList.add(skullStack);
                for (int i = 2; i <= fullStacks; ++i) {
                    itemStackList.add(skullStack.copy());
                }
            }
            if (partialStack > 0) {
                ItemStack is = skullStack.copy();
                is.setQuantity(partialStack);
                itemStackList.add(is);
            }
            int accepted = 0;
            int failed = 0;
            Inventory inventoryToOfferTo = pl.getInventory().query(new QueryOperation[]{QueryOperationTypes.INVENTORY_TYPE.of(Hotbar.class), QueryOperationTypes.INVENTORY_TYPE.of(GridInventory.class)});
            for (ItemStack itemStack : itemStackList) {
                int stackSize = itemStack.getQuantity();
                InventoryTransactionResult itr = inventoryToOfferTo.offer(itemStack);
                int currentFail = itr.getRejectedItems().stream().mapToInt(ItemStackSnapshot::getQuantity).sum();
                failed += currentFail;
                accepted += stackSize - currentFail;
            }
            if (accepted > 0) {
                if (failed > 0) {
                    this.sendMessageTo((CommandSource)pl, "command.skull.semifull", new String[]{String.valueOf(failed)});
                }
                if (accepted == 1) {
                    this.sendMessageTo((CommandSource)pl, "command.skull.success.single", new String[]{user.getName()});
                } else {
                    this.sendMessageTo((CommandSource)pl, "command.skull.success.plural", new String[]{String.valueOf(accepted), user.getName()});
                }
                return CommandResult.success();
            }
            this.sendMessageTo((CommandSource)pl, "command.skull.full", new String[]{user.getName()});
            return CommandResult.empty();
        }
        this.sendMessageTo((CommandSource)pl, "command.skull.error", new String[]{user.getName()});
        return CommandResult.empty();
    }
}

