/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.kick.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.NoModifiers;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.NucleusParameters;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.channel.MessageChannel;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.text.serializer.TextSerializers;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions(suggestedLevel=SuggestedLevel.MOD)
@NoModifiers
@NonnullByDefault
@RegisterCommand(value={"kickall"})
@EssentialsEquivalent(value={"kickall"})
public class KickAllCommand
extends AbstractCommand<CommandSource> {
    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.flags().permissionFlag(this.permissions.getPermissionWithSuffix("whitelist"), new String[]{"w", "f"}).buildWith(NucleusParameters.OPTIONAL_REASON)};
    }

    @Override
    public Map<String, PermissionInformation> permissionSuffixesToRegister() {
        HashMap<String, PermissionInformation> m = new HashMap<String, PermissionInformation>();
        m.put("whitelist", PermissionInformation.getWithTranslation("permission.kickall.whitelist", SuggestedLevel.ADMIN));
        return m;
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) {
        String r = args.getOne("reason").orElseGet(() -> Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("command.kick.defaultreason", new String[0]));
        boolean f = args.getOne("w").orElse(false);
        if (f) {
            Sponge.getServer().setHasWhitelist(true);
        }
        Sponge.getServer().getOnlinePlayers().stream().filter(x -> !(src instanceof Player) || !((Player)src).getUniqueId().equals(x.getUniqueId())).collect(Collectors.toList()).forEach(x -> x.kick(TextSerializers.FORMATTING_CODE.deserialize(r)));
        MessageChannel mc = MessageChannel.fixed((MessageReceiver[])new MessageReceiver[]{Sponge.getServer().getConsole(), src});
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kickall.message", new String[0]));
        mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.reason", r));
        if (f) {
            mc.send(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.kickall.whitelist", new String[0]));
        }
        return CommandResult.success();
    }
}

