/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.nickname.commands;

import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.modules.nickname.services.NicknameService;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@NonnullByDefault
@RegisterCommand(value={"delnick", "delnickname", "deletenick"})
@Permissions(mainOverride="nick")
public class DelNickCommand
extends AbstractCommand<CommandSource> {
    private final NicknameService nicknameService = (NicknameService)this.getServiceUnchecked(NicknameService.class);
    private final String playerKey = "subject";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optional((CommandElement)this.requirePermissionArg(GenericArguments.onlyOne((CommandElement)GenericArguments.user((Text)Text.of((String)this.playerKey))), this.permissions.getPermissionWithSuffix("others")))};
    }

    @Override
    public CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User pl = this.getUserFromArgs(User.class, src, this.playerKey, args);
        this.nicknameService.removeNick(pl, src);
        if (!src.equals(pl)) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.delnick.success.other", pl.getName()));
        }
        return CommandResult.success();
    }
}

