/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import io.github.nucleuspowered.nucleus.NameUtil;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.Util;
import io.github.nucleuspowered.nucleus.argumentparsers.RegexArgument;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.annotation.NonnullByDefault;

@Permissions
@RegisterCommand(value={"getfromip"})
@NonnullByDefault
public class GetFromIpCommand
extends AbstractCommand<CommandSource> {
    private final String ipKey = "IP Address";

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{new RegexArgument((Text)Text.of((String)this.ipKey), "^(\\d{1,3}\\.){3}\\d{1,3}$", "command.getfromip.notvalid")};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        String ip = (String)args.requireOne(this.ipKey);
        if (Arrays.stream(ip.split("\\.")).anyMatch(x -> Integer.parseInt(x) > 255)) {
            throw ReturnMessageException.fromKey("command.getfromip.notvalid", new Object[0]);
        }
        UserStorageService uss = (UserStorageService)Sponge.getServiceManager().provideUnchecked(UserStorageService.class);
        List users = Nucleus.getNucleus().getUserCacheService().getForIp(ip).stream().map(arg_0 -> ((UserStorageService)uss).get(arg_0)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (users.isEmpty()) {
            this.sendMessageTo(src, "command.getfromip.nousers");
            return CommandResult.success();
        }
        NameUtil name = Nucleus.getNucleus().getNameUtil();
        Util.getPaginationBuilder(src).title(this.getMessageFor(src, "command.getfromip.title", new String[]{ip})).contents((Iterable)users.stream().map(y -> {
            Text n = name.getName((User)y);
            return n.toBuilder().onClick((ClickAction)TextActions.runCommand((String)("/nucleus:seen " + y.getName()))).onHover((HoverAction)TextActions.showText((Text)this.getMessageFor(src, "command.getfromip.hover", new Text[]{n}))).build();
        }).collect(Collectors.toList())).sendTo((MessageReceiver)src);
        return CommandResult.success();
    }
}

