/*
 * Decompiled with CFR 0.152.
 */
package io.github.nucleuspowered.nucleus.modules.playerinfo.commands;

import com.flowpowered.math.vector.Vector3i;
import io.github.nucleuspowered.nucleus.Nucleus;
import io.github.nucleuspowered.nucleus.internal.annotations.command.Permissions;
import io.github.nucleuspowered.nucleus.internal.annotations.command.RegisterCommand;
import io.github.nucleuspowered.nucleus.internal.command.AbstractCommand;
import io.github.nucleuspowered.nucleus.internal.command.ReturnMessageException;
import io.github.nucleuspowered.nucleus.internal.docgen.annotations.EssentialsEquivalent;
import io.github.nucleuspowered.nucleus.internal.permissions.PermissionInformation;
import io.github.nucleuspowered.nucleus.internal.permissions.SuggestedLevel;
import io.github.nucleuspowered.nucleus.modules.core.datamodules.CoreUserDataModule;
import java.util.Map;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.command.args.CommandContext;
import org.spongepowered.api.command.args.CommandElement;
import org.spongepowered.api.command.args.GenericArguments;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.event.cause.Cause;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.action.ClickAction;
import org.spongepowered.api.text.action.HoverAction;
import org.spongepowered.api.text.action.TextActions;
import org.spongepowered.api.util.annotation.NonnullByDefault;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

@Permissions(suggestedLevel=SuggestedLevel.USER, supportsOthers=true)
@RegisterCommand(value={"getpos", "coords", "position", "whereami", "getlocation", "getloc"})
@EssentialsEquivalent(value={"getpos", "coords", "position", "whereami", "getlocation", "getloc"})
@NonnullByDefault
public class GetPosCommand
extends AbstractCommand<CommandSource> {
    private final String playerKey = "subject";

    @Override
    protected Map<String, PermissionInformation> permissionSuffixesToRegister() {
        Map<String, PermissionInformation> mspi = super.permissionSuffixesToRegister();
        mspi.put("others", new PermissionInformation(Nucleus.getNucleus().getMessageProvider().getMessageWithFormat("permission.getpos.others", new String[0]), SuggestedLevel.MOD));
        return mspi;
    }

    @Override
    public CommandElement[] getArguments() {
        return new CommandElement[]{GenericArguments.optionalWeak((CommandElement)this.requirePermissionArg(GenericArguments.user((Text)Text.of((String)this.playerKey)), this.permissions.getOthers()))};
    }

    @Override
    protected CommandResult executeCommand(CommandSource src, CommandContext args, Cause cause) throws Exception {
        User user = this.getUserFromArgs(User.class, src, this.playerKey, args);
        Location<World> location = user.isOnline() ? ((Player)user.getPlayer().get()).getLocation() : Nucleus.getNucleus().getUserDataManager().get(user).orElseThrow(() -> ReturnMessageException.fromKey("command.getpos.location.nolocation", user.getName())).get(CoreUserDataModule.class).getLogoutLocation().orElseThrow(() -> ReturnMessageException.fromKey("command.getpos.location.nolocation", user.getName()));
        boolean isSelf = src instanceof Player && ((Player)src).getUniqueId().equals(user.getUniqueId());
        Vector3i blockPos = location.getBlockPosition();
        if (isSelf) {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.getpos.location.self", ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ())));
        } else {
            src.sendMessage(Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.getpos.location.other", Nucleus.getNucleus().getNameUtil().getSerialisedName(user), ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ())).toBuilder().onClick((ClickAction)TextActions.runCommand((String)String.join((CharSequence)" ", "/nucleus:tppos", ((World)location.getExtent()).getName(), String.valueOf(blockPos.getX()), String.valueOf(blockPos.getY()), String.valueOf(blockPos.getZ())))).onHover((HoverAction)TextActions.showText((Text)Nucleus.getNucleus().getMessageProvider().getTextMessageWithFormat("command.getpos.hover", new String[0]))).build());
        }
        return CommandResult.success();
    }
}

