/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.base.util.info;

import ic2.api.classic.tile.IInfoTile;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.block.base.util.info.misc.IProbeComponent;
import ic2.core.block.crop.Ic2Crops;
import ic2.core.platform.lang.storage.Ic2GuiLang;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.player.PlayerHandler;
import java.awt.Color;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Optional;

public class CropProbeComponent
implements IProbeComponent {
    ICropTile tile;
    CropInfoType type;

    public CropProbeComponent(ICropTile tile, CropInfoType type) {
        this.tile = tile;
        this.type = type;
    }

    @Override
    public String getDisplayText(EntityPlayer player) {
        CropCard card = this.tile.getCrop();
        int size = this.tile.getCurrentSize();
        int maxSize = card == null ? 0 : card.getMaxSize();
        int scan = this.tile.getScanLevel();
        boolean show = scan >= 1 || card != null && size >= maxSize;
        boolean showAll = scan >= 4 || card != null && size >= maxSize;
        String unknown = Ic2GuiLang.cropUnknown.getLocalized();
        switch (this.type) {
            case CropType: {
                return TextFormatting.GRAY + (card == null || !show ? Ic2InfoLang.cropUnknown.getLocalizedFormatted(TextFormatting.WHITE) : Ic2InfoLang.cropName.getLocalizedFormatted(Ic2Crops.instance.getCropName(card), card.getDiscoveredBy(), TextFormatting.WHITE)) + TextFormatting.RESET;
            }
            case GrowthStep: {
                return TextFormatting.GRAY + Ic2InfoLang.cropSize.getLocalizedFormatted(size, showAll ? Integer.valueOf(maxSize) : unknown, TextFormatting.GREEN) + TextFormatting.RESET;
            }
            case Growth: {
                return TextFormatting.GRAY + Ic2InfoLang.cropGrowthPoints.getLocalizedFormatted(card == null || !showAll ? unknown : Integer.valueOf(this.tile.getGrowthPoints()), card == null ? unknown : Integer.valueOf(card.getGrowthDuration(this.tile)), TextFormatting.GREEN) + TextFormatting.RESET;
            }
            case NutrientStorage: {
                return TextFormatting.GRAY + Ic2InfoLang.cropNutrient.getLocalizedFormatted(this.tile.getStorageNutrients(), 200, TextFormatting.DARK_GREEN) + TextFormatting.RESET;
            }
            case Hydration: {
                return TextFormatting.GRAY + Ic2InfoLang.cropWater.getLocalizedFormatted(this.tile.getStorageWater(), 200, TextFormatting.BLUE) + TextFormatting.RESET;
            }
            case WeedEx: {
                return TextFormatting.GRAY + Ic2InfoLang.cropWeedEx.getLocalizedFormatted(this.tile.getStorageWeedEX(), 150, TextFormatting.RED) + TextFormatting.RESET;
            }
            case NutrientBoost: {
                return TextFormatting.GRAY + Ic2InfoLang.cropNutrientPoints.getLocalizedFormatted(this.tile.getTerrainNutrients(), TextFormatting.DARK_GREEN) + TextFormatting.RESET;
            }
            case Humidity: {
                return TextFormatting.GRAY + Ic2InfoLang.cropHumidityPoints.getLocalizedFormatted(this.tile.getTerrainHumidity(), TextFormatting.GREEN) + TextFormatting.RESET;
            }
            case AirQuality: {
                return TextFormatting.GRAY + Ic2InfoLang.cropAirPoints.getLocalizedFormatted(this.tile.getTerrainAirQuality(), TextFormatting.BLUE) + TextFormatting.RESET;
            }
            case GrowthStat: {
                return TextFormatting.GRAY + Ic2InfoLang.cropGrowStat.getLocalizedFormatted(showAll ? Integer.valueOf(this.tile.getStatGrowth()) : unknown, TextFormatting.GREEN) + TextFormatting.RESET;
            }
            case GainStat: {
                return TextFormatting.GRAY + Ic2InfoLang.cropGainStat.getLocalizedFormatted(showAll ? Integer.valueOf(this.tile.getStatGain()) : unknown, TextFormatting.YELLOW) + TextFormatting.RESET;
            }
            case ResistanceStat: {
                return TextFormatting.GRAY + Ic2InfoLang.cropResistanceStat.getLocalizedFormatted(showAll ? Integer.valueOf(this.tile.getStatResistance()) : unknown, TextFormatting.BLUE) + TextFormatting.RESET;
            }
        }
        return unknown;
    }

    @Override
    public boolean canShow(EntityPlayer player) {
        return PlayerHandler.getClientPlayerHandler().hasCropanalyzer();
    }

    @Override
    public IInfoTile.InfoType getType() {
        return IInfoTile.InfoType.Crop;
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public boolean isModeValid(ProbeMode mode, PlayerHandler handler) {
        return mode != ProbeMode.NORMAL && handler.hasCropanalyzer();
    }

    @Override
    @Optional.Method(modid="theoneprobe")
    public void applyInfo(IProbeInfo info, EntityPlayer player, EnumFacing side) {
        boolean show;
        CropCard card = this.tile.getCrop();
        int size = this.tile.getCurrentSize();
        int maxSize = card == null ? 0 : card.getMaxSize();
        int scan = this.tile.getScanLevel();
        boolean bl = show = scan >= 4 || card != null && size >= maxSize;
        if (this.type == CropInfoType.Growth) {
            info.progress(size, show ? maxSize : 0, info.defaultProgressStyle().filledColor(Color.GREEN.getRGB()).prefix("Crop Size: "));
        } else if (this.type == CropInfoType.GrowthStep) {
            info.progress(show ? this.tile.getGrowthPoints() : 0, show ? card.getGrowthDuration(this.tile) : 0, info.defaultProgressStyle().filledColor(Color.GREEN.getRGB()).prefix("GrowthPoints: "));
        } else if (this.type == CropInfoType.NutrientStorage) {
            info.progress(this.tile.getStorageNutrients(), 200, info.defaultProgressStyle().filledColor(Color.MAGENTA.getRGB()).prefix("Nutrient Storage: "));
        } else if (this.type == CropInfoType.Hydration) {
            info.progress(this.tile.getStorageWater(), 200, info.defaultProgressStyle().filledColor(Color.BLUE.getRGB()).prefix("Water Storage: "));
        } else if (this.type == CropInfoType.WeedEx) {
            info.progress(this.tile.getStorageWeedEX(), 150, info.defaultProgressStyle().filledColor(Color.RED.getRGB()).prefix("WeedEx Storage: "));
        } else if (this.type == CropInfoType.NutrientBoost) {
            info.progress(this.tile.getTerrainNutrients(), 20, info.defaultProgressStyle().filledColor(Color.MAGENTA.getRGB()).prefix("Nutrients: "));
        } else if (this.type == CropInfoType.Humidity) {
            info.progress(this.tile.getTerrainHumidity(), 20, info.defaultProgressStyle().filledColor(Color.BLUE.getRGB()).prefix("Humidity: "));
        } else if (this.type == CropInfoType.AirQuality) {
            info.progress(this.tile.getTerrainAirQuality(), 10, info.defaultProgressStyle().filledColor(Color.YELLOW.getRGB()).prefix("Air Quality: "));
        } else if (this.type == CropInfoType.GrowthStat) {
            info.progress(show ? this.tile.getStatGrowth() : 0, 31, info.defaultProgressStyle().filledColor(Color.GREEN.getRGB()).prefix("Stat Growth: "));
        } else if (this.type == CropInfoType.GainStat) {
            info.progress(show ? this.tile.getStatGain() : 0, 31, info.defaultProgressStyle().filledColor(Color.YELLOW.getRGB()).prefix("Stat Gain: "));
        } else if (this.type == CropInfoType.ResistanceStat) {
            info.progress(show ? this.tile.getStatResistance() : 0, 31, info.defaultProgressStyle().filledColor(Color.BLUE.getRGB()).prefix("Stat Resistance: "));
        } else {
            info.text(this.getDisplayText(player));
        }
    }

    public static enum CropInfoType {
        CropType,
        Growth,
        GrowthStep,
        NutrientStorage,
        Hydration,
        WeedEx,
        NutrientBoost,
        Humidity,
        AirQuality,
        GrowthStat,
        GainStat,
        ResistanceStat;

    }
}

