/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.generator.container;

import ic2.api.classic.reactor.ISteamReactor;
import ic2.core.block.base.tile.TileEntityNuclearReactorBase;
import ic2.core.inventory.container.ContainerTileComponent;
import ic2.core.inventory.gui.GuiIC2;
import ic2.core.inventory.slots.SlotReactor;
import ic2.core.platform.registry.Ic2Resources;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ContainerNuclearReactor
extends ContainerTileComponent<TileEntityNuclearReactorBase> {
    public int size;
    public boolean isSteam;

    public ContainerNuclearReactor(InventoryPlayer player, TileEntityNuclearReactorBase tile) {
        super(tile);
        this.isSteam = tile instanceof ISteamReactor;
        this.size = tile.getReactorSize();
        int startX = 89 - 9 * this.size;
        int startY = 18;
        int x = 0;
        int y = 0;
        for (int i = 0; i < 54; ++i) {
            if (x < this.size) {
                this.func_75146_a(new SlotReactor(tile, i, startX + 18 * x, startY + 18 * y));
            }
            if (++x < 9) continue;
            ++y;
            x = 0;
        }
        this.addPlayerInventory(player, 0, 56);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onGuiLoaded(GuiIC2 gui) {
        gui.setMaxGuiY(222);
    }

    @Override
    public int guiInventorySize() {
        return 6 * this.size;
    }

    @Override
    public ResourceLocation getTexture() {
        return Ic2Resources.nuclearReactor[this.size - 3];
    }
}

